/*
 * Decompiled with CFR 0.152.
 */
package mrnerdy42.keywizard.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Objects;
import mrnerdy42.keywizard.forge.KeyWizard;
import mrnerdy42.keywizard.gui.CategorySelectorWidget;
import mrnerdy42.keywizard.gui.KeyBindingListWidget;
import mrnerdy42.keywizard.gui.KeyboardWidget;
import mrnerdy42.keywizard.gui.KeyboardWidgetBuilder;
import mrnerdy42.keywizard.util.KeyBindingUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.screen.ControlsScreen;
import net.minecraft.client.gui.screen.IScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.SettingsScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.Nullable;

public class KeyWizardScreen
extends SettingsScreen {
    private final int[] mouseCodes = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private int mouseCodeIndex = 0;
    private KeyboardWidget keyboard;
    private KeyboardWidget mouseButton;
    private Button mousePlus;
    private Button mouseMinus;
    private KeyBindingListWidget bindingList;
    private CategorySelectorWidget categorySelector;
    private ImageButton screenToggleButton;
    private TextFieldWidget searchBar;
    private Button resetBinding;
    private Button resetAll;
    private Button clearBinding;

    public KeyWizardScreen(Screen parent) {
        super(parent, Minecraft.func_71410_x().field_71474_y, ITextComponent.func_244388_a((String)"keywizard"));
    }

    protected void func_231160_c_() {
        int mouseButtonX = this.field_230708_k_ - 105;
        int mouseButtonY = this.field_230709_l_ / 2 - 115;
        int mouseButtonWidth = 80;
        int mouseButtonHeight = 20;
        int maxBindingNameWidth = 0;
        for (KeyBinding k : this.field_230706_i_.field_71474_y.field_74324_K) {
            int w = this.field_230712_o_.func_238414_a_((ITextProperties)new TranslationTextComponent(k.func_151464_g()));
            if (w <= maxBindingNameWidth) continue;
            maxBindingNameWidth = w;
        }
        int maxCategoryWidth = 0;
        for (String s : KeyBindingUtil.getCategories()) {
            int w = this.field_230712_o_.func_238414_a_((ITextProperties)new TranslationTextComponent(s));
            if (w <= maxCategoryWidth) continue;
            maxCategoryWidth = w;
        }
        int bindingListWidth = maxBindingNameWidth + 20;
        Objects.requireNonNull(this.field_230712_o_);
        this.bindingList = new KeyBindingListWidget(this, 10, 10, bindingListWidth, this.field_230709_l_ - 40, 9 * 3 + 10);
        this.keyboard = KeyboardWidgetBuilder.standardKeyboard(this, bindingListWidth + 15, this.field_230709_l_ / 2 - 90, this.field_230708_k_ - (bindingListWidth + 15), 180.0f);
        this.categorySelector = new CategorySelectorWidget(this, bindingListWidth + 15, 5, maxCategoryWidth + 20, 20);
        this.screenToggleButton = new ImageButton(this.field_230708_k_ - 22, this.field_230709_l_ - 22, 20, 20, 20, 0, 20, KeyWizard.SCREEN_TOGGLE_WIDGETS, 40, 40, btn -> this.field_230706_i_.func_147108_a((Screen)new ControlsScreen(this.field_228182_a_, this.field_228183_b_)));
        this.searchBar = new TextFieldWidget(this.field_230712_o_, 10, this.field_230709_l_ - 20, bindingListWidth, 14, ITextComponent.func_244388_a((String)""));
        this.mouseButton = KeyboardWidgetBuilder.singleKeyKeyboard(this, mouseButtonX, mouseButtonY, mouseButtonWidth, mouseButtonHeight, this.mouseCodes[this.mouseCodeIndex], InputMappings.Type.MOUSE);
        this.mousePlus = new Button((int)this.mouseButton.getAnchorX() + 83, (int)this.mouseButton.getAnchorY(), 25, 20, ITextComponent.func_244388_a((String)"+"), btn -> {
            ++this.mouseCodeIndex;
            if (this.mouseCodeIndex >= this.mouseCodes.length) {
                this.mouseCodeIndex = 0;
            }
            this.field_230705_e_.remove((Object)this.mouseButton);
            this.mouseButton = KeyboardWidgetBuilder.singleKeyKeyboard(this, mouseButtonX, mouseButtonY, mouseButtonWidth, mouseButtonHeight, this.mouseCodes[this.mouseCodeIndex], InputMappings.Type.MOUSE);
            this.field_230705_e_.add(this.mouseButton);
        });
        this.mouseMinus = new Button((int)this.mouseButton.getAnchorX() - 26, (int)this.mouseButton.getAnchorY(), 25, 20, ITextComponent.func_244388_a((String)"-"), btn -> {
            --this.mouseCodeIndex;
            if (this.mouseCodeIndex < 0) {
                this.mouseCodeIndex = this.mouseCodes.length - 1;
            }
            this.field_230705_e_.remove((Object)this.mouseButton);
            this.mouseButton = KeyboardWidgetBuilder.singleKeyKeyboard(this, mouseButtonX, mouseButtonY, mouseButtonWidth, mouseButtonHeight, this.mouseCodes[this.mouseCodeIndex], InputMappings.Type.MOUSE);
            this.field_230705_e_.add(this.mouseButton);
        });
        this.resetBinding = new Button(bindingListWidth + 15, this.field_230709_l_ - 23, 50, 20, (ITextComponent)new TranslationTextComponent("controls.reset"), btn -> {
            KeyBinding selectedBinding = this.getSelectedKeyBinding();
            selectedBinding.func_197979_b(selectedBinding.func_197977_i());
            KeyBinding.func_74508_b();
        });
        this.clearBinding = new Button(bindingListWidth + 66, this.field_230709_l_ - 23, 50, 20, (ITextComponent)new TranslationTextComponent("gui.clear"), btn -> {
            KeyBinding selectedBinding = this.getSelectedKeyBinding();
            selectedBinding.func_197979_b(InputMappings.Type.KEYSYM.func_197944_a(-1));
            KeyBinding.func_74508_b();
        });
        this.resetAll = new Button(bindingListWidth + 117, this.field_230709_l_ - 23, 70, 20, (ITextComponent)new TranslationTextComponent("controls.resetAll"), btn -> {
            for (KeyBinding b : this.field_228183_b_.field_74324_K) {
                b.func_197979_b(b.func_197977_i());
            }
            KeyBinding.func_74508_b();
        });
        this.func_230481_d_((IGuiEventListener)this.bindingList);
        this.func_230481_d_((IGuiEventListener)this.keyboard);
        this.func_230481_d_((IGuiEventListener)this.categorySelector);
        this.func_230481_d_(this.categorySelector.getCategoryList());
        this.func_230481_d_((IGuiEventListener)this.screenToggleButton);
        this.func_230481_d_((IGuiEventListener)this.searchBar);
        this.func_230481_d_((IGuiEventListener)this.mouseButton);
        this.func_230481_d_((IGuiEventListener)this.mousePlus);
        this.func_230481_d_((IGuiEventListener)this.mouseMinus);
        this.func_230481_d_((IGuiEventListener)this.resetBinding);
        this.func_230481_d_((IGuiEventListener)this.clearBinding);
        this.func_230481_d_((IGuiEventListener)this.resetAll);
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.func_230446_a_(matrices);
        for (IGuiEventListener e : this.field_230705_e_) {
            if (!(e instanceof IRenderable)) continue;
            ((IRenderable)e).func_230430_a_(matrices, mouseX, mouseY, delta);
        }
    }

    public void func_231023_e_() {
        for (IGuiEventListener e : this.field_230705_e_) {
            if (!(e instanceof IScreen)) continue;
            ((IScreen)e).func_231023_e_();
        }
    }

    @Nullable
    public KeyBinding getSelectedKeyBinding() {
        return this.bindingList.getSelectedKeyBinding();
    }

    public boolean getCategorySelectorExtended() {
        return this.categorySelector.extended;
    }

    public String getSelectedCategory() {
        return this.categorySelector.getSelctedCategory();
    }

    public String getFilterText() {
        return this.searchBar.func_146179_b();
    }

    public void setSearchText(String s) {
        this.searchBar.func_146180_a(s);
    }
}

