/*
 * Decompiled with CFR 0.152.
 */
package mrnerdy42.keywizard.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import mrnerdy42.keywizard.gui.KeyWizardScreen;
import mrnerdy42.keywizard.mixin.KeyBindingAccessor;
import mrnerdy42.keywizard.util.DrawingUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FocusableGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.screen.IScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class KeyboardWidget
extends FocusableGui
implements IRenderable,
IScreen {
    public KeyWizardScreen keyWizardScreen;
    private HashMap<Integer, KeyboardKeyWidget> keys = new HashMap();
    private float anchorX;
    private float anchorY;

    protected KeyboardWidget(KeyWizardScreen keyWizardScreen, float anchorX, float anchorY) {
        this.keyWizardScreen = keyWizardScreen;
        this.anchorX = anchorX;
        this.anchorY = anchorY;
    }

    public float addKey(float relativeX, float relativeY, float width, float height, float keySpacing, int keyCode) {
        this.keys.put(keyCode, new KeyboardKeyWidget(keyCode, this.anchorX + relativeX, this.anchorY + relativeY, width, height, InputMappings.Type.KEYSYM));
        return relativeX + width + keySpacing;
    }

    public float addKey(float relativeX, float relativeY, float width, float height, float keySpacing, int keyCode, InputMappings.Type keyType) {
        this.keys.put(keyCode, new KeyboardKeyWidget(keyCode, this.anchorX + relativeX, this.anchorY + relativeY, width, height, keyType));
        return relativeX + width + keySpacing;
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        List<? extends KeyboardKeyWidget> keys = this.func_231039_at__();
        for (KeyboardKeyWidget keyboardKeyWidget : keys) {
            keyboardKeyWidget.func_230430_a_(matrices, mouseX, mouseY, delta);
        }
        if (!this.keyWizardScreen.getCategorySelectorExtended()) {
            for (KeyboardKeyWidget keyboardKeyWidget : keys) {
                if (!keyboardKeyWidget.field_230693_o_ || !keyboardKeyWidget.func_230449_g_()) continue;
                this.keyWizardScreen.func_243308_b(matrices, keyboardKeyWidget.tooltipText, mouseX, mouseY);
            }
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (!this.keyWizardScreen.getCategorySelectorExtended()) {
            for (KeyboardKeyWidget keyboardKeyWidget : this.func_231039_at__()) {
                if (!keyboardKeyWidget.func_231044_a_(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return false;
    }

    public List<? extends KeyboardKeyWidget> func_231039_at__() {
        return new ArrayList<KeyboardKeyWidget>(this.keys.values());
    }

    public void func_231023_e_() {
        for (KeyboardKeyWidget keyboardKeyWidget : this.func_231039_at__()) {
            keyboardKeyWidget.func_231023_e_();
        }
    }

    public float getAnchorX() {
        return this.anchorX;
    }

    public float getAnchorY() {
        return this.anchorY;
    }

    public class KeyboardKeyWidget
    extends AbstractButton
    implements IScreen {
        public float x;
        public float y;
        protected float width;
        protected float height;
        private InputMappings.Input key;
        private List<ITextComponent> tooltipText;

        protected KeyboardKeyWidget(int keyCode, float x, float y, float width, float height, InputMappings.Type keyType) {
            super((int)x, (int)y, (int)width, (int)height, ITextComponent.func_244388_a((String)""));
            this.tooltipText = new ArrayList<ITextComponent>();
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.key = keyType.func_197944_a(keyCode);
            this.func_238482_a_(this.key.func_237520_d_());
        }

        public void func_230431_b_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
            int bindingCount = this.tooltipText.size();
            int color = 0;
            if (this.field_230693_o_) {
                if (this.func_230449_g_() && !KeyboardWidget.this.keyWizardScreen.getCategorySelectorExtended()) {
                    color = -5592406;
                    if (bindingCount == 1) {
                        color = -16733696;
                    } else if (bindingCount > 1) {
                        color = -5636096;
                    }
                } else {
                    color = -1;
                    if (bindingCount == 1) {
                        color = -16711936;
                    } else if (bindingCount > 1) {
                        color = -65536;
                    }
                }
            } else {
                color = -11184811;
            }
            DrawingUtil.drawNoFillRect(matrices, this.x, this.y, this.x + this.width, this.y + this.height, color);
            FontRenderer textRenderer = Minecraft.func_71410_x().field_71466_p;
            textRenderer.func_243246_a(matrices, this.func_230458_i_(), this.x + this.width / 2.0f - (float)(textRenderer.func_238414_a_((ITextProperties)this.func_230458_i_()) / 2), this.y + (this.height - 6.0f) / 2.0f, color);
        }

        public void func_230930_b_() {
            this.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
            if (Screen.func_231173_s_()) {
                ITextComponent t = this.func_230458_i_();
                String keyName = t instanceof TranslationTextComponent ? I18n.func_135052_a((String)((TranslationTextComponent)t).func_150268_i(), (Object[])new Object[0]) : t.func_150261_e();
                KeyboardWidget.this.keyWizardScreen.setSearchText("<" + keyName + ">");
            } else {
                KeyBinding selectedKeyBinding = KeyboardWidget.this.keyWizardScreen.getSelectedKeyBinding();
                if (selectedKeyBinding != null) {
                    selectedKeyBinding.func_197979_b(this.key);
                    KeyBinding.func_74508_b();
                }
            }
        }

        private void updateTooltip() {
            ArrayList<String> tooltipText = new ArrayList<String>();
            for (KeyBinding b : Minecraft.func_71410_x().field_71474_y.field_74324_K) {
                if (!((KeyBindingAccessor)b).getBoundKey().equals((Object)this.key)) continue;
                tooltipText.add(I18n.func_135052_a((String)b.func_151464_g(), (Object[])new Object[0]));
            }
            this.tooltipText = tooltipText.stream().sorted().map(s -> new TranslationTextComponent(s)).collect(Collectors.toCollection(ArrayList::new));
        }

        public void func_231023_e_() {
            this.updateTooltip();
        }
    }
}

