/*
 * Decompiled with CFR 0.152.
 */
package mrnerdy42.keywizard.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mrnerdy42.keywizard.gui.FreeFormListWidget;
import mrnerdy42.keywizard.gui.KeyWizardScreen;
import mrnerdy42.keywizard.gui.TickableElement;
import mrnerdy42.keywizard.mixin.KeyBindingAccessor;
import mrnerdy42.keywizard.util.KeyBindingUtil;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.jetbrains.annotations.Nullable;

public class KeyBindingListWidget
extends FreeFormListWidget<BindingEntry>
implements TickableElement {
    public KeyWizardScreen keyWizardScreen;
    private String currentFilterText = "";
    private String currentCategory = "key.categories.keywizard.all";

    public KeyBindingListWidget(KeyWizardScreen keyWizardScreen, int top, int left, int width, int height, int itemHeight) {
        super(Minecraft.m_91087_(), top, left, width, height, itemHeight);
        this.keyWizardScreen = keyWizardScreen;
        for (KeyMapping k : this.f_93386_.f_91066_.f_92059_) {
            this.m_7085_(new BindingEntry(k));
        }
        this.m_6987_((FreeFormListWidget.Entry)((Object)this.m_6702_().get(0)));
    }

    @Nullable
    public KeyMapping getSelectedKeyBinding() {
        if (this.m_93511_() == null) {
            return null;
        }
        return ((BindingEntry)this.m_93511_()).keyBinding;
    }

    private void updateList() {
        boolean categoryUpdate;
        boolean filterUpdate = !this.currentFilterText.equals(this.keyWizardScreen.getFilterText());
        boolean bl = categoryUpdate = !this.currentCategory.equals(this.keyWizardScreen.getSelectedCategory());
        if (categoryUpdate || filterUpdate) {
            if (categoryUpdate) {
                this.currentCategory = this.keyWizardScreen.getSelectedCategory();
            }
            KeyMapping[] bindings = this.getBindingsByCategory(this.currentCategory);
            if (filterUpdate) {
                this.currentFilterText = this.keyWizardScreen.getFilterText();
                if (!this.currentFilterText.equals("")) {
                    bindings = this.filterBindings(bindings, this.currentFilterText);
                }
            }
            this.m_6702_().clear();
            if (bindings.length > 0) {
                for (KeyMapping k : bindings) {
                    this.m_7085_(new BindingEntry(k));
                }
                this.m_6987_((FreeFormListWidget.Entry)((Object)this.m_6702_().get(0)));
            } else {
                this.m_6987_(null);
            }
            this.m_93410_(0.0);
        }
    }

    private KeyMapping[] filterBindings(KeyMapping[] bindings, String filterText) {
        KeyMapping[] bindingsFiltered = bindings;
        String keyNameRegex = "<.*>";
        Matcher keyNameMatcher = Pattern.compile(keyNameRegex).matcher(filterText);
        if (keyNameMatcher.find()) {
            String keyNameWithBrackets = keyNameMatcher.group();
            String keyName = keyNameWithBrackets.replace("<", "").replace(">", "");
            filterText = filterText.replace(keyNameWithBrackets, "");
            bindingsFiltered = this.filterBindingsByKey(bindingsFiltered, keyName);
        }
        if (!filterText.equals("")) {
            bindingsFiltered = this.filterBindingsByName(bindingsFiltered, filterText);
        }
        return bindingsFiltered;
    }

    private KeyMapping[] filterBindingsByName(KeyMapping[] bindings, String bindingName) {
        String[] words = bindingName.split("\\s+");
        KeyMapping[] bindingsFiltered = (KeyMapping[])Arrays.stream(bindings).filter(binding -> {
            boolean flag = true;
            for (String w : words) {
                flag = flag && I18n.m_118938_((String)binding.m_90860_(), (Object[])new Object[0]).toLowerCase().contains(w.toLowerCase());
            }
            return flag;
        }).toArray(KeyMapping[]::new);
        return bindingsFiltered;
    }

    private KeyMapping[] filterBindingsByKey(KeyMapping[] bindings, String keyName) {
        return (KeyMapping[])Arrays.stream(bindings).filter(b -> {
            Component t = b.m_90863_();
            if (t instanceof TranslatableContents) {
                return I18n.m_118938_((String)((TranslatableContents)t).m_237508_(), (Object[])new Object[0]).toLowerCase().equals(keyName.toLowerCase());
            }
            return t.getString().toLowerCase().equals(keyName.toLowerCase());
        }).toArray(KeyMapping[]::new);
    }

    private KeyMapping[] getBindingsByCategory(String category) {
        KeyMapping[] bindings = Arrays.copyOf(this.f_93386_.f_91066_.f_92059_, this.f_93386_.f_91066_.f_92059_.length);
        switch (category) {
            case "key.categories.keywizard.all": {
                return bindings;
            }
            case "key.categories.keywizard.conflicts": {
                Map<InputConstants.Key, Integer> bindingCounts = KeyBindingUtil.getBindingCountsByKey();
                return (KeyMapping[])Arrays.stream(bindings).filter(b -> (Integer)bindingCounts.get(((KeyBindingAccessor)b).getBoundKey()) > 1 && ((KeyBindingAccessor)b).getBoundKey().m_84873_() != -1).toArray(KeyMapping[]::new);
            }
            case "key.categories.keywizard.unbound": {
                return (KeyMapping[])Arrays.stream(bindings).filter(b -> b.m_90862_()).toArray(KeyMapping[]::new);
            }
        }
        return (KeyMapping[])Arrays.stream(bindings).filter(b -> b.m_90858_() == category).toArray(KeyMapping[]::new);
    }

    @Override
    public void tick() {
        this.updateList();
    }

    public void m_142291_(NarrationElementOutput var1) {
    }

    public class BindingEntry
    extends FreeFormListWidget.Entry {
        private final KeyMapping keyBinding;

        public BindingEntry(KeyMapping keyBinding) {
            this.keyBinding = keyBinding;
        }

        @Override
        public void m_6311_(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            ((KeyBindingListWidget)KeyBindingListWidget.this).f_93386_.f_91062_.m_92763_(matrices, (Component)MutableComponent.m_237204_((ComponentContents)new TranslatableContents(this.keyBinding.m_90860_())), (float)x, (float)y, -1);
            int color = -6710887;
            Font font = ((KeyBindingListWidget)KeyBindingListWidget.this).f_93386_.f_91062_;
            Component component = this.keyBinding.m_90863_();
            float f = x;
            Objects.requireNonNull(((KeyBindingListWidget)KeyBindingListWidget.this).f_93386_.f_91062_);
            font.m_92763_(matrices, component, f, (float)(y + 9 + 5), color);
        }
    }
}

