/*
 * Decompiled with CFR 0.152.
 */
package mrnerdy42.keywizard.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import mrnerdy42.keywizard.forge.KeyWizard;
import mrnerdy42.keywizard.gui.CategorySelectorWidget;
import mrnerdy42.keywizard.gui.KeyBindingListWidget;
import mrnerdy42.keywizard.gui.KeyboardWidget;
import mrnerdy42.keywizard.gui.KeyboardWidgetBuilder;
import mrnerdy42.keywizard.gui.TickableElement;
import mrnerdy42.keywizard.util.KeyBindingUtil;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.controls.ControlsScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.jetbrains.annotations.Nullable;

public class KeyWizardScreen
extends OptionsSubScreen {
    private final int[] mouseCodes = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private int mouseCodeIndex = 0;
    private KeyboardWidget keyboard;
    private KeyboardWidget mouseButton;
    private Button mousePlus;
    private Button mouseMinus;
    private KeyBindingListWidget bindingList;
    private CategorySelectorWidget categorySelector;
    private ImageButton screenToggleButton;
    private EditBox searchBar;
    private Button resetBinding;
    private Button resetAll;
    private Button clearBinding;

    public KeyWizardScreen(Screen parent) {
        super(parent, Minecraft.m_91087_().f_91066_, Component.m_130674_((String)"keywizard"));
    }

    protected void m_7856_() {
        int mouseButtonX = this.f_96543_ - 105;
        int mouseButtonY = this.f_96544_ / 2 - 115;
        int mouseButtonWidth = 80;
        int mouseButtonHeight = 20;
        int maxBindingNameWidth = 0;
        for (KeyMapping k : this.f_96541_.f_91066_.f_92059_) {
            int w = this.f_96547_.m_92852_((FormattedText)MutableComponent.m_237204_((ComponentContents)new TranslatableContents(k.m_90860_())));
            if (w <= maxBindingNameWidth) continue;
            maxBindingNameWidth = w;
        }
        int maxCategoryWidth = 0;
        for (String s : KeyBindingUtil.getCategories()) {
            int w = this.f_96547_.m_92852_((FormattedText)MutableComponent.m_237204_((ComponentContents)new TranslatableContents(s)));
            if (w <= maxCategoryWidth) continue;
            maxCategoryWidth = w;
        }
        int bindingListWidth = maxBindingNameWidth + 20;
        Objects.requireNonNull(this.f_96547_);
        this.bindingList = new KeyBindingListWidget(this, 10, 10, bindingListWidth, this.f_96544_ - 40, 9 * 3 + 10);
        this.keyboard = KeyboardWidgetBuilder.standardKeyboard(this, bindingListWidth + 15, this.f_96544_ / 2 - 90, this.f_96543_ - (bindingListWidth + 15), 180.0f);
        this.categorySelector = new CategorySelectorWidget(this, bindingListWidth + 15, 5, maxCategoryWidth + 20, 20);
        this.screenToggleButton = new ImageButton(this.f_96543_ - 22, this.f_96544_ - 22, 20, 20, 20, 0, 20, KeyWizard.SCREEN_TOGGLE_WIDGETS, 40, 40, btn -> this.f_96541_.m_91152_((Screen)new ControlsScreen(this.f_96281_, this.f_96282_)));
        this.searchBar = new EditBox(this.f_96547_, 10, this.f_96544_ - 20, bindingListWidth, 14, Component.m_130674_((String)""));
        this.mouseButton = KeyboardWidgetBuilder.singleKeyKeyboard(this, mouseButtonX, mouseButtonY, mouseButtonWidth, mouseButtonHeight, this.mouseCodes[this.mouseCodeIndex], InputConstants.Type.MOUSE);
        this.mousePlus = new Button((int)this.mouseButton.getAnchorX() + 83, (int)this.mouseButton.getAnchorY(), 25, 20, Component.m_130674_((String)"+"), btn -> {
            ++this.mouseCodeIndex;
            if (this.mouseCodeIndex >= this.mouseCodes.length) {
                this.mouseCodeIndex = 0;
            }
            this.m_169411_((GuiEventListener)this.mouseButton);
            this.mouseButton = KeyboardWidgetBuilder.singleKeyKeyboard(this, mouseButtonX, mouseButtonY, mouseButtonWidth, mouseButtonHeight, this.mouseCodes[this.mouseCodeIndex], InputConstants.Type.MOUSE);
            this.m_142416_((GuiEventListener)this.mouseButton);
        });
        this.mouseMinus = new Button((int)this.mouseButton.getAnchorX() - 26, (int)this.mouseButton.getAnchorY(), 25, 20, Component.m_130674_((String)"-"), btn -> {
            --this.mouseCodeIndex;
            if (this.mouseCodeIndex < 0) {
                this.mouseCodeIndex = this.mouseCodes.length - 1;
            }
            this.m_169411_((GuiEventListener)this.mouseButton);
            this.mouseButton = KeyboardWidgetBuilder.singleKeyKeyboard(this, mouseButtonX, mouseButtonY, mouseButtonWidth, mouseButtonHeight, this.mouseCodes[this.mouseCodeIndex], InputConstants.Type.MOUSE);
            this.m_142416_((GuiEventListener)this.mouseButton);
        });
        this.resetBinding = new Button(bindingListWidth + 15, this.f_96544_ - 23, 50, 20, (Component)MutableComponent.m_237204_((ComponentContents)new TranslatableContents("controls.reset")), btn -> {
            KeyMapping selectedBinding = this.getSelectedKeyBinding();
            selectedBinding.m_90848_(selectedBinding.m_90861_());
            KeyMapping.m_90854_();
        });
        this.clearBinding = new Button(bindingListWidth + 66, this.f_96544_ - 23, 50, 20, (Component)MutableComponent.m_237204_((ComponentContents)new TranslatableContents("gui.clear")), btn -> {
            KeyMapping selectedBinding = this.getSelectedKeyBinding();
            selectedBinding.m_90848_(InputConstants.Type.KEYSYM.m_84895_(-1));
            KeyMapping.m_90854_();
        });
        this.resetAll = new Button(bindingListWidth + 117, this.f_96544_ - 23, 70, 20, (Component)MutableComponent.m_237204_((ComponentContents)new TranslatableContents("controls.resetAll")), btn -> {
            for (KeyMapping b : this.f_96282_.f_92059_) {
                b.m_90848_(b.m_90861_());
            }
            KeyMapping.m_90854_();
        });
        this.m_142416_((GuiEventListener)this.bindingList);
        this.m_142416_((GuiEventListener)this.keyboard);
        this.m_142416_((GuiEventListener)this.categorySelector);
        this.m_142416_((GuiEventListener)this.categorySelector.getCategoryList());
        this.m_142416_((GuiEventListener)this.screenToggleButton);
        this.m_142416_((GuiEventListener)this.searchBar);
        this.m_142416_((GuiEventListener)this.mouseButton);
        this.m_142416_((GuiEventListener)this.mousePlus);
        this.m_142416_((GuiEventListener)this.mouseMinus);
        this.m_142416_((GuiEventListener)this.resetBinding);
        this.m_142416_((GuiEventListener)this.clearBinding);
        this.m_142416_((GuiEventListener)this.resetAll);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        super.m_6305_(matrices, mouseX, mouseY, delta);
    }

    public void m_86600_() {
        for (GuiEventListener e : this.m_6702_()) {
            if (!(e instanceof TickableElement)) continue;
            ((TickableElement)e).tick();
        }
    }

    @Nullable
    public KeyMapping getSelectedKeyBinding() {
        return this.bindingList.getSelectedKeyBinding();
    }

    public boolean getCategorySelectorExtended() {
        return this.categorySelector.extended;
    }

    public String getSelectedCategory() {
        return this.categorySelector.getSelctedCategory();
    }

    public String getFilterText() {
        return this.searchBar.m_94155_();
    }

    public void setSearchText(String s) {
        this.searchBar.m_94144_(s);
    }
}

