/*
 * Decompiled with CFR 0.152.
 */
package mrnerdy42.keywizard.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import mrnerdy42.keywizard.gui.KeyWizardScreen;
import mrnerdy42.keywizard.gui.TickableElement;
import mrnerdy42.keywizard.mixin.KeyBindingAccessor;
import mrnerdy42.keywizard.util.DrawingUtil;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;

public class KeyboardWidget
extends AbstractContainerEventHandler
implements Widget,
TickableElement,
NarratableEntry {
    public KeyWizardScreen keyWizardScreen;
    private HashMap<Integer, KeyboardKeyWidget> keys = new HashMap();
    private float anchorX;
    private float anchorY;

    protected KeyboardWidget(KeyWizardScreen keyWizardScreen, float anchorX, float anchorY) {
        this.keyWizardScreen = keyWizardScreen;
        this.anchorX = anchorX;
        this.anchorY = anchorY;
    }

    public float addKey(float relativeX, float relativeY, float width, float height, float keySpacing, int keyCode) {
        this.keys.put(keyCode, new KeyboardKeyWidget(keyCode, this.anchorX + relativeX, this.anchorY + relativeY, width, height, InputConstants.Type.KEYSYM));
        return relativeX + width + keySpacing;
    }

    public float addKey(float relativeX, float relativeY, float width, float height, float keySpacing, int keyCode, InputConstants.Type keyType) {
        this.keys.put(keyCode, new KeyboardKeyWidget(keyCode, this.anchorX + relativeX, this.anchorY + relativeY, width, height, keyType));
        return relativeX + width + keySpacing;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        List<? extends KeyboardKeyWidget> keys = this.m_6702_();
        for (KeyboardKeyWidget keyboardKeyWidget : keys) {
            keyboardKeyWidget.m_6305_(matrices, mouseX, mouseY, delta);
        }
        if (!this.keyWizardScreen.getCategorySelectorExtended()) {
            for (KeyboardKeyWidget keyboardKeyWidget : keys) {
                if (!keyboardKeyWidget.f_93623_ || !keyboardKeyWidget.m_198029_()) continue;
                this.keyWizardScreen.m_96597_(matrices, keyboardKeyWidget.tooltipText, mouseX, mouseY);
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.keyWizardScreen.getCategorySelectorExtended()) {
            for (KeyboardKeyWidget keyboardKeyWidget : this.m_6702_()) {
                if (!keyboardKeyWidget.m_6375_(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return false;
    }

    public List<? extends KeyboardKeyWidget> m_6702_() {
        return new ArrayList<KeyboardKeyWidget>(this.keys.values());
    }

    @Override
    public void tick() {
        for (KeyboardKeyWidget keyboardKeyWidget : this.m_6702_()) {
            keyboardKeyWidget.tick();
        }
    }

    public float getAnchorX() {
        return this.anchorX;
    }

    public float getAnchorY() {
        return this.anchorY;
    }

    public void m_142291_(NarrationElementOutput var1) {
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public class KeyboardKeyWidget
    extends AbstractButton
    implements TickableElement {
        public float x;
        public float y;
        protected float width;
        protected float height;
        private InputConstants.Key key;
        private List<Component> tooltipText;

        protected KeyboardKeyWidget(int keyCode, float x, float y, float width, float height, InputConstants.Type keyType) {
            super((int)x, (int)y, (int)width, (int)height, Component.m_130674_((String)""));
            this.tooltipText = new ArrayList<Component>();
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.key = keyType.m_84895_(keyCode);
            this.m_93666_(this.key.m_84875_());
        }

        public void m_6303_(PoseStack matrices, int mouseX, int mouseY, float delta) {
            int bindingCount = this.tooltipText.size();
            int color = 0;
            if (this.f_93623_) {
                if (this.m_198029_() && !KeyboardWidget.this.keyWizardScreen.getCategorySelectorExtended()) {
                    color = -5592406;
                    if (bindingCount == 1) {
                        color = -16733696;
                    } else if (bindingCount > 1) {
                        color = -5636096;
                    }
                } else {
                    color = -1;
                    if (bindingCount == 1) {
                        color = -16711936;
                    } else if (bindingCount > 1) {
                        color = -65536;
                    }
                }
            } else {
                color = -11184811;
            }
            DrawingUtil.drawNoFillRect(matrices, this.x, this.y, this.x + this.width, this.y + this.height, color);
            Font textRenderer = Minecraft.m_91087_().f_91062_;
            textRenderer.m_92763_(matrices, this.m_6035_(), this.x + this.width / 2.0f - (float)(textRenderer.m_92852_((FormattedText)this.m_6035_()) / 2), this.y + (this.height - 6.0f) / 2.0f, color);
        }

        public void m_5691_() {
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            if (Screen.m_96638_()) {
                Component t = this.m_6035_();
                String keyName = t instanceof TranslatableContents ? I18n.m_118938_((String)((TranslatableContents)t).m_237508_(), (Object[])new Object[0]) : t.getString();
                KeyboardWidget.this.keyWizardScreen.setSearchText("<" + keyName + ">");
            } else {
                KeyMapping selectedKeyBinding = KeyboardWidget.this.keyWizardScreen.getSelectedKeyBinding();
                if (selectedKeyBinding != null) {
                    selectedKeyBinding.m_90848_(this.key);
                    KeyMapping.m_90854_();
                }
            }
        }

        private void updateTooltip() {
            ArrayList<String> tooltipText = new ArrayList<String>();
            for (KeyMapping b : Minecraft.m_91087_().f_91066_.f_92059_) {
                if (!((KeyBindingAccessor)b).getBoundKey().equals((Object)this.key)) continue;
                tooltipText.add(I18n.m_118938_((String)b.m_90860_(), (Object[])new Object[0]));
            }
            this.tooltipText = tooltipText.stream().sorted().map(s -> MutableComponent.m_237204_((ComponentContents)new TranslatableContents(s))).collect(Collectors.toCollection(ArrayList::new));
        }

        @Override
        public void tick() {
            this.updateTooltip();
        }

        public void m_142291_(NarrationElementOutput var1) {
        }
    }
}

