/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrnerdy42.keywizard.gui;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;

public class GuiCategorySelector
extends GuiButton {
    private ListItem[] items;
    private int length;
    private boolean extended = false;
    private ListItem selectedItem;
    private int selectedIndex;

    public GuiCategorySelector(int x, int y, int width, String buttonText, ArrayList<String> itemNames) {
        super(0, x, y, width, 20, buttonText);
        this.items = new ListItem[itemNames.size()];
        this.length = this.items.length;
        int row = 0;
        int column = 0;
        for (int i = 0; i < this.items.length; ++i) {
            if (i % 11 == 0 && i != 0) {
                ++column;
                row = 0;
            }
            this.items[i] = new ListItem(i, row, column, I18n.func_135052_a((String)itemNames.get(i), (Object[])new Object[0]), itemNames.get(i), this);
            ++row;
        }
        this.selectItem(0);
    }

    public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
        if (this.field_146125_m) {
            FontRenderer fontrenderer = mc.field_71466_p;
            mc.func_110434_K().func_110577_a(field_146122_a);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            int i = this.getShadingMultiplier(this.field_146123_n);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 46 + i * 20, this.field_146120_f / 2, this.field_146121_g);
            this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i, 200 - this.field_146120_f / 2, 46 + i * 20, this.field_146120_f / 2, this.field_146121_g);
            this.func_146119_b(mc, mouseX, mouseY);
            int j = 0xE0E0E0;
            if (this.packedFGColour != 0) {
                j = this.packedFGColour;
            } else if (!this.field_146124_l) {
                j = 0xA0A0A0;
            } else if (this.field_146123_n || this.extended) {
                j = 0xFFFFA0;
            }
            this.func_73732_a(fontrenderer, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, j);
        }
    }

    public void drawList(Minecraft mc, int mouseX, int mouseY) {
        this.func_146112_a(mc, mouseX, mouseY);
        for (ListItem item : this.items) {
            item.func_146112_a(mc, mouseX, mouseY);
        }
    }

    public boolean getExtended() {
        return this.extended;
    }

    public String getSelctedCategory() {
        return this.selectedItem.name;
    }

    private int getShadingMultiplier(boolean mouseOver) {
        if (this.extended) {
            return 2;
        }
        return this.func_146114_a(mouseOver);
    }

    public void mouseClicked(Minecraft mc, int mouseX, int mouseY, int button) {
        ListItem item;
        boolean buttonHit = false;
        ListItem[] listItemArray = this.items;
        int n = listItemArray.length;
        for (int i = 0; i < n && !(buttonHit = (item = listItemArray[i]).mouseClicked(mc, mouseX, mouseY, button)); ++i) {
        }
        if (mouseX >= this.field_146128_h && mouseX < this.field_146128_h + this.field_146120_f && mouseY >= this.field_146129_i && mouseY < this.field_146129_i + this.field_146121_g && button == 0) {
            this.func_146113_a(mc.func_147118_V());
            this.setList(!this.extended);
        } else if (!buttonHit) {
            this.setList(false);
        }
    }

    public void selectItem(int index) {
        this.selectedItem = this.items[index];
        this.selectedIndex = index;
        this.updateState();
    }

    public void setList(boolean extended) {
        this.extended = extended;
        this.updateState();
    }

    private void updateState() {
        this.field_146123_n = this.extended;
        for (ListItem item : this.items) {
            item.field_146125_m = this.extended;
            item.field_146124_l = item != this.selectedItem;
        }
    }

    private class ListItem
    extends GuiButton {
        private int index;
        private String name;
        private GuiCategorySelector parent;

        public ListItem(int index, int row, int column, String itemText, String name, GuiCategorySelector parent) throws IllegalArgumentException {
            super(index, parent.field_146128_h + (parent.field_146120_f + 2) * column, parent.field_146129_i + 21 * (row + 1), parent.field_146120_f, 20, itemText);
            this.index = index;
            this.name = name;
            this.parent = parent;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean mouseClicked(Minecraft mc, int mouseX, int mouseY, int button) {
            boolean buttonHit = false;
            if (this.parent.extended && mouseX >= this.field_146128_h && mouseX < this.field_146128_h + this.field_146120_f && mouseY >= this.field_146129_i && mouseY < this.field_146129_i + this.field_146121_g && button == 0) {
                this.func_146113_a(mc.func_147118_V());
                this.parent.selectItem(this.index);
                buttonHit = true;
            }
            return buttonHit;
        }
    }
}

