/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrnerdy42.keywizard.gui;

import com.github.mrnerdy42.keywizard.gui.GuiBindingList;
import com.github.mrnerdy42.keywizard.gui.GuiCategorySelector;
import com.github.mrnerdy42.keywizard.util.KeyHelper;
import com.github.mrnerdy42.keywizard.util.KeybindUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.input.Mouse;

public class GuiKeyWizard
extends GuiScreen {
    protected Minecraft client = FMLClientHandler.instance().getClient();
    protected KeyBinding[] allBindings = KeybindUtils.ALL_BINDINGS;
    private HashMap<Integer, GuiButton> keyHash = new HashMap();
    private KeyBinding selectedKeybind;
    private KeyModifier activeModifier = KeyModifier.NONE;
    private String selectedCategory = "categories.all";
    private String searchText = "";
    private String keyboardMode = "keyboard";
    private GuiCategorySelector categoryList;
    private GuiTextField searchBar;
    private GuiBindingList bindingList;
    private GuiButton resetButton;
    private GuiButton clearButton;
    private GuiButton activeModifierButton;
    private int currentID = 2;

    protected void func_146284_a(GuiButton button) {
        if (button == this.resetButton) {
            this.selectedKeybind.setToDefault();
            KeyBinding.func_74508_b();
            this.resetButton.field_146124_l = !this.selectedKeybind.isSetToDefaultValue();
            return;
        }
        if (button == this.clearButton) {
            this.selectedKeybind.setKeyModifierAndCode(KeyModifier.NONE, 0);
            KeyBinding.func_74508_b();
            boolean bl = this.clearButton.field_146124_l = this.selectedKeybind.func_151463_i() != 0;
        }
        if (button == this.activeModifierButton) {
            this.changeActiveModifier();
            return;
        }
        if (this.keyHash.containsValue(button) && !this.categoryList.getExtended()) {
            int newKeyId = 0;
            for (int keyId : this.keyHash.keySet()) {
                if (!this.keyHash.containsKey(keyId) || this.keyHash.get(keyId) != button) continue;
                newKeyId = keyId;
            }
            if (newKeyId != 0) {
                this.selectedKeybind.setKeyModifierAndCode(this.activeModifier, newKeyId);
                KeyBinding.func_74508_b();
            }
            this.resetButton.field_146124_l = !this.selectedKeybind.isSetToDefaultValue();
            return;
        }
    }

    private void changeActiveModifier() {
        this.activeModifier = this.activeModifier == KeyModifier.NONE ? KeyModifier.ALT : (this.activeModifier == KeyModifier.ALT ? KeyModifier.CONTROL : (this.activeModifier == KeyModifier.CONTROL ? KeyModifier.SHIFT : KeyModifier.NONE));
        this.activeModifierButton.field_146126_j = "Active Modifier: " + this.activeModifier.toString();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.bindingList.drawScreen(mouseX, mouseY, partialTicks);
        this.searchBar.func_146194_f();
        this.categoryList.drawList(this.client, mouseX, mouseY);
        this.keyHash.forEach((keyId, keyButton) -> {
            ArrayList<String> bindingNames = KeybindUtils.getBindingNames(keyId, this.activeModifier);
            switch (bindingNames.size()) {
                case 0: {
                    keyButton.field_146126_j = KeyHelper.translateKey(keyId);
                    break;
                }
                case 1: {
                    keyButton.field_146126_j = TextFormatting.GREEN + KeyHelper.translateKey(keyId);
                    break;
                }
                default: {
                    keyButton.field_146126_j = TextFormatting.RED + KeyHelper.translateKey(keyId);
                }
            }
            if (keyButton.func_146115_a() && !this.categoryList.getExtended()) {
                this.drawHoveringText(KeybindUtils.getBindingNames(keyId, this.activeModifier), mouseX, mouseY, this.field_146289_q);
            }
        });
    }

    public Minecraft getClient() {
        return this.client;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public String getSelectedCategory() {
        return this.selectedCategory;
    }

    public void func_146274_d() throws IOException {
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.client.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.client.field_71440_d - 1;
        super.func_146274_d();
        this.bindingList.handleMouseInput(mouseX, mouseY);
    }

    public void func_73866_w_() {
        int i;
        int maxLength = 0;
        for (KeyBinding binding : KeybindUtils.ALL_BINDINGS) {
            if (binding.getDisplayName().length() <= maxLength) continue;
            maxLength = binding.getDisplayName().length();
        }
        int listWidth = maxLength * 19;
        this.bindingList = new GuiBindingList(this, 10, this.field_146295_m - 30, listWidth, this.field_146295_m - 40, this.field_146289_q.field_78288_b * 2 + 10);
        this.searchBar = new GuiTextField(0, this.field_146289_q, 10, this.field_146295_m - 20, listWidth, 14);
        this.searchBar.func_146195_b(true);
        this.searchBar.func_146205_d(false);
        int startX = listWidth + 50;
        int startY = this.field_146295_m / 2 - 80;
        ArrayList<String> categories = KeybindUtils.getCategories();
        categories.add(0, "categories.conflicts");
        categories.add(0, "categories.unbound");
        categories.add(0, "categories.all");
        this.categoryList = new GuiCategorySelector(startX - 30, 5, 125, "Binding Categories", categories);
        this.selectedCategory = this.categoryList.getSelctedCategory();
        this.resetButton = new GuiButton(0, startX - 30, this.field_146295_m - 40, 100, 20, "Reset binding");
        this.clearButton = new GuiButton(0, startX + 75, this.field_146295_m - 40, 100, 20, "Clear binding");
        this.activeModifierButton = new GuiButton(1, startX - 30, this.field_146295_m - 65, 150, 20, "Active Modifier: " + this.activeModifier.toString());
        this.setSelectedKeybind(this.bindingList.getSelectedKeybind());
        this.field_146292_n.add(this.activeModifierButton);
        this.field_146292_n.add(this.resetButton);
        this.field_146292_n.add(this.clearButton);
        int rowPos = 0;
        for (i = 59; i < 69; ++i) {
            this.placeKey(i, startX + rowPos * 36 - 30, startY, 34);
            ++rowPos;
        }
        for (i = 87; i < 89; ++i) {
            this.placeKey(i, startX + rowPos * 36 - 30, startY, 34);
            ++rowPos;
        }
        rowPos = 0;
        for (i = 2; i < 14; ++i) {
            this.placeKey(i, startX + rowPos * 30, startY + 25, 25);
            ++rowPos;
        }
        rowPos = 0;
        for (i = 16; i < 28; ++i) {
            this.placeKey(i, startX + rowPos * 30 + 15, startY + 50, 25);
            ++rowPos;
        }
        rowPos = 0;
        for (i = 30; i < 41; ++i) {
            this.placeKey(i, startX + rowPos * 30 + 20, startY + 75, 25);
            ++rowPos;
        }
        rowPos = 0;
        for (i = 44; i < 54; ++i) {
            this.placeKey(i, startX + rowPos * 30 + 25, startY + 100, 25);
            ++rowPos;
        }
        this.placeAuxKey(41, 2, -30, 0, 25);
        this.placeAuxKey(14, 13, 30, 0, 40);
        this.placeAuxKey(15, 16, -45, 0, 40);
        this.placeAuxKey(43, 27, 30, 0, 25);
        this.placeAuxKey(58, 30, -50, 0, 45);
        this.placeAuxKey(28, 40, 30, 0, 50);
        this.placeAuxKey(42, 44, -55, 0, 50);
        this.placeAuxKey(54, 53, 30, 0, 75);
        this.placeAuxKey(157, 42, 0, 25, 35);
        this.placeAuxKey(219, 157, 40, 0, 35);
        this.placeAuxKey(56, 219, 40, 0, 35);
        this.placeAuxKey(57, 56, 40, 0, 185);
        this.placeAuxKey(184, 57, 195, 0, 35);
        this.placeAuxKey(219, 184, 40, 0, 35);
        this.placeAuxKey(157, 219, 40, 0, 35);
        this.placeAuxKey(71, 88, 45, 0, 50);
        this.placeAuxKey(72, 71, 55, 0, 50);
        this.placeAuxKey(73, 72, 55, 0, 50);
        this.placeAuxKey(75, 71, 0, 25, 50);
        this.placeAuxKey(76, 75, 55, 0, 50);
        this.placeAuxKey(77, 76, 55, 0, 50);
        this.placeAuxKey(79, 75, 0, 25, 50);
        this.placeAuxKey(80, 79, 55, 0, 50);
        this.placeAuxKey(81, 80, 55, 0, 50);
        this.placeAuxKey(82, 79, 0, 25, 100);
        this.placeAuxKey(83, 82, 105, 0, 55);
    }

    protected void func_73869_a(char c, int keyCode) throws IOException {
        super.func_73869_a(c, keyCode);
        this.searchBar.func_146201_a(c, keyCode);
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        this.searchBar.func_146192_a(x, y, button);
        if (button == 1 && x >= this.searchBar.field_146209_f && x < this.searchBar.field_146209_f + this.searchBar.field_146218_h && y >= this.searchBar.field_146210_g && y < this.searchBar.field_146210_g + this.searchBar.field_146219_i) {
            this.searchBar.func_146180_a("");
        }
        this.categoryList.mouseClicked(this.client, x, y, button);
    }

    protected void setSelectedKeybind(KeyBinding binding) {
        this.selectedKeybind = binding;
    }

    private void placeAuxKey(int keyCode, int anchorCode, int xOffset, int yOffset, int width) {
        GuiButton anchor = this.keyHash.get(anchorCode);
        GuiButton button = new GuiButton(this.currentID, anchor.field_146128_h + xOffset, anchor.field_146129_i + yOffset, width, 20, KeyHelper.translateKey(keyCode));
        this.field_146292_n.add(button);
        this.keyHash.put(keyCode, button);
        ++this.currentID;
    }

    private void placeKey(int keyCode, int x, int y, int width) {
        GuiButton button = new GuiButton(this.currentID, x, y, width, 20, KeyHelper.translateKey(keyCode));
        this.field_146292_n.add(button);
        this.keyHash.put(keyCode, button);
        ++this.currentID;
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.searchBar.func_146178_a();
        if (this.resetButton != null) {
            boolean bl = this.resetButton.field_146124_l = !this.selectedKeybind.isSetToDefaultValue();
        }
        if (this.clearButton != null) {
            boolean bl = this.clearButton.field_146124_l = this.selectedKeybind.func_151463_i() != 0;
        }
        if (this.categoryList != null) {
            this.selectedCategory = this.categoryList.getSelctedCategory();
        }
        if (!this.searchBar.func_146179_b().equals(this.searchText)) {
            this.searchText = this.searchBar.func_146179_b();
        }
        this.bindingList.updateList();
    }
}

