/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrnerdy42.keywizard.gui;

import com.github.mrnerdy42.keywizard.gui.GuiKeyWizard;
import com.github.mrnerdy42.keywizard.util.KeybindUtils;
import java.util.Arrays;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.fml.client.GuiScrollingList;

public class GuiBindingList
extends GuiScrollingList {
    public boolean filtered = false;
    private GuiKeyWizard parent;
    private KeyBinding[] bindings;
    private String searchText;
    private String selectedCategory;
    private KeyBinding selectedKeybind;
    private int selectedKeybindId;

    public GuiBindingList(GuiKeyWizard parent, int left, int bottom, int width, int height, int entryHeight) {
        super(parent.getClient(), width, height, bottom - height, bottom, left, entryHeight, parent.field_146294_l, parent.field_146295_m);
        this.parent = parent;
        this.bindings = KeybindUtils.ALL_BINDINGS;
        this.searchText = this.parent.getSearchText();
        this.selectedCategory = this.parent.getSelectedCategory();
        this.selectKeybind(0);
    }

    protected int getSize() {
        return this.bindings.length;
    }

    protected void elementClicked(int index, boolean doubleClick) {
        this.selectKeybind(index);
    }

    protected boolean isSelected(int index) {
        return this.selectedKeybindId == index;
    }

    protected void drawBackground() {
    }

    protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotHeight, Tessellator tess) {
        FontRenderer fontRender = this.parent.getFontRenderer();
        KeyBinding currentBinding = this.bindings[slotIdx];
        fontRender.func_78276_b(I18n.func_135052_a((String)currentBinding.func_151464_g(), (Object[])new Object[0]), this.left + 3, slotTop, 0xFFFFFF);
        if (currentBinding.func_151463_i() == 0 || KeybindUtils.getConficts(currentBinding) > 0) {
            fontRender.func_78276_b(currentBinding.getDisplayName(), this.left + 3, slotTop + fontRender.field_78288_b + 2, 0x993333);
        } else if (!currentBinding.isSetToDefaultValue()) {
            fontRender.func_78276_b(currentBinding.getDisplayName(), this.left + 3, slotTop + fontRender.field_78288_b + 2, 0x339933);
        } else {
            fontRender.func_78276_b(currentBinding.getDisplayName(), this.left + 3, slotTop + fontRender.field_78288_b + 2, 0x999999);
        }
    }

    protected void updateList() {
        if (!this.searchText.equals(this.parent.getSearchText()) || !this.selectedCategory.equals(this.parent.getSelectedCategory())) {
            this.searchText = this.parent.getSearchText();
            this.selectedCategory = this.parent.getSelectedCategory();
            String filterExp = "(?i).*" + this.searchText + ".*";
            this.filtered = !this.searchText.equals("");
            this.bindings = this.getBindings(this.selectedCategory, filterExp);
            if (this.bindings.length != 0) {
                this.selectKeybind(0);
            }
        }
    }

    private void selectKeybind(int id) {
        this.selectedKeybindId = id;
        this.selectedKeybind = this.bindings[id];
        this.parent.setSelectedKeybind(this.selectedKeybind);
    }

    private KeyBinding[] getBindings(String category, String filterExp) {
        KeyBinding[] bindings = KeybindUtils.ALL_BINDINGS;
        switch (category) {
            case "categories.all": {
                break;
            }
            case "categories.conflicts": {
                bindings = (KeyBinding[])Arrays.stream(bindings).filter(binding -> KeybindUtils.getConficts(binding) >= 1 && binding.func_151463_i() != 0).toArray(KeyBinding[]::new);
                break;
            }
            case "categories.unbound": {
                bindings = (KeyBinding[])Arrays.stream(bindings).filter(binding -> binding.func_151463_i() == 0).toArray(KeyBinding[]::new);
                break;
            }
            default: {
                bindings = (KeyBinding[])Arrays.stream(bindings).filter(binding -> binding.func_151466_e() == category).toArray(KeyBinding[]::new);
            }
        }
        bindings = (KeyBinding[])Arrays.stream(bindings).filter(binding -> I18n.func_135052_a((String)binding.func_151464_g(), (Object[])new Object[0]).toLowerCase().matches(filterExp)).toArray(KeyBinding[]::new);
        return bindings;
    }

    public KeyBinding getSelectedKeybind() {
        return this.selectedKeybind;
    }
}

