/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrnerdy42.keywizard.gui;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FloatGui {
    public static final ResourceLocation OPTIONS_BACKGROUND = new ResourceLocation("textures/gui/options_background.png");
    public static final ResourceLocation STAT_ICONS = new ResourceLocation("textures/gui/container/stats_icons.png");
    public static final ResourceLocation ICONS = new ResourceLocation("textures/gui/icons.png");
    protected float zLevel;

    protected void drawHorizontalLine(double startX, double endX, double y, int color) {
        if (endX < startX) {
            double i = startX;
            startX = endX;
            endX = i;
        }
        this.drawRect(startX, y, endX + 1.0, y + 1.0, color);
    }

    protected void drawVerticalLine(double x, double startY, double endY, int color) {
        if (endY < startY) {
            double i = startY;
            startY = endY;
            endY = i;
        }
        this.drawRect(x, startY + 1.0, x + 1.0, endY, color);
    }

    protected void drawNoFillRect(double left, double top, double right, double bottom, int color) {
        this.drawHorizontalLine(left, right, top, color);
        this.drawHorizontalLine(left, right, bottom, color);
        this.drawVerticalLine(left, top, bottom, color);
        this.drawVerticalLine(right, top, bottom, color);
    }

    public void drawRect(double left, double top, double right, double bottom, int color) {
        if (left < right) {
            double i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            double j = top;
            top = bottom;
            bottom = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b(left, bottom, (double)this.zLevel).func_181675_d();
        bufferbuilder.func_181662_b(right, bottom, (double)this.zLevel).func_181675_d();
        bufferbuilder.func_181662_b(right, top, (double)this.zLevel).func_181675_d();
        bufferbuilder.func_181662_b(left, top, (double)this.zLevel).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    protected void drawGradientRect(double left, double top, double right, double bottom, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b(right, top, (double)this.zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b(left, top, (double)this.zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b(left, bottom, (double)this.zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_181662_b(right, bottom, (double)this.zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public void drawCenteredString(FontRenderer fontRendererIn, String text, float x, float y, int color) {
        fontRendererIn.func_175063_a(text, x - (float)(fontRendererIn.func_78256_a(text) / 2), y, color);
    }

    public void drawString(FontRenderer fontRendererIn, String text, float x, float y, int color) {
        fontRendererIn.func_175063_a(text, x, y, color);
    }

    public void drawTexturedModalRect(double x, double y, int textureX, int textureY, double width, double height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x + 0.0, y + height, (double)this.zLevel).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)((double)textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + height, (double)this.zLevel).func_187315_a((double)((float)((double)textureX + width) * 0.00390625f), (double)((float)((double)textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + 0.0, (double)this.zLevel).func_187315_a((double)((float)((double)textureX + width) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b(x + 0.0, y + 0.0, (double)this.zLevel).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }

    public void drawTexturedModalRect(int xCoord, int yCoord, int minU, int minV, int maxU, int maxV) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)((float)xCoord + 0.0f), (double)((float)yCoord + (float)maxV), (double)this.zLevel).func_187315_a((double)((float)(minU + 0) * 0.00390625f), (double)((float)(minV + maxV) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)((float)xCoord + (float)maxU), (double)((float)yCoord + (float)maxV), (double)this.zLevel).func_187315_a((double)((float)(minU + maxU) * 0.00390625f), (double)((float)(minV + maxV) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)((float)xCoord + (float)maxU), (double)((float)yCoord + 0.0f), (double)this.zLevel).func_187315_a((double)((float)(minU + maxU) * 0.00390625f), (double)((float)(minV + 0) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)((float)xCoord + 0.0f), (double)((float)yCoord + 0.0f), (double)this.zLevel).func_187315_a((double)((float)(minU + 0) * 0.00390625f), (double)((float)(minV + 0) * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }

    public void drawTexturedModalRect(int xCoord, int yCoord, TextureAtlasSprite textureSprite, int widthIn, int heightIn) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(xCoord + 0), (double)(yCoord + heightIn), (double)this.zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + heightIn), (double)this.zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + 0), (double)this.zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94206_g()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + 0), (double)(yCoord + 0), (double)this.zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawModalRectWithCustomSizedTexture(int x, int y, float u, float v, int width, int height, float textureWidth, float textureHeight) {
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)(u * f), (double)((v + (float)height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((u + (float)width) * f), (double)((v + (float)height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)((u + (float)width) * f), (double)(v * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)(u * f), (double)(v * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawScaledCustomSizeModalRect(int x, int y, float u, float v, int uWidth, int vHeight, int width, int height, float tileWidth, float tileHeight) {
        float f = 1.0f / tileWidth;
        float f1 = 1.0f / tileHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)(u * f), (double)((v + (float)vHeight) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((u + (float)uWidth) * f), (double)((v + (float)vHeight) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)((u + (float)uWidth) * f), (double)(v * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)(u * f), (double)(v * f1)).func_181675_d();
        tessellator.func_78381_a();
    }
}

