/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrnerdy42.keywizard.gui;

import com.github.mrnerdy42.keywizard.gui.GuiKeyWizard;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.GuiScrollingList;

public class GuiCategorySelector
extends GuiButton {
    private GuiKeyWizard parent;
    private boolean extended = false;
    private GuiCategoryList list;
    private ArrayList<String> categories;
    private int selectedCategoryIdx;
    private String selectedCategory;

    public GuiCategorySelector(GuiKeyWizard parent, int x, int y, int width, ArrayList<String> categories) {
        super(0, x, y, width, 20, I18n.func_135052_a((String)categories.get(0), (Object[])new Object[0]));
        this.parent = parent;
        this.categories = categories;
        this.selectedCategoryIdx = 0;
        this.selectedCategory = this.categories.get(0);
        int fontHeight = parent.getFontRenderer().field_78288_b;
        this.list = new GuiCategoryList(parent, x, y + 20, width, parent.field_146295_m - 40, fontHeight + 7);
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (this.field_146125_m) {
            FontRenderer fontrenderer = mc.field_71466_p;
            mc.func_110434_K().func_110577_a(field_146122_a);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            int i = this.getShadingMultiplier(this.field_146123_n);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 46 + i * 20, this.field_146120_f / 2, this.field_146121_g);
            this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i, 200 - this.field_146120_f / 2, 46 + i * 20, this.field_146120_f / 2, this.field_146121_g);
            this.func_146119_b(mc, mouseX, mouseY);
            int j = 0xE0E0E0;
            if (this.packedFGColour != 0) {
                j = this.packedFGColour;
            } else if (!this.field_146124_l) {
                j = 0xA0A0A0;
            } else if (this.field_146123_n || this.extended) {
                j = 0xFFFFA0;
            }
            this.func_73732_a(fontrenderer, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, j);
        }
    }

    public void drawList(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        this.func_191745_a(mc, mouseX, mouseY, partialTicks);
        if (this.extended) {
            this.list.drawScreen(mouseX, mouseY, partialTicks);
        }
    }

    public boolean getExtended() {
        return this.extended;
    }

    public String getSelctedCategory() {
        return this.selectedCategory;
    }

    private int getShadingMultiplier(boolean mouseOver) {
        if (this.extended) {
            return 2;
        }
        return this.func_146114_a(mouseOver);
    }

    public void mouseClicked(Minecraft mc, int mouseX, int mouseY, int button) {
        if (mouseX >= this.field_146128_h && mouseX < this.field_146128_h + this.field_146120_f && mouseY >= this.field_146129_i && mouseY < this.field_146129_i + this.field_146121_g && button == 0) {
            this.func_146113_a(mc.func_147118_V());
            this.setState(!this.extended);
        } else if ((mouseX < this.list.getLeft() || mouseX >= this.list.getLeft() + this.list.getListWidth() || mouseY < this.list.getTop() || mouseY >= this.list.getTop() + this.list.getListHeight()) && button == 0) {
            this.setState(false);
        }
    }

    public void setState(boolean extended) {
        this.extended = extended;
        this.update();
    }

    private void update() {
        this.field_146123_n = this.extended;
        this.selectedCategory = this.categories.get(this.selectedCategoryIdx);
        this.field_146126_j = I18n.func_135052_a((String)this.selectedCategory, (Object[])new Object[0]);
    }

    private class GuiCategoryList
    extends GuiScrollingList {
        public GuiCategoryList(GuiKeyWizard parent, int left, int top, int width, int height, int entryHeight) {
            super(parent.getClient(), width, height, top, top + height, left, entryHeight, parent.field_146294_l, parent.field_146295_m);
        }

        protected int getSize() {
            return GuiCategorySelector.this.categories.size();
        }

        protected void elementClicked(int index, boolean doubleClick) {
            GuiCategorySelector.this.selectedCategoryIdx = index;
            GuiCategorySelector.this.update();
        }

        protected boolean isSelected(int index) {
            return GuiCategorySelector.this.selectedCategoryIdx == index;
        }

        protected void drawBackground() {
        }

        protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
            FontRenderer fontRender = GuiCategorySelector.this.parent.getFontRenderer();
            fontRender.func_175063_a(I18n.func_135052_a((String)((String)GuiCategorySelector.this.categories.get(slotIdx)), (Object[])new Object[0]), (float)(this.left + 3), (float)(slotTop + 2), 0xFFFFFF);
        }

        public int getListWidth() {
            return this.listWidth;
        }

        public int getListHeight() {
            return this.listHeight;
        }

        public int getTop() {
            return this.top;
        }

        public int getLeft() {
            return this.left;
        }
    }
}

