/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrnerdy42.keywizard.gui;

import com.github.mrnerdy42.keywizard.KeyWizardConfig;
import com.github.mrnerdy42.keywizard.gui.GuiBindingList;
import com.github.mrnerdy42.keywizard.gui.GuiCategorySelector;
import com.github.mrnerdy42.keywizard.gui.GuiKeyboard;
import com.github.mrnerdy42.keywizard.util.KeybindUtils;
import com.github.mrnerdy42.keywizard.util.KeyboardFactory;
import com.github.mrnerdy42.keywizard.util.KeyboardLayout;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.settings.KeyModifier;
import org.lwjgl.input.Mouse;

public class GuiKeyWizard
extends GuiScreen {
    public KeyboardLayout layout = KeyWizardConfig.layout;
    protected GuiKeyboard keyboard;
    private final GuiScreen parentScreen;
    private KeyboardLayout[] pages = new KeyboardLayout[]{KeyWizardConfig.layout, KeyboardLayout.NUMPAD, KeyboardLayout.AUXILIARY};
    private int pageNum = 0;
    private int mouse = 0;
    private int maxMouse = KeyWizardConfig.maxMouseButtons - 1;
    private KeyBinding selectedKeybind;
    private KeyModifier activeModifier = KeyModifier.NONE;
    private String selectedCategory = "categories.all";
    private String searchText = "";
    private int guiWidth;
    private int guiStartX;
    private GuiCategorySelector categoryList;
    private GuiTextField searchBar;
    private GuiBindingList bindingList;
    private GuiButton buttonPage;
    private GuiButton buttonReset;
    private GuiButton buttonClear;
    private GuiButton buttonDone;
    private GuiButton buttonActiveModifier;
    private GuiButton buttonMouse;
    private GuiButton buttonMousePlus;
    private GuiButton buttonMouseMinus;

    public GuiKeyWizard(Minecraft mcIn, GuiScreen parentScreen) {
        this.field_146297_k = mcIn;
        this.parentScreen = parentScreen;
    }

    public void func_73866_w_() {
        int maxBindingLength = 0;
        for (KeyBinding binding : KeybindUtils.ALL_BINDINGS) {
            if (binding.getDisplayName().length() <= maxBindingLength) continue;
            maxBindingLength = binding.getDisplayName().length();
        }
        int bindingListWidth = maxBindingLength * 11;
        this.bindingList = new GuiBindingList(this, 10, this.field_146295_m - 30, bindingListWidth, this.field_146295_m - 40, this.field_146289_q.field_78288_b * 3 + 10);
        this.searchBar = new GuiTextField(0, this.field_146289_q, 10, this.field_146295_m - 20, bindingListWidth, 14);
        this.searchBar.func_146195_b(true);
        this.searchBar.func_146205_d(false);
        this.guiStartX = bindingListWidth + 15;
        this.guiWidth = this.field_146294_l - this.guiStartX;
        ArrayList<String> categories = KeybindUtils.getCategories();
        categories.add(0, "categories.conflicts");
        categories.add(0, "categories.unbound");
        categories.add(0, "categories.all");
        int maxCategoryLength = 0;
        for (String s : categories) {
            if (I18n.func_135052_a((String)s, (Object[])new Object[0]).length() <= maxCategoryLength) continue;
            maxCategoryLength = s.length();
        }
        this.categoryList = new GuiCategorySelector(this, this.guiStartX, 5, maxCategoryLength * 9, categories);
        this.selectedCategory = this.categoryList.getSelctedCategory();
        this.keyboard = KeyboardFactory.makeKeyboard(this.pages[this.pageNum], this, this.guiStartX, this.field_146295_m / 2 - 90, this.guiWidth - 5, this.field_146295_m);
        this.buttonPage = new GuiButton(0, this.field_146294_l - 110, 5, 100, 20, I18n.func_135052_a((String)"gui.page", (Object[])new Object[0]) + ": " + this.pages[this.pageNum].getDisplayName());
        this.buttonReset = new GuiButton(0, this.guiStartX, this.field_146295_m - 40, 75, 20, I18n.func_135052_a((String)"gui.resetBinding", (Object[])new Object[0]));
        this.buttonClear = new GuiButton(0, this.guiStartX + 76, this.field_146295_m - 40, 75, 20, I18n.func_135052_a((String)"gui.clearBinding", (Object[])new Object[0]));
        this.buttonDone = new GuiButton(0, this.field_146294_l - 90, this.field_146295_m - 40, 87, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.buttonActiveModifier = new GuiButton(1, this.guiStartX, this.field_146295_m - 63, 150, 20, I18n.func_135052_a((String)"gui.activeModifier", (Object[])new Object[0]) + ": " + this.activeModifier.toString());
        this.buttonMouse = new GuiButton(0, this.guiStartX + 25, this.field_146295_m - 85, 100, 20, I18n.func_135052_a((String)"gui.mouse", (Object[])new Object[0]) + ": " + Mouse.getButtonName((int)this.mouse));
        this.buttonMousePlus = new GuiButton(0, this.guiStartX + 126, this.field_146295_m - 85, 25, 20, "+");
        this.buttonMouseMinus = new GuiButton(0, this.guiStartX, this.field_146295_m - 85, 25, 20, "-");
        this.setSelectedKeybind(this.bindingList.getSelectedKeybind());
        this.field_146292_n.add(this.buttonPage);
        this.field_146292_n.add(this.buttonReset);
        this.field_146292_n.add(this.buttonClear);
        this.field_146292_n.add(this.buttonDone);
        this.field_146292_n.add(this.buttonActiveModifier);
        this.field_146292_n.add(this.buttonMouse);
        this.field_146292_n.add(this.buttonMousePlus);
        this.field_146292_n.add(this.buttonMouseMinus);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.bindingList.drawScreen(mouseX, mouseY, partialTicks);
        this.searchBar.func_146194_f();
        this.keyboard.draw(this.field_146297_k, mouseX, mouseY, partialTicks);
        this.categoryList.drawList(this.field_146297_k, mouseX, mouseY, partialTicks);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.searchBar.func_146178_a();
        if (this.buttonReset != null) {
            boolean bl = this.buttonReset.field_146124_l = !this.selectedKeybind.isSetToDefaultValue();
        }
        if (this.buttonClear != null) {
            boolean bl = this.buttonClear.field_146124_l = this.selectedKeybind.func_151463_i() != 0;
        }
        if (this.categoryList != null) {
            this.selectedCategory = this.categoryList.getSelctedCategory();
        }
        if (!this.searchBar.func_146179_b().equals(this.searchText)) {
            this.searchText = this.searchBar.func_146179_b();
        }
        if (this.activeModifier != null) {
            switch (this.activeModifier.toString()) {
                case "CONTROL": {
                    this.keyboard.disableKey(29);
                    this.keyboard.disableKey(157);
                    this.keyboard.enableKey(56);
                    this.keyboard.enableKey(184);
                    this.keyboard.enableKey(42);
                    this.keyboard.enableKey(54);
                    break;
                }
                case "ALT": {
                    this.keyboard.disableKey(56);
                    this.keyboard.disableKey(184);
                    this.keyboard.enableKey(29);
                    this.keyboard.enableKey(157);
                    this.keyboard.enableKey(42);
                    this.keyboard.enableKey(54);
                    break;
                }
                case "SHIFT": {
                    this.keyboard.disableKey(42);
                    this.keyboard.disableKey(54);
                    this.keyboard.enableKey(29);
                    this.keyboard.enableKey(157);
                    this.keyboard.enableKey(56);
                    this.keyboard.enableKey(184);
                    break;
                }
                case "NONE": {
                    this.keyboard.enableKey(29);
                    this.keyboard.enableKey(157);
                    this.keyboard.enableKey(56);
                    this.keyboard.enableKey(184);
                    this.keyboard.enableKey(42);
                    this.keyboard.enableKey(54);
                }
            }
        }
        switch (KeybindUtils.getNumBindings(-100 + this.mouse, this.activeModifier)) {
            case 0: {
                this.buttonMouse.field_146126_j = I18n.func_135052_a((String)"gui.mouse", (Object[])new Object[0]) + ": " + Mouse.getButtonName((int)this.mouse);
                break;
            }
            case 1: {
                this.buttonMouse.field_146126_j = I18n.func_135052_a((String)"gui.mouse", (Object[])new Object[0]) + ": " + TextFormatting.GREEN + Mouse.getButtonName((int)this.mouse);
                break;
            }
            default: {
                this.buttonMouse.field_146126_j = I18n.func_135052_a((String)"gui.mouse", (Object[])new Object[0]) + ": " + TextFormatting.RED + Mouse.getButtonName((int)this.mouse);
            }
        }
        this.buttonPage.field_146126_j = I18n.func_135052_a((String)"gui.page", (Object[])new Object[0]) + ": " + this.pages[this.pageNum].getDisplayName();
        this.bindingList.updateList();
    }

    protected void func_146284_a(GuiButton button) {
        if (!this.categoryList.getExtended()) {
            if (button == this.buttonReset) {
                this.selectedKeybind.setToDefault();
                KeyBinding.func_74508_b();
                this.buttonReset.field_146124_l = !this.selectedKeybind.isSetToDefaultValue();
                return;
            }
            if (button == this.buttonClear) {
                this.selectedKeybind.setKeyModifierAndCode(KeyModifier.NONE, 0);
                KeyBinding.func_74508_b();
                boolean bl = this.buttonClear.field_146124_l = this.selectedKeybind.func_151463_i() != 0;
            }
            if (button == this.buttonDone) {
                if (this.parentScreen != null) {
                    this.field_146297_k.func_147108_a(this.parentScreen);
                } else {
                    this.field_146297_k.func_147108_a((GuiScreen)null);
                }
            }
            if (button == this.buttonActiveModifier) {
                this.changeActiveModifier();
            }
            if (button == this.buttonPage) {
                ++this.pageNum;
                if (this.pageNum > this.pages.length - 1) {
                    this.pageNum = 0;
                }
                this.keyboard = KeyboardFactory.makeKeyboard(this.pages[this.pageNum], this, this.guiStartX, this.field_146295_m / 2 - 90, this.guiWidth - 5, this.field_146295_m);
            }
            if (button == this.buttonMouse) {
                this.selectedKeybind.setKeyModifierAndCode(this.activeModifier, -100 + this.mouse);
                this.field_146297_k.field_71474_y.func_151440_a(this.selectedKeybind, -100 + this.mouse);
                KeyBinding.func_74508_b();
            }
            if (button == this.buttonMousePlus) {
                this.mouse = this.mouse >= this.maxMouse ? 0 : ++this.mouse;
            }
            if (button == this.buttonMouseMinus) {
                this.mouse = this.mouse <= 0 ? this.maxMouse : --this.mouse;
            }
            this.buttonReset.field_146124_l = !this.selectedKeybind.isSetToDefaultValue();
        }
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        this.searchBar.func_146192_a(x, y, button);
        this.categoryList.mouseClicked(this.field_146297_k, x, y, button);
        this.keyboard.mouseClicked(this.field_146297_k, x, y, button);
    }

    protected void func_73869_a(char c, int keyCode) throws IOException {
        super.func_73869_a(c, keyCode);
        this.searchBar.func_146201_a(c, keyCode);
    }

    private void changeActiveModifier() {
        this.activeModifier = this.activeModifier == KeyModifier.NONE ? KeyModifier.ALT : (this.activeModifier == KeyModifier.ALT ? KeyModifier.CONTROL : (this.activeModifier == KeyModifier.CONTROL ? KeyModifier.SHIFT : KeyModifier.NONE));
        this.buttonActiveModifier.field_146126_j = I18n.func_135052_a((String)"gui.activeModifier", (Object[])new Object[0]) + ": " + this.activeModifier.toString();
    }

    public Minecraft getClient() {
        return this.field_146297_k;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String s) {
        this.searchText = s;
        this.searchBar.func_146180_a(s);
    }

    public String getSelectedCategory() {
        return this.selectedCategory;
    }

    public KeyModifier getActiveModifier() {
        return this.activeModifier;
    }

    public KeyBinding getSelectedKeybind() {
        return this.selectedKeybind;
    }

    protected void setSelectedKeybind(KeyBinding binding) {
        this.selectedKeybind = binding;
    }

    public boolean getCategoryListExtended() {
        return this.categoryList.getExtended();
    }
}

