/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrnerdy42.keywizard.gui;

import com.github.mrnerdy42.keywizard.gui.FloatGui;
import com.github.mrnerdy42.keywizard.gui.GuiKeyWizard;
import com.github.mrnerdy42.keywizard.util.KeyHelper;
import com.github.mrnerdy42.keywizard.util.KeybindUtils;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.input.Keyboard;

public class GuiKeyboard
extends FloatGui {
    public double anchorX;
    public double anchorY;
    public GuiKeyWizard parent;
    protected HashMap<Integer, GuiKeyboardKey> keyList = new HashMap();
    private double scaleFactor;

    public GuiKeyboard(GuiKeyWizard parent, double anchorX, double anchorY) {
        this.parent = parent;
        this.anchorX = anchorX;
        this.anchorY = anchorY;
    }

    public void draw(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        for (GuiKeyboardKey k : this.keyList.values()) {
            k.drawKey(mc, mouseX, mouseY, partialTicks);
        }
        for (GuiKeyboardKey k : this.keyList.values()) {
            if (!k.hovered || this.parent.getCategoryListExtended()) continue;
            GuiUtils.drawHoveringText(KeybindUtils.getBindingNamesAndCategories(k.keyCode, this.parent.getActiveModifier()), (int)mouseX, (int)mouseY, (int)this.parent.field_146294_l, (int)this.parent.field_146295_m, (int)-1, (FontRenderer)this.parent.getFontRenderer());
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
        }
    }

    public void mouseClicked(Minecraft mc, int mouseX, int mouseY, int button) {
        for (GuiKeyboardKey k : this.keyList.values()) {
            k.mouseClicked(mc, mouseX, mouseY, button);
        }
    }

    public void addKey(double xIn, double yIn, double width, double height, int keyCode) {
        this.keyList.put(new Integer(keyCode), new GuiKeyboardKey(this, xIn, yIn, width, height, keyCode));
    }

    public void disableKey(int keyCode) {
        if (this.HasKey(keyCode)) {
            this.keyList.get((Object)Integer.valueOf((int)keyCode)).enabled = false;
        }
    }

    public void enableKey(int keyCode) {
        if (this.HasKey(keyCode)) {
            this.keyList.get((Object)Integer.valueOf((int)keyCode)).enabled = true;
        }
    }

    public double width() {
        double width = 0.0;
        for (GuiKeyboardKey k : this.keyList.values()) {
            if (!(k.absX() + k.width > width)) continue;
            width = k.absX() + k.width;
        }
        return width;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(double scaleFactor) {
        this.scaleFactor = scaleFactor;
        for (GuiKeyboardKey k : this.keyList.values()) {
            k.width *= scaleFactor;
            k.height *= scaleFactor;
            k.x *= scaleFactor;
            k.y *= scaleFactor;
        }
    }

    public void setZLevel(float zLevel) {
        this.zLevel = zLevel;
        for (GuiKeyboardKey k : this.keyList.values()) {
            k.zLevel = this.zLevel;
        }
    }

    public boolean HasKey(int keyCode) {
        return this.keyList.containsKey(keyCode);
    }

    private class GuiKeyboardKey
    extends FloatGui {
        public GuiKeyboard keyboard;
        public double x;
        public double y;
        public double width;
        public double height;
        public boolean enabled = true;
        public int keyCode;
        public String displayString;
        protected boolean hovered;

        public GuiKeyboardKey(GuiKeyboard keyboard, double x, double y, double width, double height, int keyCode) {
            this.keyboard = keyboard;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.keyCode = keyCode;
            this.displayString = KeyHelper.translateKey(this.keyCode);
        }

        public void drawKey(Minecraft mc, double mouseX, double mouseY, float partialTicks) {
            this.hovered = mouseX >= this.absX() && mouseY >= this.absY() && mouseX < this.absX() + this.width && mouseY < this.absY() + this.height;
            int modifiedBindings = KeybindUtils.getNumBindings(this.keyCode, GuiKeyboard.this.parent.getActiveModifier());
            int color = 0;
            if (this.enabled) {
                if (this.hovered && !GuiKeyboard.this.parent.getCategoryListExtended()) {
                    color = -5592406;
                    if (modifiedBindings == 1) {
                        color = -16733696;
                    } else if (modifiedBindings > 1) {
                        color = -5636096;
                    }
                } else {
                    color = -1;
                    if (modifiedBindings == 1) {
                        color = -16711936;
                    } else if (modifiedBindings > 1) {
                        color = -65536;
                    }
                }
            } else {
                color = -11184811;
            }
            this.drawNoFillRect(this.absX(), this.absY(), this.absX() + this.width, this.absY() + this.height, color);
            this.drawCenteredString(this.keyboard.parent.getFontRenderer(), this.displayString, (float)(this.absX() + (this.width + 2.0) / 2.0), (float)(this.absY() + (this.height - 6.0) / 2.0), color & 0xFFFFFF);
        }

        public void mouseClicked(Minecraft mc, int mouseX, int mouseY, int button) {
            if (this.hovered && this.enabled && !GuiKeyboard.this.parent.getCategoryListExtended() && button == 0) {
                mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                if (GuiScreen.func_146272_n()) {
                    GuiKeyboard.this.parent.setSearchText("@" + Keyboard.getKeyName((int)this.keyCode));
                } else {
                    GuiKeyboard.this.parent.getSelectedKeybind().setKeyModifierAndCode(GuiKeyboard.this.parent.getActiveModifier(), this.keyCode);
                    mc.field_71474_y.func_151440_a(GuiKeyboard.this.parent.getSelectedKeybind(), this.keyCode);
                    KeyBinding.func_74508_b();
                }
            }
        }

        public double absX() {
            return this.keyboard.anchorX + this.x;
        }

        public double absY() {
            return this.keyboard.anchorY + this.y;
        }
    }
}

