/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrnerdy42.keywizard.util;

import com.github.mrnerdy42.keywizard.gui.GuiKeyWizard;
import com.github.mrnerdy42.keywizard.gui.GuiKeyboard;
import com.github.mrnerdy42.keywizard.util.KeyboardLayout;

public class KeyboardFactory {
    public static GuiKeyboard makeKeyboard(KeyboardLayout layout, GuiKeyWizard parent, double x, double y, double width, double height) {
        switch (layout) {
            case QWERTY: {
                return KeyboardFactory.makeQwertyKeyboard(parent, x, y, width, height);
            }
            case NUMPAD: {
                return KeyboardFactory.makeNumpad(parent, x, y, width, height);
            }
            case AUXILIARY: {
                return KeyboardFactory.makeAuxiliary(parent, x, y, width, height);
            }
        }
        return null;
    }

    private static GuiKeyboard makeQwertyKeyboard(GuiKeyWizard parent, double x, double y, double width, double height) {
        GuiKeyboard kb = new GuiKeyboard(parent, x, y);
        double currentX = 0.0;
        double currentY = 0.0;
        double keySpacing = 5.0;
        double keyWidth = width / 12.0 - keySpacing;
        double keyHeight = height / 15.0;
        currentX = KeyboardFactory.addHorizontalRow(kb, 59, 68, 0.0, currentY, keyWidth, keyHeight, keySpacing);
        kb.addKey(currentX, currentY, keyWidth, keyHeight, 87);
        kb.addKey(currentX += keyWidth + keySpacing, currentY, keyWidth, keyHeight, 88);
        keyWidth = width / 15.0 - keySpacing;
        kb.addKey(0.0, currentY += keyHeight + keySpacing, keyWidth, keyHeight, 41);
        currentX = keyWidth + keySpacing;
        currentX = KeyboardFactory.addHorizontalRow(kb, 2, 13, currentX, currentY, keyWidth, keyHeight, keySpacing);
        kb.addKey(currentX, currentY, keyWidth * 2.0 + 5.0, keyHeight, 14);
        kb.addKey(0.0, currentY += keyHeight + keySpacing, keyWidth * 2.0 + keySpacing, keyHeight, 15);
        currentX = keyWidth * 2.0 + keySpacing * 2.0;
        currentX = KeyboardFactory.addHorizontalRow(kb, 16, 27, currentX, currentY, keyWidth, keyHeight, keySpacing);
        kb.addKey(currentX, currentY, keyWidth, keyHeight, 43);
        kb.addKey(0.0, currentY += keyHeight + keySpacing, keyWidth * 2.0 + keySpacing, keyHeight, 58);
        currentX = keyWidth * 2.0 + keySpacing * 2.0;
        currentX = KeyboardFactory.addHorizontalRow(kb, 30, 40, currentX, currentY, keyWidth, keyHeight, keySpacing);
        kb.addKey(currentX, currentY, keyWidth * 2.0 + keySpacing, keyHeight, 28);
        kb.addKey(0.0, currentY += keyHeight + keySpacing, keyWidth * 2.0 + keySpacing, keyHeight, 42);
        currentX = keyWidth * 2.0 + keySpacing * 2.0;
        currentX = KeyboardFactory.addHorizontalRow(kb, 44, 53, currentX, currentY, keyWidth, keyHeight, keySpacing);
        kb.addKey(currentX, currentY, keyWidth * 3.0 + keySpacing * 2.0, keyHeight, 54);
        keyWidth = width / 7.0 - keySpacing;
        currentX = KeyboardFactory.addHorizontalRow(kb, new int[]{29, 219, 56, 57, 184, 220, 157}, 0.0, currentY += keyHeight + keySpacing, keyWidth, keyHeight, keySpacing);
        return kb;
    }

    private static GuiKeyboard makeNumpad(GuiKeyWizard parent, double x, double y, double width, double height) {
        GuiKeyboard kb = new GuiKeyboard(parent, x, y);
        double currentX = 0.0;
        double currentY = 0.0;
        double keySpacing = 5.0;
        double keyWidth = width / 4.0 - keySpacing;
        double keyHeight = height / 14.0;
        currentX = KeyboardFactory.addHorizontalRow(kb, new int[]{181, 55, 74}, 0.0, currentY, keyWidth, keyHeight, keySpacing);
        kb.addKey(currentX, currentY, keyWidth / 3.0, keyHeight * 2.0 + keySpacing, 78);
        currentX = 0.0;
        KeyboardFactory.addHorizontalRow(kb, 71, 73, currentX, currentY += keyHeight + keySpacing, keyWidth, keyHeight, keySpacing);
        currentX = KeyboardFactory.addHorizontalRow(kb, 75, 77, currentX, currentY += keyHeight + keySpacing, keyWidth, keyHeight, keySpacing);
        kb.addKey(currentX, currentY, keyWidth / 3.0, keyHeight * 3.0 + keySpacing * 2.0, 156);
        currentX = 0.0;
        KeyboardFactory.addHorizontalRow(kb, 79, 81, currentX, currentY += keyHeight + keySpacing, keyWidth, keyHeight, keySpacing);
        kb.addKey(0.0, currentY += keyHeight + keySpacing, keyWidth * 2.0 + keySpacing, keyHeight, 82);
        kb.addKey(currentX += keyWidth * 2.0 + keySpacing * 2.0, currentY, keyWidth, keyHeight, 83);
        return kb;
    }

    private static GuiKeyboard makeAuxiliary(GuiKeyWizard parent, double x, double y, double width, double height) {
        GuiKeyboard kb = new GuiKeyboard(parent, x, y);
        double currentX = 0.0;
        double currentY = 0.0;
        double keySpacing = 5.0;
        double keyWidth = width / 5.0 - keySpacing;
        double keyHeight = height / 14.0;
        currentX = KeyboardFactory.addHorizontalRow(kb, new int[]{183, 70, 197, 100, 101}, currentX, currentY, keyWidth, keyHeight, keySpacing);
        currentX = 0.0;
        currentX = KeyboardFactory.addHorizontalRow(kb, new int[]{210, 199, 201, 102, 103}, currentX, currentY += keyHeight + keySpacing, keyWidth, keyHeight, keySpacing);
        currentX = 0.0;
        currentX = KeyboardFactory.addHorizontalRow(kb, new int[]{211, 207, 209, 104, 105}, currentX, currentY += keyHeight + keySpacing, keyWidth, keyHeight, keySpacing);
        currentX = 0.0;
        currentX = KeyboardFactory.addHorizontalRow(kb, new int[]{203, 205, 200, 208, 113}, currentX, currentY += keyHeight + keySpacing, keyWidth, keyHeight, keySpacing);
        return kb;
    }

    private static double addHorizontalRow(GuiKeyboard kb, int startCode, int endCode, double startX, double y, double width, double height, double spacing) {
        double currentX = startX;
        for (int i = startCode; i <= endCode; ++i) {
            kb.addKey(currentX, y, width, height, i);
            currentX += width + spacing;
        }
        return startX + (width * (double)(endCode - startCode + 1) + spacing * (double)(endCode - startCode + 1));
    }

    private static double addHorizontalRow(GuiKeyboard kb, int[] keys, double startX, double y, double width, double height, double spacing) {
        double currentX = startX;
        for (int k : keys) {
            kb.addKey(currentX, y, width, height, k);
            currentX += width + spacing;
        }
        return startX + (width * (double)keys.length + spacing * (double)keys.length);
    }
}

