/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.blocks;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.ultraamplifieddimension.UltraAmplifiedDimension;
import com.telepathicgrunt.ultraamplifieddimension.capabilities.IPlayerPosAndDim;
import com.telepathicgrunt.ultraamplifieddimension.capabilities.PlayerPositionAndDimension;
import com.telepathicgrunt.ultraamplifieddimension.dimension.AmplifiedPortalCreation;
import com.telepathicgrunt.ultraamplifieddimension.dimension.UADDimension;
import com.telepathicgrunt.ultraamplifieddimension.dimension.UADWorldSavedData;
import com.telepathicgrunt.ultraamplifieddimension.modInit.UADBlocks;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public class AmplifiedPortalBlock
extends Block {
    @CapabilityInject(value=IPlayerPosAndDim.class)
    public static Capability<IPlayerPosAndDim> PAST_POS_AND_DIM = null;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public AmplifiedPortalBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)MaterialColor.field_151646_E).func_235838_a_(blockState -> 15).func_200948_a(5.0f, 3600000.0f));
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState thisBlockState, World world, BlockPos position, PlayerEntity playerEntity, Hand playerHand, BlockRayTraceResult raytraceResult) {
        if (!(world.field_72995_K || playerEntity.func_184218_aH() || playerEntity.func_184207_aI() || !playerEntity.func_184222_aU() || playerEntity.func_213453_ef() || playerEntity.func_184600_cs() != playerHand)) {
            Vector3d playerVec3Pos;
            float yaw;
            float pitch;
            RegistryKey destinationKey;
            MinecraftServer minecraftserver = playerEntity.func_184102_h();
            PlayerPositionAndDimension cap = (PlayerPositionAndDimension)playerEntity.getCapability(PAST_POS_AND_DIM).orElseThrow(RuntimeException::new);
            boolean enteringUA = false;
            if (playerEntity.field_70170_p.func_234923_W_().equals(UADDimension.UAD_WORLD_KEY)) {
                if (UltraAmplifiedDimension.UADConfig.forceExitToOverworld.get().booleanValue()) {
                    destinationKey = World.field_234918_g_;
                } else {
                    destinationKey = cap.getNonUADim();
                    if (destinationKey == null) {
                        destinationKey = World.field_234918_g_;
                    }
                }
                pitch = cap.getNonUAPitch();
                yaw = cap.getNonUAYaw();
                cap.setUAPos(playerEntity.func_213303_ch());
                cap.setUAPitch(playerEntity.field_70125_A);
                cap.setUAYaw(playerEntity.field_70177_z);
            } else {
                destinationKey = UADDimension.UAD_WORLD_KEY;
                pitch = cap.getUAPitch();
                yaw = cap.getUAYaw();
                enteringUA = true;
                cap.setNonUAPos(playerEntity.func_213303_ch());
                cap.setNonUADim((RegistryKey<World>)playerEntity.field_70170_p.func_234923_W_());
                cap.setNonUAPitch(playerEntity.field_70125_A);
                cap.setNonUAYaw(playerEntity.field_70177_z);
            }
            ServerWorld destinationWorld = minecraftserver.func_71218_a(destinationKey);
            if (destinationWorld == null) {
                destinationKey = World.field_234918_g_;
                destinationWorld = minecraftserver.func_71218_a(destinationKey);
            }
            if (destinationKey.equals(UADDimension.UAD_WORLD_KEY) && !AmplifiedPortalCreation.checkForGeneratedPortal((IWorld)destinationWorld)) {
                AmplifiedPortalCreation.generatePortal(destinationWorld);
            }
            if (enteringUA && cap.getUAPos() == null) {
                int portalY;
                BlockPos worldOriginBlockPos = new BlockPos(10, 0, 8);
                for (portalY = world.func_234938_ad_(); portalY > 0 && destinationWorld.func_180495_p(worldOriginBlockPos.func_177981_b(portalY)) != ((Block)UADBlocks.AMPLIFIED_PORTAL.get()).func_176223_P(); --portalY) {
                }
                if (portalY == 0) {
                    playerVec3Pos = Vector3d.func_237489_a_((Vector3i)destinationWorld.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, worldOriginBlockPos)).func_72441_c(0.0, 0.5, 0.0);
                } else {
                    worldOriginBlockPos = worldOriginBlockPos.func_177981_b(portalY - 1);
                    boolean validSpaceFound = false;
                    for (int x = -2; x < 3; ++x) {
                        for (int z = -2; z < 3; ++z) {
                            if (x != -2 && x != 2 && z != -2 && z != 2 || destinationWorld.func_180495_p(worldOriginBlockPos.func_177982_a(x, 0, z)).func_185904_a() != Material.field_151579_a || destinationWorld.func_180495_p(worldOriginBlockPos.func_177982_a(x, 1, z)).func_185904_a() != Material.field_151579_a) continue;
                            worldOriginBlockPos = worldOriginBlockPos.func_177982_a(x, 0, z);
                            validSpaceFound = true;
                            z = 3;
                            x = 3;
                        }
                    }
                    if (!validSpaceFound) {
                        worldOriginBlockPos = destinationWorld.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPos(10, world.func_234938_ad_(), 8));
                    }
                    playerVec3Pos = Vector3d.func_237489_a_((Vector3i)worldOriginBlockPos).func_72441_c(0.0, -0.3, 0.0);
                }
            } else if (enteringUA) {
                playerVec3Pos = cap.getUAPos();
            } else if (cap.getNonUAPos() == null || UltraAmplifiedDimension.UADConfig.forceExitToOverworld.get().booleanValue()) {
                BlockPos playerBlockPos = destinationWorld.func_205770_a(Heightmap.Type.MOTION_BLOCKING, destinationWorld.func_241135_u_());
                BlockState blockState = destinationWorld.func_180495_p(playerBlockPos);
                while (blockState.func_185904_a() != Material.field_151579_a && playerBlockPos.func_177956_o() < destinationWorld.func_234938_ad_() - 2) {
                    playerBlockPos = playerBlockPos.func_177984_a();
                    blockState = destinationWorld.func_180495_p(playerBlockPos);
                }
                destinationWorld.func_175656_a(playerBlockPos, ((Block)UADBlocks.AMPLIFIED_PORTAL.get()).func_176223_P());
                playerVec3Pos = Vector3d.func_237489_a_((Vector3i)playerBlockPos).func_72441_c(0.0, 0.5, 0.0);
            } else {
                playerVec3Pos = cap.getNonUAPos();
            }
            if (playerEntity.func_70608_bn()) {
                playerEntity.func_213366_dy();
            }
            UADWorldSavedData.get((ServerWorld)world).addPlayer(playerEntity, (RegistryKey<World>)destinationKey, playerVec3Pos, (Pair<Float, Float>)new Pair((Object)Float.valueOf(yaw), (Object)Float.valueOf(pitch)));
            AmplifiedPortalBlock.createLotsOfParticles((ServerWorld)world, playerEntity.func_213303_ch(), world.field_73012_v);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(thisBlockState, world, position, playerEntity, playerHand, raytraceResult);
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (player != null && player.func_184812_l_()) {
            this.getBlock().func_176208_a(world, pos, state, player);
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            return true;
        }
        if (world.func_234923_W_().equals(UADDimension.UAD_WORLD_KEY) && pos.func_177958_n() == 8 && pos.func_177952_p() == 8) {
            Block blockToCheck;
            BlockPos posOfHighestPortal = new BlockPos(pos.func_177958_n(), world.func_234938_ad_(), pos.func_177952_p());
            while (posOfHighestPortal.func_177956_o() >= 0 && (blockToCheck = world.func_180495_p(posOfHighestPortal).func_177230_c()) != UADBlocks.AMPLIFIED_PORTAL.get()) {
                posOfHighestPortal = posOfHighestPortal.func_177977_b();
            }
            if (posOfHighestPortal.func_177956_o() == pos.func_177956_o()) {
                return false;
            }
        }
        this.getBlock().func_176208_a(world, pos, state, player);
        return world.func_217377_a(pos, false);
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        return ItemStack.field_190927_a;
    }

    @Deprecated
    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        AmplifiedPortalBlock.createLotsOfParticles((ServerWorld)world, new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), world.field_73012_v);
    }

    public static void createLotsOfParticles(ServerWorld world, Vector3d position, Random random) {
        double xPos = position.func_82615_a() + 0.5;
        double yPos = position.func_82617_b() + 0.5;
        double zPos = position.func_82616_c() + 0.5;
        double xOffset = ((double)random.nextFloat() - 0.4) * 0.8;
        double zOffset = ((double)random.nextFloat() - 0.4) * 0.8;
        world.func_195598_a((IParticleData)ParticleTypes.field_197631_x, xPos, yPos, zPos, 50, xOffset, 0.0, zOffset, (double)random.nextFloat() * 0.1 + 0.05);
    }

    public void func_180655_c(BlockState stateIn, World world, BlockPos pos, Random rand) {
        double d0 = (float)pos.func_177958_n() + (rand.nextFloat() * 3.0f - 1.0f);
        double d1 = (float)pos.func_177956_o() + (rand.nextFloat() * 3.0f - 1.0f);
        double d2 = (float)pos.func_177952_p() + (rand.nextFloat() * 3.0f - 1.0f);
        world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0, d1, d2, 0.0, 0.0, 0.0);
    }
}

