/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.capabilities;

import com.telepathicgrunt.ultraamplifieddimension.UltraAmplifiedDimension;
import com.telepathicgrunt.ultraamplifieddimension.capabilities.IPlayerPosAndDim;
import com.telepathicgrunt.ultraamplifieddimension.dimension.UADDimension;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class PlayerPositionAndDimension
implements IPlayerPosAndDim {
    public RegistryKey<World> nonUADimension = World.field_234918_g_;
    public Vector3d nonUABlockPos = null;
    public float nonUAPitch = 0.0f;
    public float nonUAYaw = 0.0f;
    public Vector3d UABlockPos = null;
    public float UAPitch = 3.75f;
    public float UAYaw = 90.0f;

    @Override
    public void setNonUADim(RegistryKey<World> incomingDim) {
        if (incomingDim == UADDimension.UAD_WORLD_KEY) {
            this.nonUADimension = World.field_234918_g_;
            UltraAmplifiedDimension.LOGGER.log(Level.ERROR, "Tried to set the NonUADimension variable to UA dimension. Please contact mod owner to report this!");
        } else {
            this.nonUADimension = incomingDim;
        }
    }

    @Override
    public RegistryKey<World> getNonUADim() {
        return this.nonUADimension;
    }

    @Override
    public void setNonUAPitch(float incomingPitch) {
        this.nonUAPitch = incomingPitch;
    }

    @Override
    public float getNonUAPitch() {
        return this.nonUAPitch;
    }

    @Override
    public void setNonUAYaw(float incomingYaw) {
        this.nonUAYaw = incomingYaw;
    }

    @Override
    public float getNonUAYaw() {
        return this.nonUAYaw;
    }

    @Override
    public void setNonUAPos(Vector3d incomingPos) {
        this.nonUABlockPos = incomingPos;
    }

    @Override
    public Vector3d getNonUAPos() {
        return this.nonUABlockPos;
    }

    @Override
    public void setUAPos(Vector3d incomingPos) {
        this.UABlockPos = incomingPos;
    }

    @Override
    public Vector3d getUAPos() {
        return this.UABlockPos;
    }

    @Override
    public void setUAPitch(float incomingPitch) {
        this.UAPitch = incomingPitch;
    }

    @Override
    public float getUAPitch() {
        return this.UAPitch;
    }

    @Override
    public void setUAYaw(float incomingYaw) {
        this.UAYaw = incomingYaw;
    }

    @Override
    public float getUAYaw() {
        return this.UAYaw;
    }

    @Override
    public CompoundNBT saveNBTData() {
        CompoundNBT data = new CompoundNBT();
        if (this.getNonUAPos() != null) {
            data.func_74780_a("NonUA_X", this.getNonUAPos().field_72450_a);
            data.func_74780_a("NonUA_Y", this.getNonUAPos().field_72448_b);
            data.func_74780_a("NonUA_Z", this.getNonUAPos().field_72449_c);
        }
        data.func_74776_a("NonUAPitch", this.nonUAPitch);
        data.func_74776_a("NonUAYaw", this.nonUAYaw);
        if (this.getUAPos() != null) {
            data.func_74780_a("UA_X", this.getUAPos().field_72450_a);
            data.func_74780_a("UA_Y", this.getUAPos().field_72448_b);
            data.func_74780_a("UA_Z", this.getUAPos().field_72449_c);
        }
        data.func_74776_a("UAPitch", this.UAPitch);
        data.func_74776_a("UAYaw", this.UAYaw);
        if (this.getNonUADim() != null) {
            data.func_74778_a("NonUADimensionNamespace", this.getNonUADim().getRegistryName().func_110624_b());
            data.func_74778_a("NonUADimensionPath", this.getNonUADim().getRegistryName().func_110623_a());
        }
        return data;
    }

    @Override
    public void loadNBTData(CompoundNBT nbtTag) {
        Vector3d storedPositionNonUA = null;
        Vector3d storePositionUA = null;
        RegistryKey storedDimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(nbtTag.func_74779_i("NonUADimensionPath")));
        if (nbtTag.func_74764_b("NonUA_X") && nbtTag.func_74764_b("NonUA_Y") && nbtTag.func_74764_b("NonUA_Z")) {
            storedPositionNonUA = new Vector3d((double)nbtTag.func_74760_g("NonUA_X"), (double)nbtTag.func_74760_g("NonUA_Y"), (double)nbtTag.func_74760_g("NonUA_Z"));
        }
        float storedNonUAPitch = nbtTag.func_74760_g("NonUAPitch");
        float storedNonUAYaw = nbtTag.func_74760_g("NonUAYaw");
        if (nbtTag.func_74764_b("UA_X") && nbtTag.func_74764_b("UA_Y") && nbtTag.func_74764_b("UA_Z")) {
            storePositionUA = new Vector3d((double)nbtTag.func_74760_g("UA_X"), (double)nbtTag.func_74760_g("UA_Y"), (double)nbtTag.func_74760_g("UA_Z"));
        }
        float storedUAPitch = nbtTag.func_74760_g("UAPitch");
        float storedUAYaw = nbtTag.func_74760_g("UAYaw");
        this.setNonUADim((RegistryKey<World>)storedDimension);
        this.setNonUAPitch(storedNonUAPitch);
        this.setNonUAYaw(storedNonUAYaw);
        this.setNonUAPos(storedPositionNonUA);
        this.setUAPitch(storedUAPitch);
        this.setUAYaw(storedUAYaw);
        this.setUAPos(storePositionUA);
    }
}

