/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.config;

import com.telepathicgrunt.ultraamplifieddimension.utils.ConfigHelper;
import net.minecraftforge.common.ForgeConfigSpec;

public class UADimensionConfig {

    public static class UADimensionConfigValues {
        public ConfigHelper.ConfigValueListener<Boolean> heavyFog;
        public ConfigHelper.ConfigValueListener<Integer> cloudHeight;
        public ConfigHelper.ConfigValueListener<Boolean> forceExitToOverworld;
        public ConfigHelper.ConfigValueListener<Boolean> allowNetherPortal;

        public UADimensionConfigValues(ForgeConfigSpec.Builder builder, ConfigHelper.Subscriber subscriber) {
            builder.push("General Dimension Options");
            this.heavyFog = subscriber.subscribe(builder.comment(new String[]{"\n Adds very heavy fog to make the world look more spooky and limit visibility.", " This is not the same as distance fog which only applies weakly to chunks in the far distance."}).translation("ultraamplified.config.dimension.heavyfog").define("heavyFog", false));
            this.cloudHeight = subscriber.subscribe(builder.comment(new String[]{"\n Maximum height for clouds to be at.", " Default is 245."}).translation("ultraamplified.config.dimension.cloudheight").defineInRange("cloudHeight", 245, -50, 400));
            this.allowNetherPortal = subscriber.subscribe(builder.comment(new String[]{"\n Lets Nether Portals be able to be created in Ultra Amplified Dimension.", " Using the portal in this dimension will take you to the Nether but Nether", " Portals in the Nether will take you to the Overworld instead. So this option", " is good if you want a second way of escaping the Ultra Amplified Dimension."}).translation("ultraamplified.config.dimension.allownetherportal").define("allowNetherPortal", false));
            this.forceExitToOverworld = subscriber.subscribe(builder.comment(new String[]{"\n Makes leaving the Ultra Amplified dimension by Amplified Portal Block", " always places you back in the Overworld regardless of which dimension you", " originally came from. Use this option if this dimension becomes locked in", " with another dimension so you are stuck teleporting between the two and cannot", " get back to the Overworld."}).translation("ultraamplified.config.dimension.forceexittooverworld").define("forceExitToOverworld", false));
            builder.pop();
        }
    }
}

