/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.dimension;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.ultraamplifieddimension.blocks.AmplifiedPortalBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.storage.WorldSavedData;

public class UADWorldSavedData
extends WorldSavedData {
    public static final String DATA_KEY = "ultra_amplified_dimension:delayed_teleportation";
    private List<TeleportEntry> teleportingEntities = new ArrayList<TeleportEntry>();
    private List<SpawnParticles> particles = new ArrayList<SpawnParticles>();

    public UADWorldSavedData() {
        super(DATA_KEY);
    }

    public static UADWorldSavedData get(ServerWorld world) {
        return (UADWorldSavedData)world.func_217481_x().func_215752_a(UADWorldSavedData::new, DATA_KEY);
    }

    public static void tick(ServerWorld world) {
        MinecraftServer server = world.func_73046_m();
        UADWorldSavedData data = UADWorldSavedData.get(world);
        List<TeleportEntry> entityList = data.teleportingEntities;
        data.teleportingEntities = new ArrayList<TeleportEntry>();
        List<SpawnParticles> particleList = data.particles;
        data.particles = new ArrayList<SpawnParticles>();
        for (SpawnParticles spawnParticles : particleList) {
            ServerWorld targetWorld = server.func_71218_a(spawnParticles.targetWorld);
            if (targetWorld == null) continue;
            AmplifiedPortalBlock.createLotsOfParticles(targetWorld, spawnParticles.targetVec, targetWorld.field_73012_v);
        }
        for (TeleportEntry teleportEntry : entityList) {
            ServerPlayerEntity player = server.func_184103_al().func_177451_a(teleportEntry.playerUUID);
            ServerWorld targetWorld = server.func_71218_a(teleportEntry.targetWorld);
            if (player == null || targetWorld == null || player.field_70170_p != world) continue;
            ChunkPos playerChunkPos = new ChunkPos(player.func_233580_cy_());
            targetWorld.func_72863_F().func_217228_a(TicketType.field_223185_g, playerChunkPos, 1, (Object)player.func_145782_y());
            player.field_70143_R = 0.0f;
            player.field_70167_r = 0.0;
            player.func_200619_a(targetWorld, teleportEntry.targetVec.func_82615_a(), teleportEntry.targetVec.func_82617_b() + 0.2, teleportEntry.targetVec.func_82616_c(), ((Float)teleportEntry.targetLook.getFirst()).floatValue(), ((Float)teleportEntry.targetLook.getSecond()).floatValue());
            data.addParticle(teleportEntry.targetWorld, new Vector3d(teleportEntry.targetVec.field_72450_a - 0.5, teleportEntry.targetVec.field_72448_b, teleportEntry.targetVec.field_72449_c - 0.5));
        }
    }

    public void addPlayer(PlayerEntity player, RegistryKey<World> destination, Vector3d targetVec, Pair<Float, Float> targetLook) {
        this.teleportingEntities.add(new TeleportEntry(PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH()), destination, targetVec, targetLook));
    }

    public void addParticle(RegistryKey<World> destination, Vector3d targetVec) {
        this.particles.add(new SpawnParticles(destination, targetVec));
    }

    public void func_76184_a(CompoundNBT nbt) {
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        return compound;
    }

    static class SpawnParticles {
        final RegistryKey<World> targetWorld;
        final Vector3d targetVec;

        public SpawnParticles(RegistryKey<World> targetWorld, Vector3d targetVec) {
            this.targetWorld = targetWorld;
            this.targetVec = targetVec;
        }
    }

    static class TeleportEntry {
        final UUID playerUUID;
        final RegistryKey<World> targetWorld;
        final Vector3d targetVec;
        final Pair<Float, Float> targetLook;

        public TeleportEntry(UUID playerUUID, RegistryKey<World> targetWorld, Vector3d targetVec, Pair<Float, Float> targetLook) {
            this.playerUUID = playerUUID;
            this.targetWorld = targetWorld;
            this.targetVec = targetVec;
            this.targetLook = targetLook;
        }
    }
}

