/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.modInit;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.telepathicgrunt.ultraamplifieddimension.world.structures.GenericJigsawStructure;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class UADStructures {
    public static Set<Structure<?>> REGISTERED_UAD_STRUCTURES = new HashSet();
    public static final DeferredRegister<Structure<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"ultra_amplified_dimension");
    public static final RegistryObject<Structure<NoFeatureConfig>> SUN_SHRINE = STRUCTURES.register("sun_shrine", () -> new GenericJigsawStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, new ResourceLocation("ultra_amplified_dimension", "sun_shrine_start"), 10, 0, 0, 0));
    public static final RegistryObject<Structure<NoFeatureConfig>> STONEHENGE = STRUCTURES.register("stonehenge", () -> new GenericJigsawStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, new ResourceLocation("ultra_amplified_dimension", "stonehenge/center_start"), 10, -2, 0, 0));
    public static final RegistryObject<Structure<NoFeatureConfig>> ICE_SPIKE_TEMPLE = STRUCTURES.register("ice_spike_temple", () -> new GenericJigsawStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, new ResourceLocation("ultra_amplified_dimension", "ice_spike_temple/body_start"), 10, -7, 0, 1));
    public static final RegistryObject<Structure<NoFeatureConfig>> MUSHROOM_TEMPLE = STRUCTURES.register("mushroom_temple", () -> new GenericJigsawStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, new ResourceLocation("ultra_amplified_dimension", "mushroom_temple/body_start"), 10, -2, 0, 1));

    public static void setupStructures() {
        UADStructures.setupMapSpacingAndLand((Structure)SUN_SHRINE.get(), true);
        UADStructures.setupMapSpacingAndLand((Structure)STONEHENGE.get(), true);
        UADStructures.setupMapSpacingAndLand((Structure)ICE_SPIKE_TEMPLE.get(), false);
        UADStructures.setupMapSpacingAndLand((Structure)MUSHROOM_TEMPLE.get(), false);
    }

    public static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        REGISTERED_UAD_STRUCTURES.add(structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
    }
}

