/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.utils;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;

public class GeneralUtils {
    private static final Map<String, BlockState> FILLER_BIOME_MAP = new HashMap<String, BlockState>();
    private static final Map<String, BlockState> LAVA_FLOOR_BIOME_MAP;
    private static final Map<BlockState, Boolean> IS_FULLCUBE_MAP;

    public static String biomeIDString(String biomeName) {
        return "ultra_amplified_dimension:" + biomeName;
    }

    public static <T> T getRandomEntry(List<Pair<T, Integer>> rlList, Random random) {
        int index;
        if (rlList.isEmpty()) {
            return null;
        }
        double totalWeight = 0.0;
        for (Pair<T, Integer> pair : rlList) {
            totalWeight += (double)((Integer)pair.getSecond()).intValue();
        }
        double randomWeightPicked = (double)random.nextFloat() * totalWeight;
        for (index = 0; index < rlList.size() - 1 && !((randomWeightPicked -= (double)((Integer)rlList.get(index).getSecond()).intValue()) <= 0.0); ++index) {
        }
        return (T)rlList.get(index).getFirst();
    }

    public static BlockState carverLavaReplacement(String biomeIDString, Biome biome) {
        BlockState replacementBlock = LAVA_FLOOR_BIOME_MAP.get(biomeIDString);
        if (replacementBlock == null) {
            if (biome.func_201856_r() == Biome.Category.ICY) {
                if ((double)biome.func_242445_k() < -0.5) {
                    LAVA_FLOOR_BIOME_MAP.put(biomeIDString, Blocks.field_150343_Z.func_176223_P());
                } else {
                    LAVA_FLOOR_BIOME_MAP.put(biomeIDString, Blocks.field_196814_hQ.func_176223_P());
                }
            } else {
                LAVA_FLOOR_BIOME_MAP.put(biomeIDString, Blocks.field_150353_l.func_176223_P());
            }
            replacementBlock = LAVA_FLOOR_BIOME_MAP.get(biomeIDString);
        }
        return replacementBlock;
    }

    public static BlockState carverFillerBlock(String biomeIDString, Biome biome) {
        BlockState replacementBlock = FILLER_BIOME_MAP.get(biomeIDString);
        if (replacementBlock == null) {
            if (biome.func_201856_r() == Biome.Category.THEEND) {
                FILLER_BIOME_MAP.put(biomeIDString, Blocks.field_150377_bs.func_176223_P());
            } else if (biome.func_201856_r() == Biome.Category.NETHER) {
                FILLER_BIOME_MAP.put(biomeIDString, Blocks.field_150424_aL.func_176223_P());
            } else if (biome.func_201856_r() == Biome.Category.ICY && (double)biome.func_242445_k() < -0.5) {
                FILLER_BIOME_MAP.put(biomeIDString, Blocks.field_150432_aD.func_176223_P());
            } else {
                FILLER_BIOME_MAP.put(biomeIDString, Blocks.field_150348_b.func_176223_P());
            }
            replacementBlock = FILLER_BIOME_MAP.get(biomeIDString);
        }
        return replacementBlock;
    }

    public static boolean isFullCube(ISeedReader world, BlockPos pos, BlockState state) {
        if (!IS_FULLCUBE_MAP.containsKey(state)) {
            boolean isFullCube = Block.func_208062_a((VoxelShape)state.func_196954_c((IBlockReader)world, pos));
            IS_FULLCUBE_MAP.put(state, isFullCube);
        }
        return IS_FULLCUBE_MAP.get(state);
    }

    public static BlockState orientateChest(ISeedReader blockView, BlockPos blockPos, BlockState blockState) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        Direction bestDirection = (Direction)blockState.func_177229_b((Property)HorizontalBlock.field_185512_D);
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            mutable.func_189533_g((Vector3i)blockPos).func_189536_c(facing);
            if (!GeneralUtils.isFullCube(blockView, (BlockPos)mutable, blockView.func_180495_p((BlockPos)mutable))) continue;
            bestDirection = facing;
            mutable.func_189534_c(facing.func_176734_d(), 2);
            if (blockView.func_180495_p((BlockPos)mutable).func_185904_a().func_76220_a()) continue;
            break;
        }
        return (BlockState)blockState.func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)bestDirection.func_176734_d());
    }

    static {
        FILLER_BIOME_MAP.put(GeneralUtils.biomeIDString("iced_terrain"), Blocks.field_150432_aD.func_176223_P());
        FILLER_BIOME_MAP.put(GeneralUtils.biomeIDString("ice_spikes"), Blocks.field_150432_aD.func_176223_P());
        FILLER_BIOME_MAP.put(GeneralUtils.biomeIDString("deep_frozen_ocean"), Blocks.field_150432_aD.func_176223_P());
        FILLER_BIOME_MAP.put(GeneralUtils.biomeIDString("frozen_ocean"), Blocks.field_150432_aD.func_176223_P());
        LAVA_FLOOR_BIOME_MAP = new HashMap<String, BlockState>();
        LAVA_FLOOR_BIOME_MAP.put(GeneralUtils.biomeIDString("iced_terrain"), Blocks.field_150343_Z.func_176223_P());
        LAVA_FLOOR_BIOME_MAP.put(GeneralUtils.biomeIDString("ice_spikes"), Blocks.field_196814_hQ.func_176223_P());
        LAVA_FLOOR_BIOME_MAP.put(GeneralUtils.biomeIDString("relic_snowy_taiga"), Blocks.field_196814_hQ.func_176223_P());
        LAVA_FLOOR_BIOME_MAP.put(GeneralUtils.biomeIDString("snowy_rocky_taiga"), Blocks.field_196814_hQ.func_176223_P());
        LAVA_FLOOR_BIOME_MAP.put(GeneralUtils.biomeIDString("snowy_taiga"), Blocks.field_196814_hQ.func_176223_P());
        LAVA_FLOOR_BIOME_MAP.put(GeneralUtils.biomeIDString("snowy_tundra"), Blocks.field_196814_hQ.func_176223_P());
        LAVA_FLOOR_BIOME_MAP.put(GeneralUtils.biomeIDString("frozen_desert"), Blocks.field_196814_hQ.func_176223_P());
        LAVA_FLOOR_BIOME_MAP.put(GeneralUtils.biomeIDString("deep_frozen_ocean"), Blocks.field_196814_hQ.func_176223_P());
        LAVA_FLOOR_BIOME_MAP.put(GeneralUtils.biomeIDString("frozen_ocean"), Blocks.field_196814_hQ.func_176223_P());
        IS_FULLCUBE_MAP = new HashMap<BlockState, Boolean>();
    }
}

