/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.carver;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.ultraamplifieddimension.mixin.dimension.BiomeContainerAccessor;
import com.telepathicgrunt.ultraamplifieddimension.utils.GeneralUtils;
import com.telepathicgrunt.ultraamplifieddimension.utils.OpenSimplexNoise;
import com.telepathicgrunt.ultraamplifieddimension.world.carver.configs.CaveConfig;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.IObjectIntIterable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.carver.WorldCarver;

public class CaveCavityCarver
extends WorldCarver<CaveConfig> {
    private final float[] ledgeWidthArrayYIndex = new float[1024];
    protected static long NOISE_SEED;
    protected static OpenSimplexNoise NOISE_GEN;
    private SimpleRegistry<Biome> biomeRegistry;

    public static void setSeed(long seed) {
        if (NOISE_SEED != seed || NOISE_GEN == null) {
            NOISE_GEN = new OpenSimplexNoise(seed);
            NOISE_SEED = seed;
        }
    }

    public CaveCavityCarver(Codec<CaveConfig> codec) {
        super(codec, 250);
        this.field_222718_j = new HashSet(this.field_222718_j);
        this.field_222718_j.add(Blocks.field_150424_aL);
        this.field_222718_j.add(Blocks.field_150432_aD);
        this.field_222718_j.add(Blocks.field_196604_cC);
        this.field_222718_j.add(Blocks.field_150377_bs);
        this.field_222718_j.add(Blocks.field_150353_l);
    }

    public boolean shouldCarve(Random random, int chunkX, int chunkZ, CaveConfig config) {
        return random.nextFloat() <= config.probability;
    }

    public boolean carveRegion(IChunk region, Function<BlockPos, Biome> biomeBlockPos, Random random, int seaLevel, int chunkX, int chunkZ, int originalX, int originalZ, BitSet mask, CaveConfig config) {
        IObjectIntIterable<Biome> reg;
        IObjectIntIterable<Biome> iObjectIntIterable = reg = region.func_225549_i_() != null ? ((BiomeContainerAccessor)region.func_225549_i_()).uad_getBiomeRegistry() : null;
        if (reg instanceof SimpleRegistry && reg != this.biomeRegistry) {
            this.biomeRegistry = (SimpleRegistry)((BiomeContainerAccessor)region.func_225549_i_()).uad_getBiomeRegistry();
        }
        int maxIterations = (this.func_222704_c() * 2 - 1) * 16;
        double xpos = chunkX * 16 + random.nextInt(16);
        double height = random.nextInt(random.nextInt(2) + 1) + 34;
        double zpos = chunkZ * 16 + random.nextInt(16);
        float xzNoise2 = random.nextFloat() * (float)Math.PI;
        float xzCosNoise = (random.nextFloat() - 0.5f) / 16.0f;
        float widthHeightBase = (random.nextFloat() + random.nextFloat()) / 16.0f;
        this.carveCavity(region, biomeBlockPos, random, seaLevel, originalX, originalZ, xpos, height, zpos, widthHeightBase, xzNoise2, xzCosNoise, 0, maxIterations, random.nextDouble() + 20.0, mask, config);
        return true;
    }

    private void carveCavity(IChunk world, Function<BlockPos, Biome> biomeBlockPos, Random random, int seaLevel, int mainChunkX, int mainChunkZ, double randomBlockX, double randomBlockY, double randomBlockZ, float widthHeightBase, float xzNoise2, float xzCosNoise, int startIteration, int maxIteration, double heightMultiplier, BitSet mask, CaveConfig config) {
        float ledgeWidth = 1.0f;
        for (int currentHeight = 0; currentHeight <= config.cutoffHeight; ++currentHeight) {
            if (currentHeight > 44 && currentHeight < 60) {
                ledgeWidth = 1.0f + random.nextFloat() * 0.3f;
                ledgeWidth = (float)((double)ledgeWidth + Math.max(0.0, Math.pow((float)(currentHeight - 44) * 0.15f, 2.0)));
            } else if (currentHeight == 0 || random.nextInt(3) == 0) {
                ledgeWidth = 1.0f + random.nextFloat() * 0.5f;
            }
            this.ledgeWidthArrayYIndex[currentHeight] = ledgeWidth;
        }
        double placementXZBound = 2.0 + (double)(MathHelper.func_76126_a((float)((float)Math.PI / (float)maxIteration)) * widthHeightBase);
        double placementYBound = placementXZBound * heightMultiplier;
        this.carveAtTarget(world, biomeBlockPos, random, mainChunkX, mainChunkZ, randomBlockX, randomBlockY, randomBlockZ, placementXZBound *= 32.0, placementYBound *= 2.2, mask, config);
    }

    protected void carveAtTarget(IChunk world, Function<BlockPos, Biome> biomeBlockPos, Random random, int mainChunkX, int mainChunkZ, double xRange, double yRange, double zRange, double placementXZBound, double placementYBound, BitSet mask, CaveConfig config) {
        double xPos = mainChunkX * 16 + 8;
        double zPos = mainChunkZ * 16 + 8;
        double multipliedXZBound = placementXZBound * 2.0;
        if (!(xRange < xPos - 16.0 - multipliedXZBound || zRange < zPos - 16.0 - multipliedXZBound || xRange > xPos + 16.0 + multipliedXZBound || zRange > zPos + 16.0 + multipliedXZBound)) {
            int xMin = Math.max(MathHelper.func_76128_c((double)(xRange - placementXZBound)) - mainChunkX * 16 - 1, 0);
            int xMax = Math.min(MathHelper.func_76128_c((double)(xRange + placementXZBound)) - mainChunkX * 16 + 1, 16);
            int yMin = Math.max(MathHelper.func_76128_c((double)(yRange - placementYBound)) - 1, 5);
            int yMax = Math.min(MathHelper.func_76128_c((double)(yRange + placementYBound)) + 1, config.cutoffHeight);
            int zMin = Math.max(MathHelper.func_76128_c((double)(zRange - placementXZBound)) - mainChunkZ * 16 - 1, 0);
            int zMax = Math.min(MathHelper.func_76128_c((double)(zRange + placementXZBound)) - mainChunkZ * 16 + 1, 16);
            if (xMin <= xMax && yMin <= yMax && zMin <= zMax) {
                BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
                BlockPos.Mutable blockpos$Mutableup = new BlockPos.Mutable();
                BlockPos.Mutable blockpos$Mutabledown = new BlockPos.Mutable();
                double stalagmiteDouble = 0.0;
                for (int xInChunk = xMin; xInChunk < xMax; ++xInChunk) {
                    int x = xInChunk + mainChunkX * 16;
                    double xSquaringModified = ((double)x + 0.5 - xRange) / placementXZBound;
                    for (int zInChunk = zMin; zInChunk < zMax; ++zInChunk) {
                        BlockState secondaryFloorBlockstate;
                        BlockState fillerBlock;
                        int z = zInChunk + mainChunkZ * 16;
                        double zSquaringModified = ((double)z + 0.5 - zRange) / placementXZBound;
                        double xzSquaredModified = xSquaringModified * xSquaringModified + zSquaringModified * zSquaringModified;
                        if (!(xzSquaredModified < 1.0) || yMax < yMin) continue;
                        blockpos$Mutable.func_181079_c(x, 60, z);
                        if (yMax >= 60 || yMin < 11) {
                            Biome biome = biomeBlockPos.apply((BlockPos)blockpos$Mutable);
                            ResourceLocation biomeID = this.biomeRegistry != null ? this.biomeRegistry.func_177774_c((Object)biome) : null;
                            String biomeIDString = biomeID == null ? "" : biomeID.toString();
                            fillerBlock = GeneralUtils.carverFillerBlock(biomeIDString, biome);
                            secondaryFloorBlockstate = GeneralUtils.carverLavaReplacement(biomeIDString, biome);
                        } else {
                            fillerBlock = Blocks.field_150348_b.func_176223_P();
                            secondaryFloorBlockstate = Blocks.field_150353_l.func_176223_P();
                        }
                        for (int y = yMax; y > yMin; --y) {
                            double ySquaringModified;
                            if (mask.get(xInChunk | zInChunk << 4 | y << 8)) continue;
                            double yPillarModifier = y;
                            yPillarModifier = y > 30 ? (Math.pow((yPillarModifier - 30.0) * 0.033333, 2.0) * 30.0 - (double)y * 0.016666) * 18.0 : Math.pow(Math.pow(yPillarModifier - 30.0, 2.0) * 0.033333, 2.0) * 2.8;
                            if (yPillarModifier <= 0.0) {
                                yPillarModifier = 1.0E-5;
                            } else if (y < 10) {
                                yPillarModifier -= 50.0;
                            }
                            if (y < 60) {
                                boolean flagPillars;
                                boolean bl = flagPillars = NOISE_GEN.eval((double)x * 0.045 + (double)(x % 16) * 0.002, (double)z * 0.045 + (double)(z % 16) * 0.002, (double)y * 0.015) - yPillarModifier * 0.001 + random.nextDouble() * 0.01 > -0.32;
                                if (!flagPillars) continue;
                                if (y > 30) {
                                    boolean flagStalagmites;
                                    stalagmiteDouble = NOISE_GEN.eval((double)x * 0.25, (double)z * 0.25, 0.0) * 15.0 + 500.0 / (double)y;
                                    if (y > 48) {
                                        stalagmiteDouble -= ((double)y - 53.0) / 3.0;
                                    }
                                    boolean bl2 = flagStalagmites = stalagmiteDouble > 5.3;
                                    if (!flagStalagmites) continue;
                                }
                            }
                            if (!(xzSquaredModified * (double)this.ledgeWidthArrayYIndex[y - 1] + (ySquaringModified = ((double)(y - 1) + 0.5 - yRange) / placementYBound) * ySquaringModified / 6.0 + (double)(random.nextFloat() * 0.015f) < 1.0)) continue;
                            blockpos$Mutable.func_181079_c(x, y, z);
                            BlockState currentBlockstate = world.func_180495_p((BlockPos)blockpos$Mutable);
                            blockpos$Mutableup.func_189533_g((Vector3i)blockpos$Mutable).func_189536_c(Direction.UP);
                            blockpos$Mutabledown.func_189533_g((Vector3i)blockpos$Mutable).func_189536_c(Direction.DOWN);
                            BlockState aboveBlockstate = world.func_180495_p((BlockPos)blockpos$Mutableup);
                            if (y >= 60) {
                                if (!currentBlockstate.func_204520_s().func_206888_e()) {
                                    world.func_177436_a((BlockPos)blockpos$Mutable, fillerBlock, false);
                                    continue;
                                }
                                if (aboveBlockstate.func_204520_s().func_206888_e()) continue;
                                world.func_177436_a((BlockPos)blockpos$Mutable, fillerBlock, false);
                                world.func_177436_a((BlockPos)blockpos$Mutableup, fillerBlock, false);
                                world.func_177436_a((BlockPos)blockpos$Mutabledown, fillerBlock, false);
                                continue;
                            }
                            if (!this.func_222707_a(currentBlockstate, aboveBlockstate)) continue;
                            if (y < 11) {
                                currentBlockstate = Blocks.field_150353_l.func_176223_P();
                                if (secondaryFloorBlockstate != null) {
                                    if (secondaryFloorBlockstate.func_203425_a(Blocks.field_150343_Z)) {
                                        currentBlockstate = Blocks.field_196814_hQ.func_176223_P();
                                    }
                                    if (stalagmiteDouble > 13.5) {
                                        if (y == 10) {
                                            currentBlockstate = secondaryFloorBlockstate;
                                        } else if (y == 9 && random.nextBoolean()) {
                                            currentBlockstate = secondaryFloorBlockstate;
                                        }
                                    }
                                }
                                world.func_177436_a((BlockPos)blockpos$Mutable, currentBlockstate, false);
                            } else {
                                world.func_177436_a((BlockPos)blockpos$Mutable, field_222715_g, false);
                            }
                            mask.set(xInChunk | zInChunk << 4 | y << 8);
                        }
                    }
                }
            }
        }
    }

    protected boolean func_222708_a(double p_222708_1_, double p_222708_3_, double p_222708_5_, int p_222708_7_) {
        return true;
    }
}

