/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.carver;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.ultraamplifieddimension.mixin.dimension.BiomeContainerAccessor;
import com.telepathicgrunt.ultraamplifieddimension.utils.GeneralUtils;
import com.telepathicgrunt.ultraamplifieddimension.world.carver.configs.RavineConfig;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.IObjectIntIterable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.carver.WorldCarver;

public class RavineCarver
extends WorldCarver<RavineConfig> {
    private final float[] WALL_LEDGES = new float[1024];
    private SimpleRegistry<Biome> biomeRegistry;

    public RavineCarver(Codec<RavineConfig> codec) {
        super(codec, 255);
        this.field_222718_j = new HashSet(this.field_222718_j);
        this.field_222718_j.add(Blocks.field_150424_aL);
        this.field_222718_j.add(Blocks.field_150432_aD);
        this.field_222718_j.add(Blocks.field_196604_cC);
        this.field_222718_j.add(Blocks.field_150377_bs);
        this.field_222718_j.add(Blocks.field_150353_l);
    }

    public boolean shouldCarve(Random random, int chunkX, int chunkZ, RavineConfig config) {
        return random.nextFloat() <= config.probability;
    }

    public boolean carveRegion(IChunk region, Function<BlockPos, Biome> biomeBlockPos, Random random, int seaLevel, int chunkX, int chunkZ, int originalX, int originalZ, BitSet mask, RavineConfig config) {
        IObjectIntIterable<Biome> reg;
        IObjectIntIterable<Biome> iObjectIntIterable = reg = region.func_225549_i_() != null ? ((BiomeContainerAccessor)region.func_225549_i_()).uad_getBiomeRegistry() : null;
        if (reg instanceof SimpleRegistry && reg != this.biomeRegistry) {
            this.biomeRegistry = (SimpleRegistry)((BiomeContainerAccessor)region.func_225549_i_()).uad_getBiomeRegistry();
        }
        int i = (this.func_222704_c() * 2 - 1) * 16;
        double xpos = chunkX * 16 + random.nextInt(16);
        double height = config.heightPlacement.func_242259_a(random);
        double zpos = chunkZ * 16 + random.nextInt(16);
        float xzNoise2 = random.nextFloat() * ((float)Math.PI * 2);
        float xzCosNoise = (random.nextFloat() - 0.5f) / 8.0f;
        float widthHeightBase = (random.nextFloat() * 2.0f + random.nextFloat()) * 2.0f;
        int maxIteration = i - random.nextInt(i / 4);
        this.func_202535_a(region, biomeBlockPos, random.nextLong(), originalX, originalZ, xpos, height, zpos, widthHeightBase, xzNoise2, xzCosNoise, maxIteration, (double)config.tallness.func_242259_a(random) / 10.0, mask, config);
        return true;
    }

    private void func_202535_a(IChunk world, Function<BlockPos, Biome> biomeBlockPos, long randomSeed, int mainChunkX, int mainChunkZ, double randomBlockX, double randomBlockY, double randomBlockZ, float widthHeightBase, float xzNoise2, float xzCosNoise, int maxIteration, double heightMultiplier, BitSet mask, RavineConfig config) {
        Random random = new Random(randomSeed);
        float f = 1.0f;
        for (int i = 0; i < config.cutoffHeight; ++i) {
            if (i == 0 || random.nextInt(3) == 0) {
                f = 1.0f + random.nextFloat() * random.nextFloat();
            }
            this.WALL_LEDGES[i] = f * f;
        }
        float f4 = 0.0f;
        float f1 = 0.0f;
        for (int j = 0; j < maxIteration; ++j) {
            double placementXZBound = 2.0 + (double)(MathHelper.func_76126_a((float)((float)j * (float)Math.PI / (float)maxIteration)) * widthHeightBase);
            double placementYBound = placementXZBound * heightMultiplier;
            placementXZBound *= (double)random.nextFloat() * 0.15 + 0.65;
            placementYBound *= 0.8;
            float f2 = MathHelper.func_76134_b((float)xzCosNoise);
            randomBlockX += (double)(MathHelper.func_76134_b((float)xzNoise2) * f2);
            randomBlockZ += (double)(MathHelper.func_76126_a((float)xzNoise2) * f2);
            xzCosNoise *= 0.8f;
            xzCosNoise += f1 * 0.08f;
            xzNoise2 += f4 * 0.1f;
            f1 *= 0.8f;
            f4 *= 0.5f;
            f1 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 1.5f;
            f4 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 3.0f;
            if (random.nextInt(4) == 0) continue;
            if (!this.func_222702_a(mainChunkX, mainChunkZ, randomBlockX, randomBlockZ, j, maxIteration, widthHeightBase)) {
                return;
            }
            this.carveAtTarget(world, biomeBlockPos, random, mainChunkX, mainChunkZ, randomBlockX, randomBlockY, randomBlockZ, placementXZBound, placementYBound, mask, config);
        }
    }

    protected void carveAtTarget(IChunk world, Function<BlockPos, Biome> biomeBlockPos, Random random, int mainChunkX, int mainChunkZ, double xRange, double yRange, double zRange, double placementXZBound, double placementYBound, BitSet mask, RavineConfig config) {
        double d0 = mainChunkX * 16 + 8;
        double d1 = mainChunkZ * 16 + 8;
        if (!(xRange < d0 - 16.0 - placementXZBound * 2.0 || zRange < d1 - 16.0 - placementXZBound * 2.0 || xRange > d0 + 16.0 + placementXZBound * 2.0 || zRange > d1 + 16.0 + placementXZBound * 2.0)) {
            int i = Math.max(MathHelper.func_76128_c((double)(xRange - placementXZBound)) - mainChunkX * 16 - 1, 0);
            int j = Math.min(MathHelper.func_76128_c((double)(xRange + placementXZBound)) - mainChunkX * 16 + 1, 16);
            int minY = Math.max(MathHelper.func_76128_c((double)(yRange - placementYBound)) - 1, 9);
            int maxY = Math.min(MathHelper.func_76128_c((double)(yRange + placementYBound)) + 1, config.cutoffHeight);
            int i1 = Math.max(MathHelper.func_76128_c((double)(zRange - placementXZBound)) - mainChunkZ * 16 - 1, 0);
            int j1 = Math.min(MathHelper.func_76128_c((double)(zRange + placementXZBound)) - mainChunkZ * 16 + 1, 16);
            if (i <= j && minY <= maxY && i1 <= j1) {
                BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
                BlockPos.Mutable blockpos$Mutableup = new BlockPos.Mutable();
                BlockPos.Mutable blockpos$Mutabledown = new BlockPos.Mutable();
                for (int xInChunk = i; xInChunk < j; ++xInChunk) {
                    int x = xInChunk + mainChunkX * 16;
                    double xSquaringModified = ((double)x + 0.5 - xRange) / placementXZBound;
                    for (int zInChunk = i1; zInChunk < j1; ++zInChunk) {
                        BlockState secondaryFloorBlockstate;
                        BlockState fillerBlock;
                        int z = zInChunk + mainChunkZ * 16;
                        double zSquaringModified = ((double)z + 0.5 - zRange) / placementXZBound;
                        double xzSquaredModified = xSquaringModified * xSquaringModified + zSquaringModified * zSquaringModified;
                        if (!(xzSquaredModified < 1.0)) continue;
                        blockpos$Mutable.func_181079_c(x, 60, z);
                        if (maxY >= 60 || minY < 11) {
                            Biome biome = biomeBlockPos.apply((BlockPos)blockpos$Mutable);
                            ResourceLocation biomeID = this.biomeRegistry != null ? this.biomeRegistry.func_177774_c((Object)biome) : null;
                            String biomeIDString = biomeID == null ? "" : biomeID.toString();
                            fillerBlock = GeneralUtils.carverFillerBlock(biomeIDString, biome);
                            secondaryFloorBlockstate = GeneralUtils.carverLavaReplacement(biomeIDString, biome);
                        } else {
                            fillerBlock = Blocks.field_150348_b.func_176223_P();
                            secondaryFloorBlockstate = Blocks.field_150353_l.func_176223_P();
                        }
                        for (int y = maxY; y > minY; --y) {
                            double d4 = ((double)(y - 1) + 0.5 - yRange) / placementYBound;
                            if (!(xzSquaredModified * (double)this.WALL_LEDGES[y - 1] + d4 * d4 / 6.0 < 1.0)) continue;
                            blockpos$Mutable.func_181079_c(x, y, z);
                            BlockState currentBlockstate = world.func_180495_p((BlockPos)blockpos$Mutable);
                            blockpos$Mutableup.func_189533_g((Vector3i)blockpos$Mutable).func_189536_c(Direction.UP);
                            blockpos$Mutabledown.func_189533_g((Vector3i)blockpos$Mutable).func_189536_c(Direction.DOWN);
                            BlockState aboveBlockstate = world.func_180495_p((BlockPos)blockpos$Mutableup);
                            if (y >= 60 && !aboveBlockstate.func_204520_s().func_206888_e()) {
                                world.func_177436_a((BlockPos)blockpos$Mutable, fillerBlock, false);
                                world.func_177436_a((BlockPos)blockpos$Mutableup, fillerBlock, false);
                                world.func_177436_a((BlockPos)blockpos$Mutabledown, fillerBlock, false);
                                continue;
                            }
                            if (mask.get(xInChunk | zInChunk << 4 | y << 8) || !this.func_222707_a(currentBlockstate, aboveBlockstate)) continue;
                            if (y < 11) {
                                currentBlockstate = Blocks.field_150353_l.func_176223_P();
                                if (secondaryFloorBlockstate != null) {
                                    if (secondaryFloorBlockstate.func_203425_a(Blocks.field_150343_Z)) {
                                        currentBlockstate = Blocks.field_196814_hQ.func_176223_P();
                                    }
                                    if (random.nextFloat() > 0.35f) {
                                        if (y == 10) {
                                            currentBlockstate = secondaryFloorBlockstate;
                                        } else if (y == 9 && random.nextFloat() < 0.35f) {
                                            currentBlockstate = secondaryFloorBlockstate;
                                        }
                                    }
                                }
                                world.func_177436_a((BlockPos)blockpos$Mutable, currentBlockstate, false);
                            } else {
                                world.func_177436_a((BlockPos)blockpos$Mutable, field_222715_g, false);
                            }
                            mask.set(xInChunk | zInChunk << 4 | y << 8);
                        }
                    }
                }
            }
        }
    }

    protected boolean func_222708_a(double p_222708_1_, double p_222708_3_, double p_222708_5_, int p_222708_7_) {
        return true;
    }
}

