/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.ultraamplifieddimension.utils.GeneralUtils;
import com.telepathicgrunt.ultraamplifieddimension.utils.OpenSimplexNoise;
import com.telepathicgrunt.ultraamplifieddimension.world.features.configs.BoulderFeatureConfig;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;

public class Boulders
extends Feature<BoulderFeatureConfig> {
    protected long seed;
    protected static OpenSimplexNoise noiseGen;

    public void setSeed(long seed) {
        if (this.seed != seed || noiseGen == null) {
            noiseGen = new OpenSimplexNoise(seed);
            this.seed = seed;
        }
    }

    public Boulders(Codec<BoulderFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos position, BoulderFeatureConfig config) {
        BlockPos.Mutable blockposMutable = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        IChunk cachedChunk = world.func_217349_x((BlockPos)blockposMutable);
        if (blockposMutable.func_177956_o() > chunkGenerator.func_230355_e_() - config.maxRadius - 2) {
            return false;
        }
        this.setSeed(world.func_72905_C());
        int prevHeight = 0;
        for (int stackCount = 0; stackCount < config.boulderStackCount; ++stackCount) {
            int maxRadius = config.maxRadius;
            int minRadius = config.minRadius;
            int radiusModifier = stackCount / (int)Math.max(Math.ceil(config.boulderStackCount / config.maxRadius) + 1.0, 1.0);
            maxRadius = Math.max(maxRadius - radiusModifier, 1);
            minRadius = Math.max(minRadius - radiusModifier, 1);
            int startRadius = Math.max(random.nextInt(maxRadius - minRadius + 1) + minRadius, 1);
            int randMax = (int)Math.max((float)startRadius * 0.7f, 3.0f);
            int randMin = (int)Math.max((float)startRadius * 0.35f, 1.0f);
            for (int currentCount = 0; currentCount < 3; ++currentCount) {
                int x = Math.max(Math.min(startRadius + (random.nextInt(3) - 1), maxRadius), minRadius);
                int y = Math.max(Math.min(startRadius + (random.nextInt(3) - 1), maxRadius), minRadius);
                int z = Math.max(Math.min(startRadius + (random.nextInt(3) - 1), maxRadius), minRadius);
                float calculatedDistance = (float)(x + y + z) * 0.333f + 0.5f;
                for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)blockposMutable.func_177982_a(-x, -y, -z), (BlockPos)blockposMutable.func_177982_a(x, y, z))) {
                    if (!(blockpos.func_177951_i((Vector3i)blockposMutable) <= (double)(calculatedDistance * calculatedDistance))) continue;
                    double noiseValue = 1.0;
                    if (startRadius > 2) {
                        noiseValue = noiseGen.eval((double)blockpos.func_177958_n() * 0.035, (double)blockpos.func_177956_o() * 0.0075, (double)blockpos.func_177952_p() * 0.035);
                    }
                    if (blockpos.func_177951_i((Vector3i)blockposMutable) > (double)(calculatedDistance * calculatedDistance * 0.65f) && noiseValue > -0.3 && noiseValue < 0.3) continue;
                    if (blockpos.func_177958_n() >> 4 != cachedChunk.func_76632_l().field_77276_a || blockpos.func_177952_p() >> 4 != cachedChunk.func_76632_l().field_77275_b) {
                        cachedChunk = world.func_217349_x(blockpos);
                    }
                    BlockState boulderBlock = (BlockState)GeneralUtils.getRandomEntry(config.blockAndWeights, random);
                    cachedChunk.func_177436_a(blockpos, boulderBlock, false);
                }
                if (config.boulderStackCount > 1) {
                    blockposMutable.func_196234_d(random.nextInt(randMax) - randMin, random.nextInt(randMax) - randMin, random.nextInt(randMax) - randMin);
                    continue;
                }
                blockposMutable.func_196234_d(random.nextInt(startRadius * 2) - startRadius, 0, random.nextInt(startRadius * 2) - startRadius);
                blockposMutable.func_189534_c(Direction.UP, config.heightmapSpread ? world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, blockposMutable.func_177958_n(), blockposMutable.func_177952_p()) - random.nextInt(2) - blockposMutable.func_177956_o() : -random.nextInt(2));
            }
            blockposMutable.func_189533_g((Vector3i)position).func_196234_d(random.nextInt(randMax) - randMin, prevHeight += minRadius, random.nextInt(randMax) - randMin);
            if (blockposMutable.func_177958_n() >> 4 != cachedChunk.func_76632_l().field_77276_a || blockposMutable.func_177952_p() >> 4 != cachedChunk.func_76632_l().field_77275_b) {
                cachedChunk = world.func_217349_x((BlockPos)blockposMutable);
            }
            BlockState currentState = cachedChunk.func_180495_p((BlockPos)blockposMutable);
            while (!(currentState.func_196958_f() || currentState.func_235714_a_((ITag)BlockTags.field_206952_E) || currentState.func_235714_a_((ITag)BlockTags.field_200031_h))) {
                blockposMutable.func_189536_c(Direction.UP);
                currentState = cachedChunk.func_180495_p((BlockPos)blockposMutable);
            }
            if (blockposMutable.func_177956_o() <= chunkGenerator.func_230355_e_() - config.maxRadius - 2) continue;
            return false;
        }
        return true;
    }
}

