/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.ultraamplifieddimension.world.features.configs.DiskDryConfig;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class DiskDry
extends Feature<DiskDryConfig> {
    public DiskDry(Codec<DiskDryConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random random, BlockPos position, DiskDryConfig config) {
        int placedBlocks = 0;
        int radius = config.radius.func_242259_a(random);
        if (radius > 2) {
            radius = random.nextInt(radius - 2) + 2;
        }
        BlockPos.Mutable blockposMutable = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        IChunk cachedChunk = world.func_217349_x((BlockPos)blockposMutable);
        for (int x = position.func_177958_n() - radius; x <= position.func_177958_n() + radius; ++x) {
            for (int z = position.func_177952_p() - radius; z <= position.func_177952_p() + radius; ++z) {
                int trueZ;
                int trueX = x - position.func_177958_n();
                if (trueX * trueX + (trueZ = z - position.func_177952_p()) * trueZ > radius * radius) continue;
                blockposMutable.func_181079_c(x, position.func_177956_o(), z);
                if (blockposMutable.func_177958_n() >> 4 != cachedChunk.func_76632_l().field_77276_a || blockposMutable.func_177952_p() >> 4 != cachedChunk.func_76632_l().field_77275_b) {
                    cachedChunk = world.func_217349_x((BlockPos)blockposMutable);
                }
                blockposMutable.func_189534_c(Direction.DOWN, config.half_height);
                for (int y = -config.half_height; y <= config.half_height; ++y) {
                    BlockState aboveBlockState = cachedChunk.func_180495_p((BlockPos)blockposMutable.func_189536_c(Direction.UP));
                    BlockState blockState = cachedChunk.func_180495_p((BlockPos)blockposMutable.func_189536_c(Direction.DOWN));
                    if (!config.exposedOnly || !aboveBlockState.func_200132_m()) {
                        for (BlockState targetBlockState : config.targets) {
                            if (targetBlockState.func_177230_c() != blockState.func_177230_c()) continue;
                            cachedChunk.func_177436_a((BlockPos)blockposMutable, config.state, false);
                            ++placedBlocks;
                            if (!aboveBlockState.func_203425_a(Blocks.field_150433_aE) || aboveBlockState.func_196955_c((IWorldReader)world, (BlockPos)blockposMutable)) break;
                            cachedChunk.func_177436_a((BlockPos)blockposMutable.func_189536_c(Direction.UP), Blocks.field_150350_a.func_176223_P(), false);
                            blockposMutable.func_189536_c(Direction.DOWN);
                            break;
                        }
                    }
                    blockposMutable.func_189536_c(Direction.UP);
                }
            }
        }
        return placedBlocks > 0;
    }
}

