/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.features;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraftforge.common.Tags;

public class EllipsoidPocket
extends Feature<OreFeatureConfig> {
    private static final Map<RegistryKey<World>, Long2ReferenceOpenHashMap<IChunk>> CACHED_CHUNKS_ALL_WORLDS = new Reference2ObjectOpenHashMap();

    public EllipsoidPocket(Codec<OreFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random rand, BlockPos position, OreFeatureConfig config) {
        int minY;
        BlockPos.Mutable blockposMutable = new BlockPos.Mutable();
        float angleOfRotation = (float)(Math.PI * (double)rand.nextFloat());
        float sinOfAngle = MathHelper.func_76126_a((float)angleOfRotation);
        float cosOfAngle = MathHelper.func_76134_b((float)angleOfRotation);
        float size = (float)config.field_202443_c * 0.5f;
        boolean solidState = config.field_202444_d.func_200132_m();
        float stretchedFactor = 0.7f;
        if (config.field_202443_c < 10) {
            stretchedFactor = 1.0f;
        }
        int maxY = (int)(size / 3.0f);
        for (int y = minY = -maxY - 1; y <= maxY; ++y) {
            float yModified = y;
            if (y < 0) {
                yModified = (float)y + 0.25f;
            } else if (y > 0) {
                y = (int)((float)y + 0.5f);
            }
            float percentageOfRadius = 1.0f - yModified / size * (yModified / size) * 3.0f;
            float majorRadiusSq = size * percentageOfRadius * (size * percentageOfRadius);
            float minorRadiusSq = size * stretchedFactor * percentageOfRadius * (size * stretchedFactor * percentageOfRadius);
            int x = (int)(-size);
            while ((float)x < size) {
                int z = (int)(-size);
                while ((float)z < size) {
                    float majorComp = ((float)x + 0.5f) * cosOfAngle - ((float)z + 0.5f) * sinOfAngle;
                    float minorComp = ((float)x + 0.5f) * sinOfAngle + ((float)z + 0.5f) * cosOfAngle;
                    float result = majorComp * majorComp / (majorRadiusSq * majorRadiusSq) + minorComp * minorComp / (minorRadiusSq * minorRadiusSq);
                    if (result * 100.0f < 1.0f && (x != 0 || z != 0 || !((float)(y * y) >= size * size))) {
                        blockposMutable.func_181079_c(position.func_177958_n() + x, position.func_177956_o() + y, position.func_177952_p() + z);
                        IChunk cachedChunk = this.getCachedChunk(world, (BlockPos)blockposMutable);
                        BlockState blockToReplace = cachedChunk.func_180495_p((BlockPos)blockposMutable);
                        if (config.field_202442_b.func_215181_a(blockToReplace, rand) || Tags.Blocks.ORES.func_230235_a_((Object)blockToReplace.func_177230_c())) {
                            if (solidState) {
                                cachedChunk.func_177436_a((BlockPos)blockposMutable, config.field_202444_d, false);
                            } else {
                                boolean touchingLiquid = false;
                                for (Direction direction : Direction.values()) {
                                    if (direction == Direction.DOWN) continue;
                                    blockposMutable.func_189536_c(direction);
                                    cachedChunk = this.getCachedChunk(world, (BlockPos)blockposMutable);
                                    if (!cachedChunk.func_180495_p((BlockPos)blockposMutable).func_204520_s().func_206888_e()) {
                                        touchingLiquid = true;
                                        blockposMutable.func_189536_c(direction.func_176734_d());
                                        break;
                                    }
                                    blockposMutable.func_189536_c(direction.func_176734_d());
                                }
                                if (!touchingLiquid) {
                                    cachedChunk = this.getCachedChunk(world, (BlockPos)blockposMutable);
                                    cachedChunk.func_177436_a((BlockPos)blockposMutable, config.field_202444_d, false);
                                }
                            }
                        }
                    }
                    ++z;
                }
                ++x;
            }
        }
        return true;
    }

    public IChunk getCachedChunk(ISeedReader world, BlockPos blockpos) {
        long posLong;
        IChunk cachedChunk;
        RegistryKey worldKey = world.func_201672_e().func_234923_W_();
        Long2ReferenceOpenHashMap worldStorage = CACHED_CHUNKS_ALL_WORLDS.get(worldKey);
        if (worldStorage == null) {
            worldStorage = new Long2ReferenceOpenHashMap();
            CACHED_CHUNKS_ALL_WORLDS.put((RegistryKey<World>)worldKey, (Long2ReferenceOpenHashMap<IChunk>)worldStorage);
        }
        if (worldStorage.size() > 100) {
            worldStorage.clear();
        }
        if ((cachedChunk = (IChunk)worldStorage.get(posLong = (long)(blockpos.func_177958_n() >> 4) & 0xFFFFFFFFL | ((long)(blockpos.func_177952_p() >> 4) & 0xFFFFFFFFL) << 32)) == null) {
            cachedChunk = world.func_217349_x(blockpos);
            worldStorage.put(posLong, (Object)cachedChunk);
        }
        return cachedChunk;
    }
}

