/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.ultraamplifieddimension.modInit.UADBlocks;
import com.telepathicgrunt.ultraamplifieddimension.world.features.configs.CountConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;

public class GlowPatch
extends Feature<CountConfig> {
    private static Map<BlockState, BlockState> GLOWBLOCK_MAP;

    public static void setFillerMap() {
        if (GLOWBLOCK_MAP == null) {
            GLOWBLOCK_MAP = new HashMap<BlockState, BlockState>();
            GLOWBLOCK_MAP.put(Blocks.field_150346_d.func_176223_P(), ((Block)UADBlocks.GLOWDIRT.get()).func_176223_P());
            GLOWBLOCK_MAP.put(Blocks.field_196660_k.func_176223_P(), ((Block)UADBlocks.COARSE_GLOWDIRT.get()).func_176223_P());
            GLOWBLOCK_MAP.put(Blocks.field_196658_i.func_176223_P(), ((Block)UADBlocks.GLOWGRASS_BLOCK.get()).func_176223_P());
            GLOWBLOCK_MAP.put(Blocks.field_150391_bh.func_176223_P(), ((Block)UADBlocks.GLOWMYCELIUM.get()).func_176223_P());
            GLOWBLOCK_MAP.put(Blocks.field_150348_b.func_176223_P(), ((Block)UADBlocks.GLOWSTONE_ORE.get()).func_176223_P());
            GLOWBLOCK_MAP.put(Blocks.field_196661_l.func_176223_P(), ((Block)UADBlocks.GLOWPODZOL.get()).func_176223_P());
            GLOWBLOCK_MAP.put(Blocks.field_150354_m.func_176223_P(), ((Block)UADBlocks.GLOWSAND.get()).func_176223_P());
            GLOWBLOCK_MAP.put(Blocks.field_196611_F.func_176223_P(), ((Block)UADBlocks.RED_GLOWSAND.get()).func_176223_P());
        }
    }

    public GlowPatch(Codec<CountConfig> configFactory) {
        super(configFactory);
        GlowPatch.setFillerMap();
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random rand, BlockPos position, CountConfig countConfig) {
        BlockPos.Mutable blockposMutable = new BlockPos.Mutable();
        IChunk cachedChunk = world.func_217349_x(position);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            blockposMutable.func_189533_g((Vector3i)position).func_189534_c(direction, 6);
            int nearbyLandY = world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, blockposMutable.func_177958_n(), blockposMutable.func_177952_p());
            if (nearbyLandY >= position.func_177956_o()) continue;
            return false;
        }
        for (int attempts = 0; attempts < countConfig.count; ++attempts) {
            int gausX = (int)Math.max(Math.min(rand.nextGaussian() * 3.0, 15.0), -15.0);
            int gausY = rand.nextInt(4) - rand.nextInt(4);
            int gausZ = (int)Math.max(Math.min(rand.nextGaussian() * 3.0, 15.0), -15.0);
            blockposMutable.func_189533_g((Vector3i)position).func_196234_d(gausX, gausY + 1, gausZ);
            if (blockposMutable.func_177958_n() >> 4 != cachedChunk.func_76632_l().field_77276_a || blockposMutable.func_177952_p() >> 4 != cachedChunk.func_76632_l().field_77275_b) {
                cachedChunk = world.func_217349_x((BlockPos)blockposMutable);
            }
            BlockState chosenAboveBlock = cachedChunk.func_180495_p((BlockPos)blockposMutable);
            BlockState chosenBlock = cachedChunk.func_180495_p((BlockPos)blockposMutable.func_189536_c(Direction.DOWN));
            if (chosenBlock.func_177230_c() == Blocks.field_150348_b) {
                cachedChunk.func_177436_a((BlockPos)blockposMutable, GLOWBLOCK_MAP.get(chosenBlock), false);
                continue;
            }
            if (!GLOWBLOCK_MAP.containsKey(chosenBlock) || chosenAboveBlock.func_185904_a() != Material.field_151579_a) continue;
            cachedChunk.func_177436_a((BlockPos)blockposMutable, GLOWBLOCK_MAP.get(chosenBlock), false);
        }
        return true;
    }
}

