/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.features;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.telepathicgrunt.ultraamplifieddimension.UltraAmplifiedDimension;
import com.telepathicgrunt.ultraamplifieddimension.utils.GeneralUtils;
import com.telepathicgrunt.ultraamplifieddimension.world.features.configs.NbtFeatureConfig;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class NbtFeature
extends Feature<NbtFeatureConfig> {
    private final BlockIgnoreStructureProcessor IGNORE_STRUCTURE_VOID = new BlockIgnoreStructureProcessor((List)ImmutableList.of((Object)Blocks.field_189881_dj));
    private final PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)this.IGNORE_STRUCTURE_VOID).func_186222_a(false);

    public NbtFeature(Codec<NbtFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random rand, BlockPos position, NbtFeatureConfig config) {
        ResourceLocation nbtRL;
        if (config.nbtResourcelocationsAndWeights.size() == 0) {
            return false;
        }
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        int radius = config.solidLandRadius;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (Math.abs(x * z) <= radius || Math.abs(x * z) >= radius * 2) continue;
                blockpos$Mutable.func_189533_g((Vector3i)position).func_196234_d(-x, -1, -z);
                if (world.func_180495_p((BlockPos)blockpos$Mutable).func_200132_m()) continue;
                return false;
            }
        }
        TemplateManager templatemanager = world.func_201672_e().func_73046_m().func_240792_aT_();
        Template template = templatemanager.func_200219_b(nbtRL = (ResourceLocation)GeneralUtils.getRandomEntry(config.nbtResourcelocationsAndWeights, rand));
        if (template == null) {
            UltraAmplifiedDimension.LOGGER.warn(config.nbtResourcelocationsAndWeights.toString() + " NTB does not exist!");
            return false;
        }
        BlockPos halfLengths = new BlockPos(template.func_186259_a().func_177958_n() / 2, 0, template.func_186259_a().func_177952_p() / 2);
        this.placementsettings.func_186220_a(Rotation.func_222466_a((Random)rand)).func_207665_a(halfLengths).func_186222_a(false);
        if (config.processor != null) {
            config.processor.get().func_242919_a().forEach(arg_0 -> ((PlacementSettings)this.placementsettings).func_215222_a(arg_0));
        }
        template.func_237152_b_((IServerWorld)world, (BlockPos)blockpos$Mutable.func_189533_g((Vector3i)position).func_196234_d(-halfLengths.func_177958_n(), 0, -halfLengths.func_177952_p()), this.placementsettings, rand);
        return true;
    }
}

