/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.ultraamplifieddimension.utils.OpenSimplexNoise;
import com.telepathicgrunt.ultraamplifieddimension.world.features.configs.RootConfig;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.VineBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class Roots
extends Feature<RootConfig> {
    protected long seed;
    protected OpenSimplexNoise noiseGen;

    public Roots(Codec<RootConfig> configFactory) {
        super(configFactory);
    }

    public void setSeed(long seed) {
        if (this.seed != seed || this.noiseGen == null) {
            this.noiseGen = new OpenSimplexNoise(seed);
            this.seed = seed;
        }
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random rand, BlockPos position, RootConfig blockConfig) {
        this.setSeed(world.func_72905_C());
        BlockPos.Mutable blockposMutable = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        IChunk cachedChunk = world.func_217349_x((BlockPos)blockposMutable);
        int numOfRoots = 1 + (position.func_177956_o() - chunkGenerator.func_230356_f_()) / 50;
        int rootLength = 2 + (position.func_177956_o() - chunkGenerator.func_230356_f_()) / 22;
        block0: for (int rootNum = 1; rootNum < numOfRoots + 1; ++rootNum) {
            blockposMutable.func_189533_g((Vector3i)position);
            if (blockposMutable.func_177958_n() >> 4 != cachedChunk.func_76632_l().field_77276_a || blockposMutable.func_177952_p() >> 4 != cachedChunk.func_76632_l().field_77275_b) {
                cachedChunk = world.func_217349_x((BlockPos)blockposMutable);
            }
            for (int length = 0; length < rootLength; ++length) {
                int upwardOffset;
                BlockState currentBlockState = cachedChunk.func_180495_p((BlockPos)blockposMutable);
                if (blockposMutable.func_177956_o() > position.func_177956_o() || !blockConfig.rootReplaceTarget.func_215181_a(currentBlockState, rand) && currentBlockState != blockConfig.rootBlock && currentBlockState != Blocks.field_150395_bd.func_176223_P()) continue block0;
                boolean isUnderLedge = false;
                blockposMutable.func_189536_c(Direction.UP);
                for (upwardOffset = 1; upwardOffset < 8; ++upwardOffset) {
                    BlockState blockState = cachedChunk.func_180495_p((BlockPos)blockposMutable);
                    if (blockConfig.validAboveState.func_215181_a(blockState, rand)) {
                        isUnderLedge = true;
                        break;
                    }
                    blockposMutable.func_189536_c(Direction.UP);
                }
                if (isUnderLedge) {
                    blockposMutable.func_189534_c(Direction.DOWN, upwardOffset);
                    cachedChunk.func_177436_a((BlockPos)blockposMutable, blockConfig.rootBlock, false);
                    if (rand.nextFloat() < 0.05f) {
                        this.generateTinyVine((IWorld)world, cachedChunk, rand, blockposMutable);
                    }
                }
                int xOffset = (int)MathHelper.func_151237_a((double)(this.noiseGen.eval((double)blockposMutable.func_177958_n() * 1.0 + (double)(20000 * rootNum), (double)blockposMutable.func_177952_p() * 1.0 + (double)(20000 * rootNum), (double)blockposMutable.func_177956_o() * 0.2 + (double)(20000 * rootNum)) * 15.0), (double)-1.0, (double)1.0);
                int zOffset = (int)MathHelper.func_151237_a((double)(this.noiseGen.eval((double)blockposMutable.func_177958_n() * 1.0 + (double)(10000 * rootNum), (double)blockposMutable.func_177952_p() * 1.0 + (double)(10000 * rootNum), (double)blockposMutable.func_177956_o() * 0.2 + (double)(10000 * rootNum)) * 15.0), (double)-1.0, (double)1.0);
                int yOffset = (int)MathHelper.func_151237_a((double)(this.noiseGen.eval((double)blockposMutable.func_177958_n() * 0.85 - (double)(10000 * rootNum), (double)blockposMutable.func_177952_p() * 0.85 - (double)(10000 * rootNum), (double)blockposMutable.func_177956_o() * 0.5 - 10000.0) * 15.0 * (double)rootNum - 5.0), (double)-1.0, (double)1.0);
                blockposMutable.func_196234_d(xOffset, yOffset, zOffset);
                if (blockposMutable.func_177958_n() >> 4 == cachedChunk.func_76632_l().field_77276_a && blockposMutable.func_177952_p() >> 4 == cachedChunk.func_76632_l().field_77275_b) continue;
                cachedChunk = world.func_217349_x((BlockPos)blockposMutable);
            }
        }
        return true;
    }

    private void generateTinyVine(IWorld world, IChunk cachedChunkIn, Random rand, BlockPos.Mutable originalPosition) {
        BlockPos.Mutable blockposMutable = new BlockPos.Mutable().func_189533_g((Vector3i)originalPosition);
        int length = 0;
        blockposMutable.func_189536_c(Direction.Plane.HORIZONTAL.func_179518_a(rand));
        IChunk cachedChunk = cachedChunkIn;
        if (blockposMutable.func_177958_n() >> 4 != cachedChunk.func_76632_l().field_77276_a || blockposMutable.func_177952_p() >> 4 != cachedChunk.func_76632_l().field_77275_b) {
            cachedChunk = world.func_217349_x((BlockPos)blockposMutable);
        }
        while (blockposMutable.func_177956_o() > 1 && length < 5 && cachedChunk.func_180495_p((BlockPos)blockposMutable).func_196958_f()) {
            BlockState aboveState = cachedChunk.func_180495_p((BlockPos)blockposMutable.func_189536_c(Direction.UP));
            blockposMutable.func_189536_c(Direction.DOWN);
            if (aboveState.func_203425_a(Blocks.field_150395_bd)) {
                cachedChunk.func_177436_a((BlockPos)blockposMutable, aboveState, false);
                ++length;
            } else {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    BlockState currentVineBlockState = (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((Property)VineBlock.func_176267_a((Direction)direction), (Comparable)Boolean.TRUE);
                    if (!currentVineBlockState.func_196955_c((IWorldReader)world, (BlockPos)blockposMutable)) continue;
                    cachedChunk.func_177436_a((BlockPos)blockposMutable, currentVineBlockState, false);
                    ++length;
                    break;
                }
            }
            blockposMutable.func_189536_c(Direction.DOWN);
        }
    }
}

