/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.ultraamplifieddimension.world.features.configs.BambooConfig;
import java.util.Random;
import net.minecraft.block.BambooBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BambooLeaves;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class SafeBamboo
extends Feature<BambooConfig> {
    private static final BlockState BAMBOO_DEFAULT = (BlockState)((BlockState)((BlockState)Blocks.field_222405_kQ.func_176223_P().func_206870_a((Property)BambooBlock.field_220264_d, (Comparable)Integer.valueOf(1))).func_206870_a((Property)BambooBlock.field_220265_e, (Comparable)BambooLeaves.NONE)).func_206870_a((Property)BambooBlock.field_220266_f, (Comparable)Integer.valueOf(0));
    private static final BlockState BAMBOO_LEAVES_LARGE_TOP = (BlockState)((BlockState)BAMBOO_DEFAULT.func_206870_a((Property)BambooBlock.field_220265_e, (Comparable)BambooLeaves.LARGE)).func_206870_a((Property)BambooBlock.field_220266_f, (Comparable)Integer.valueOf(1));
    private static final BlockState BAMBOO_LEAVES_LARGE = (BlockState)BAMBOO_DEFAULT.func_206870_a((Property)BambooBlock.field_220265_e, (Comparable)BambooLeaves.LARGE);
    private static final BlockState BAMBOO_LEAVES_SMALL = (BlockState)BAMBOO_DEFAULT.func_206870_a((Property)BambooBlock.field_220265_e, (Comparable)BambooLeaves.SMALL);

    public SafeBamboo(Codec<BambooConfig> configFactory) {
        super(configFactory);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random rand, BlockPos position, BambooConfig bambooConfig) {
        int i = 0;
        int maxHeight = rand.nextInt(bambooConfig.maxHeight + 1 - bambooConfig.minHeight) + bambooConfig.minHeight;
        int podzolRange = rand.nextInt(bambooConfig.podzolMaxRadius + 1 - bambooConfig.podzolMinRadius) + bambooConfig.podzolMinRadius;
        BlockPos.Mutable blockposMutable = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        IChunk cachedChunk = world.func_217349_x(position);
        if (cachedChunk.func_180495_p((BlockPos)blockposMutable).func_196958_f()) {
            if (Blocks.field_222405_kQ.func_176223_P().func_196955_c((IWorldReader)world, (BlockPos)blockposMutable)) {
                for (int x = position.func_177958_n() - podzolRange; x <= position.func_177958_n() + podzolRange; ++x) {
                    for (int z = position.func_177952_p() - podzolRange; z <= position.func_177952_p() + podzolRange; ++z) {
                        for (int y = position.func_177956_o() - 2; y <= position.func_177956_o() + 2; ++y) {
                            int zDiff;
                            int xDiff = x - position.func_177958_n();
                            if (xDiff * xDiff + (zDiff = z - position.func_177952_p()) * zDiff > podzolRange * podzolRange) continue;
                            blockposMutable.func_181079_c(x, y, z);
                            if (!(rand.nextFloat() < 0.4f) || world.func_180495_p((BlockPos)blockposMutable).func_177230_c() != Blocks.field_196658_i) continue;
                            world.func_180501_a((BlockPos)blockposMutable, Blocks.field_196661_l.func_176223_P(), 3);
                        }
                    }
                }
                blockposMutable.func_189533_g((Vector3i)position);
                for (int height = 0; height < maxHeight && height <= chunkGenerator.func_230355_e_() && cachedChunk.func_180495_p((BlockPos)blockposMutable).func_196958_f(); ++height) {
                    cachedChunk.func_177436_a((BlockPos)blockposMutable, BAMBOO_DEFAULT, false);
                    blockposMutable.func_189534_c(Direction.UP, 1);
                }
                if (cachedChunk.func_180495_p((BlockPos)blockposMutable.func_189536_c(Direction.DOWN)).func_203425_a(Blocks.field_222405_kQ)) {
                    cachedChunk.func_177436_a((BlockPos)blockposMutable, BAMBOO_LEAVES_LARGE_TOP, false);
                }
                if (cachedChunk.func_180495_p((BlockPos)blockposMutable.func_189536_c(Direction.DOWN)).func_203425_a(Blocks.field_222405_kQ)) {
                    cachedChunk.func_177436_a((BlockPos)blockposMutable, BAMBOO_LEAVES_LARGE, false);
                }
                if (cachedChunk.func_180495_p((BlockPos)blockposMutable.func_189536_c(Direction.DOWN)).func_203425_a(Blocks.field_222405_kQ)) {
                    cachedChunk.func_177436_a((BlockPos)blockposMutable, BAMBOO_LEAVES_SMALL, false);
                }
            }
            ++i;
        }
        return i > 0;
    }
}

