/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.ultraamplifieddimension.modInit.UADFeatures;
import com.telepathicgrunt.ultraamplifieddimension.utils.BiomeSetsHelper;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class SnowIceLayerHandlerFeature
extends Feature<NoFeatureConfig> {
    public SnowIceLayerHandlerFeature(Codec<NoFeatureConfig> p_i51435_1_) {
        super(p_i51435_1_);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random random, BlockPos position, NoFeatureConfig config) {
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
        for (int xOffset = 0; xOffset < 16; ++xOffset) {
            for (int zOffset = 0; zOffset < 16; ++zOffset) {
                blockpos$Mutable.func_189533_g((Vector3i)position).func_196234_d(xOffset, 0, zOffset);
                Biome biome = world.func_226691_t_((BlockPos)blockpos$Mutable);
                if (BiomeSetsHelper.FROZEN_BIOMES.contains(biome)) {
                    ((Feature)UADFeatures.SNOW_ICE_ALL_LAYERS.get()).func_241855_a(world, generator, random, (BlockPos)blockpos$Mutable, (IFeatureConfig)config);
                    continue;
                }
                if (BiomeSetsHelper.COLD_OCEAN_BIOMES.contains(biome)) {
                    ((Feature)UADFeatures.SNOW_LAYER_WITHOUT_ICE.get()).func_241855_a(world, generator, random, (BlockPos)blockpos$Mutable, (IFeatureConfig)config);
                    continue;
                }
                ((Feature)UADFeatures.SNOW_ICE_TOP_LAYER.get()).func_241855_a(world, generator, random, (BlockPos)blockpos$Mutable, (IFeatureConfig)config);
            }
        }
        return true;
    }

    public static void placeSnowOnNearbyLeaves(ISeedReader world, Biome biome, BlockPos.Mutable blockposMutable1, IChunk cachedChunk) {
        BlockPos.Mutable nearbyPos = new BlockPos.Mutable();
        BlockPos.Mutable nearbyPosBelow = new BlockPos.Mutable();
        IChunk chunk = cachedChunk;
        int range = 5;
        for (int xOffset = -range; xOffset <= range; ++xOffset) {
            for (int zOffset = -range; zOffset <= range; ++zOffset) {
                nearbyPos.func_189533_g((Vector3i)blockposMutable1).func_196234_d(xOffset, 0, zOffset);
                nearbyPosBelow.func_189533_g((Vector3i)nearbyPos).func_189536_c(Direction.DOWN);
                if (nearbyPos.func_177958_n() >> 4 == cachedChunk.func_76632_l().field_77276_a && nearbyPos.func_177952_p() >> 4 == cachedChunk.func_76632_l().field_77275_b) continue;
                if (nearbyPos.func_177958_n() >> 4 != chunk.func_76632_l().field_77276_a || nearbyPos.func_177952_p() >> 4 != chunk.func_76632_l().field_77275_b) {
                    chunk = world.func_217349_x((BlockPos)nearbyPos);
                }
                BlockState nearbyBlockStateTop = chunk.func_180495_p((BlockPos)nearbyPos);
                BlockState nearbyBlockStateBottom = chunk.func_180495_p((BlockPos)nearbyPosBelow);
                if (!nearbyBlockStateTop.func_196958_f() && !nearbyBlockStateTop.func_203425_a(Blocks.field_150395_bd) || !SnowIceLayerHandlerFeature.doesSnowGenerate((IWorldReader)world, biome, (BlockPos)nearbyPos) || !nearbyBlockStateBottom.func_235714_a_((ITag)BlockTags.field_206952_E)) continue;
                chunk.func_177436_a((BlockPos)nearbyPos, Blocks.field_150433_aE.func_176223_P(), false);
                if (!nearbyBlockStateBottom.func_235901_b_((Property)SnowyDirtBlock.field_196382_a)) continue;
                chunk.func_177436_a((BlockPos)nearbyPosBelow, (BlockState)nearbyBlockStateBottom.func_206870_a((Property)SnowyDirtBlock.field_196382_a, (Comparable)Boolean.valueOf(true)), false);
            }
        }
    }

    public static boolean doesSnowGenerate(IWorldReader worldIn, Biome biome, BlockPos pos) {
        if (!(biome.func_225486_c(pos) >= 0.15f) && pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            return Blocks.field_150433_aE.func_176223_P().func_196955_c(worldIn, pos);
        }
        return false;
    }
}

