/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.features;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.common.IPlantable;

public class TreeGiantDarkOak
extends Feature<BaseTreeFeatureConfig> {
    private static final BlockState DARK_OAK_LOG = Blocks.field_196623_P.func_176223_P();
    private static final BlockState DARK_OAK_LEAVES = (BlockState)Blocks.field_196574_ab.func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1));

    public TreeGiantDarkOak(Codec<BaseTreeFeatureConfig> config) {
        super(config);
    }

    public final boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, BaseTreeFeatureConfig config) {
        HashSet set = Sets.newHashSet();
        HashSet set1 = Sets.newHashSet();
        HashSet set2 = Sets.newHashSet();
        MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_78887_a();
        boolean flag = this.place((IWorldGenerationReader)reader, generator, rand, pos, set, set1, mutableboundingbox, config);
        if (mutableboundingbox.field_78897_a <= mutableboundingbox.field_78893_d && flag && !set.isEmpty()) {
            if (!config.field_227370_o_.isEmpty()) {
                ArrayList list = Lists.newArrayList((Iterable)set);
                ArrayList list1 = Lists.newArrayList((Iterable)set1);
                list.sort(Comparator.comparingInt(Vector3i::func_177956_o));
                list1.sort(Comparator.comparingInt(Vector3i::func_177956_o));
                config.field_227370_o_.forEach(p_236405_6_ -> p_236405_6_.func_225576_a_(reader, rand, list, list1, set2, mutableboundingbox));
            }
            BitSetVoxelShapePart voxelshapepart = new BitSetVoxelShapePart(1, 1, 1);
            Template.func_222857_a((IWorld)reader, (int)3, (VoxelShapePart)voxelshapepart, (int)mutableboundingbox.field_78897_a, (int)mutableboundingbox.field_78895_b, (int)mutableboundingbox.field_78896_c);
            return true;
        }
        return false;
    }

    public boolean place(IWorldGenerationReader worldReader, ChunkGenerator chunkGenerator, Random rand, BlockPos position, Set<BlockPos> leafSet, Set<BlockPos> trunkSet, MutableBoundingBox boundingBox, BaseTreeFeatureConfig config) {
        IWorld world = (IWorld)worldReader;
        int height = 11 + rand.nextInt(3);
        if (!this.isSpaceAt((IWorldGenerationBaseReader)world, chunkGenerator, position, height + 4)) {
            return false;
        }
        BlockPos blockpos = position.func_177977_b();
        boolean isSoil = world.func_180495_p(blockpos).canSustainPlant((IBlockReader)world, blockpos, Direction.UP, (IPlantable)Blocks.field_196680_y);
        if (!isSoil) {
            return false;
        }
        if (!this.placeTreeOfHeight((IWorldGenerationBaseReader)world, position, height)) {
            return false;
        }
        for (int x = -1; x < 3; ++x) {
            for (int z = -1; z < 3; ++z) {
                if (x + z == -2 || x * z == -2 || x + z == 4) continue;
                this.func_230367_a_((IWorldWriter)world, blockpos.func_177965_g(x).func_177970_e(z), Blocks.field_150346_d.func_176223_P());
            }
        }
        this.createCrown(world, position.func_177958_n(), position.func_177952_p(), position.func_177956_o() + height, 0, rand, trunkSet, boundingBox, config);
        this.createWoodCrown(world, position.func_177958_n(), position.func_177952_p(), position.func_177956_o() + height, rand, trunkSet, boundingBox, config);
        int ymax = height + position.func_177956_o();
        if (position.func_177956_o() > 3) {
            position = position.func_177979_c(2);
        }
        this.placeColumnOfWood(world, ymax, rand, position, trunkSet, boundingBox, config);
        this.placeColumnOfWood(world, ymax, rand, position.func_177982_a(1, 0, 0), trunkSet, boundingBox, config);
        this.placeColumnOfWood(world, ymax, rand, position.func_177982_a(1, 0, 1), trunkSet, boundingBox, config);
        this.placeColumnOfWood(world, ymax, rand, position.func_177982_a(0, 0, 1), trunkSet, boundingBox, config);
        this.placeColumnOfWood(world, ymax, rand, position.func_177982_a(-1, 0, 0), trunkSet, boundingBox, config);
        this.placeColumnOfWood(world, ymax, rand, position.func_177982_a(0, 0, -1), trunkSet, boundingBox, config);
        this.placeColumnOfWood(world, ymax, rand, position.func_177982_a(-1, 0, 1), trunkSet, boundingBox, config);
        this.placeColumnOfWood(world, ymax, rand, position.func_177982_a(1, 0, -1), trunkSet, boundingBox, config);
        this.placeColumnOfWood(world, ymax, rand, position.func_177982_a(0, 0, 2), trunkSet, boundingBox, config);
        this.placeColumnOfWood(world, ymax, rand, position.func_177982_a(1, 0, 2), trunkSet, boundingBox, config);
        this.placeColumnOfWood(world, ymax, rand, position.func_177982_a(2, 0, 0), trunkSet, boundingBox, config);
        this.placeColumnOfWood(world, ymax, rand, position.func_177982_a(2, 0, 1), trunkSet, boundingBox, config);
        return true;
    }

    private void createCrown(IWorld world, int x, int z, int y, int extraRadius, Random rand, Set<BlockPos> p_214596_8_, MutableBoundingBox p_208519_5_, BaseTreeFeatureConfig p_227252_7_) {
        int i = 4;
        for (int k = y - i; k <= y + 3; ++k) {
            int l = y - k;
            int radius = extraRadius + MathHelper.func_76141_d((float)((float)l / (float)i * 1.5f));
            this.growLeavesLayerStrict(world, new BlockPos(x, k, z), radius + (int)((l > 0 && (k & 1) == 0 ? 0.9 : 1.0) * 5.5), p_214596_8_, p_208519_5_, p_227252_7_);
        }
        this.growLeavesLayerStrict(world, new BlockPos(x, y + 4, z), 1, p_214596_8_, p_208519_5_, p_227252_7_);
    }

    private void createWoodCrown(IWorld world, int x, int z, int y, Random rand, Set<BlockPos> p_214596_8_, MutableBoundingBox p_208519_5_, BaseTreeFeatureConfig p_227252_7_) {
        int i = 2;
        for (int k = y - (i + 4); k <= y - 1; ++k) {
            int l = y - k;
            int radius = l < 3 ? 4 : (l < 5 ? 3 : 2);
            this.growWoodLayerStrict(world, new BlockPos(x, k, z), radius, p_214596_8_, p_208519_5_, p_227252_7_);
        }
    }

    private void createMiniCrown(IWorld world, int x, int z, int y, int extraRadius, Random rand, Set<BlockPos> p_214596_8_, MutableBoundingBox p_208519_5_, BaseTreeFeatureConfig p_227252_7_) {
        int i = rand.nextInt(2) + 1;
        for (int k = y - i; k <= y + 1; ++k) {
            int l = y - k;
            int radius = extraRadius + MathHelper.func_76141_d((float)((float)l / (float)i * 1.5f));
            this.growLeavesLayerStrict(world, new BlockPos(x, k, z), radius + (int)((l > 0 && (k & 1) == 0 ? 0.9 : 1.0) * 2.0), p_214596_8_, p_208519_5_, p_227252_7_);
        }
    }

    protected void growLeavesLayerStrict(IWorld world, BlockPos layerCenter, int width, Set<BlockPos> p_214596_8_, MutableBoundingBox p_208519_5_, BaseTreeFeatureConfig p_227252_7_) {
        int i = width * width;
        for (int j = -width; j <= width + 1; ++j) {
            for (int k = -width; k <= width + 1; ++k) {
                BlockPos blockpos;
                BlockState state;
                int l = j - 1;
                int i1 = k - 1;
                if (j * j + k * k > i && l * l + i1 * i1 > i && j * j + i1 * i1 > i && l * l + k * k > i || !(state = world.func_180495_p(blockpos = layerCenter.func_177982_a(j, 0, k))).func_196958_f() && state.func_185904_a() != Material.field_151584_j) continue;
                this.func_230367_a_((IWorldWriter)world, blockpos, DARK_OAK_LEAVES);
            }
        }
    }

    protected void growWoodLayerStrict(IWorld world, BlockPos layerCenter, int width, Set<BlockPos> p_214596_8_, MutableBoundingBox p_208519_5_, BaseTreeFeatureConfig p_227252_7_) {
        int i = width * width;
        for (int j = -width; j <= width + 1; ++j) {
            for (int k = -width; k <= width + 1; ++k) {
                BlockPos blockpos;
                BlockState state;
                int l = j - 1;
                int i1 = k - 1;
                if (j * j + k * k > i && l * l + i1 * i1 > i && j * j + i1 * i1 > i && l * l + k * k > i || !(state = world.func_180495_p(blockpos = layerCenter.func_177982_a(j, 0, k))).func_196958_f() && state.func_185904_a() != Material.field_151584_j) continue;
                this.func_230367_a_((IWorldWriter)world, blockpos, DARK_OAK_LOG);
            }
        }
    }

    private void placeColumnOfWood(IWorld world, int yMax, Random rand, BlockPos tempPos, Set<BlockPos> p_214596_8_, MutableBoundingBox p_208519_5_, BaseTreeFeatureConfig p_227252_7_) {
        while (tempPos.func_177956_o() < yMax) {
            BlockState iblockstate = world.func_180495_p(tempPos = tempPos.func_177984_a());
            if (iblockstate.func_185904_a() != Material.field_151579_a && iblockstate.func_185904_a() != Material.field_151584_j) continue;
            if (rand.nextInt(70) == 0) {
                this.createMiniCrown(world, tempPos.func_177958_n(), tempPos.func_177952_p(), tempPos.func_177956_o(), 0, rand, p_214596_8_, p_208519_5_, p_227252_7_);
                continue;
            }
            this.func_230367_a_((IWorldWriter)world, tempPos, DARK_OAK_LOG);
        }
    }

    private boolean placeTreeOfHeight(IWorldGenerationBaseReader world, BlockPos pos, int height) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
        for (int l = 0; l <= height + 1; ++l) {
            int i1 = 1;
            if (l == 0) {
                i1 = 0;
            }
            if (l >= height - 1) {
                i1 = 2;
            }
            for (int j1 = -i1; j1 <= i1; ++j1) {
                for (int k1 = -i1; k1 <= i1; ++k1) {
                    if (!TreeGiantDarkOak.cannotBeReplacedByLogs(world, (BlockPos)blockpos$Mutable.func_181079_c(i + j1, j + l, k + k1))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isSpaceAt(IWorldGenerationBaseReader world, ChunkGenerator chunkGenerator, BlockPos leavesPos, int height) {
        boolean flag = true;
        if (leavesPos.func_177956_o() >= 1 && leavesPos.func_177956_o() + height + 1 <= chunkGenerator.func_230355_e_()) {
            for (int i = 0; i <= 1 + height; ++i) {
                int j = 2;
                if (i == 0) {
                    j = 1;
                } else if (i >= 1 + height - 2) {
                    j = 2;
                }
                for (int k = -j; k <= j && flag; ++k) {
                    for (int l = -j; l <= j && flag; ++l) {
                        if (leavesPos.func_177956_o() + i >= 0 && leavesPos.func_177956_o() + i < chunkGenerator.func_230355_e_() && !TreeGiantDarkOak.cannotBeReplacedByLogs(world, leavesPos.func_177982_a(k, i, l))) continue;
                        flag = false;
                    }
                }
            }
            return flag;
        }
        return false;
    }

    protected static boolean cannotBeReplacedByLogs(IWorldGenerationBaseReader reader, BlockPos pos) {
        if (reader instanceof IWorldReader) {
            return !reader.func_217375_a(pos, state -> state.canBeReplacedByLogs((IWorldReader)reader, pos));
        }
        return !reader.func_217375_a(pos, blockState -> {
            Block block = blockState.func_177230_c();
            return blockState.func_196958_f() || blockState.func_235714_a_((ITag)BlockTags.field_206952_E) || TreeGiantDarkOak.func_227250_b_((Block)block) || block.func_203417_a((ITag)BlockTags.field_200031_h) || block.func_203417_a((ITag)BlockTags.field_200030_g) || block == Blocks.field_150395_bd;
        });
    }
}

