/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.features;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.template.Template;

public class TreeSwampHorned
extends Feature<BaseTreeFeatureConfig> {
    public TreeSwampHorned(Codec<BaseTreeFeatureConfig> config) {
        super(config);
    }

    public boolean generate(ISeedReader serverWorldAccess, ChunkGenerator chunkGenerator, Random random, BlockPos blockPos, BaseTreeFeatureConfig config) {
        HashSet set = Sets.newHashSet();
        HashSet set2 = Sets.newHashSet();
        HashSet set3 = Sets.newHashSet();
        MutableBoundingBox blockBox = MutableBoundingBox.func_78887_a();
        boolean bl = this.generate(serverWorldAccess, chunkGenerator, random, blockPos, set, set2, config);
        if (blockBox.field_78897_a <= blockBox.field_78893_d && bl && !set.isEmpty()) {
            if (!config.field_227370_o_.isEmpty()) {
                ArrayList list = Lists.newArrayList((Iterable)set);
                ArrayList list2 = Lists.newArrayList((Iterable)set2);
                list.sort(Comparator.comparingInt(Vector3i::func_177956_o));
                list2.sort(Comparator.comparingInt(Vector3i::func_177956_o));
                config.field_227370_o_.forEach(decorator -> decorator.func_225576_a_(serverWorldAccess, random, list, list2, set3, blockBox));
            }
            VoxelShapePart voxelSet = this.placeLogsAndLeaves((IWorld)serverWorldAccess, blockBox, set, set3);
            Template.func_222857_a((IWorld)serverWorldAccess, (int)3, (VoxelShapePart)voxelSet, (int)blockBox.field_78897_a, (int)blockBox.field_78895_b, (int)blockBox.field_78896_c);
            return true;
        }
        return false;
    }

    private boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos position, Set<BlockPos> logPositions, Set<BlockPos> leavesPositions, BaseTreeFeatureConfig config) {
        int height = config.field_236678_g_.func_236917_a_(random);
        BlockState currentPos = world.func_180495_p(position);
        BlockState belowPos = world.func_180495_p(position.func_177977_b());
        if (!this.isSpaceAt(world, chunkGenerator, position, height)) {
            return false;
        }
        if (world.func_180495_p(position.func_177977_b()).func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a)) {
            position = position.func_177977_b();
        }
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= chunkGenerator.func_230355_e_()) {
            int x;
            for (int y = position.func_177956_o(); y <= position.func_177956_o() + 1 + height; ++y) {
                int radius = 1;
                if (y == position.func_177956_o()) {
                    radius = 0;
                }
                if (y >= position.func_177956_o() + 1 + height - 2) {
                    radius = 3;
                }
                BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
                for (x = position.func_177958_n() - radius; x <= position.func_177958_n() + radius && flag; ++x) {
                    for (int z = position.func_177952_p() - radius; z <= position.func_177952_p() + radius && flag; ++z) {
                        if (y >= 0 && y < chunkGenerator.func_230355_e_()) {
                            blockpos$Mutable.func_181079_c(x, y, z);
                            if (TreeSwampHorned.isAirOrLeaves((IWorldGenerationBaseReader)world, (BlockPos)blockpos$Mutable) || y <= position.func_177956_o() || TreeSwampHorned.isWater((IWorldGenerationBaseReader)world, (BlockPos)blockpos$Mutable)) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (TreeSwampHorned.isDirtOrGrass((IWorldGenerationBaseReader)world, position.func_177977_b()) && position.func_177956_o() < chunkGenerator.func_230355_e_() - height - 1) {
                for (int currentHeight = position.func_177956_o() - 4 + height; currentHeight <= position.func_177956_o() + height; ++currentHeight) {
                    int heightDiff = currentHeight - (position.func_177956_o() + height);
                    int leavesWidth = 2 - heightDiff / 2;
                    for (x = position.func_177958_n() - leavesWidth - 1; x <= position.func_177958_n() + leavesWidth; ++x) {
                        int xPos = x - position.func_177958_n();
                        for (int z = position.func_177952_p() - leavesWidth - 1; z <= position.func_177952_p() + leavesWidth; ++z) {
                            BlockPos blockpos;
                            int zPos = z - position.func_177952_p();
                            int isCornerIfThisIsTwo = 0;
                            if (xPos == leavesWidth) {
                                ++isCornerIfThisIsTwo;
                            }
                            if (zPos == leavesWidth) {
                                ++isCornerIfThisIsTwo;
                            }
                            if (xPos == -leavesWidth - 1) {
                                ++isCornerIfThisIsTwo;
                            }
                            if (zPos == -leavesWidth - 1) {
                                ++isCornerIfThisIsTwo;
                            }
                            if (isCornerIfThisIsTwo != 2 && (random.nextInt(3) >= 2 || heightDiff == 0) || !TreeSwampHorned.isAirOrLeaves((IWorldGenerationBaseReader)world, blockpos = new BlockPos(x, currentHeight, z)) && !TreeSwampHorned.isReplaceablePlant((IWorldGenerationBaseReader)world, blockpos)) continue;
                            this.func_230367_a_((IWorldWriter)world, blockpos, config.field_227369_n_.func_225574_a_(random, blockpos));
                            leavesPositions.add(blockpos);
                        }
                    }
                }
                this.genTrunk(world, position, height, random, logPositions, leavesPositions, config);
                this.genTrunk(world, position.func_177976_e(), height, random, logPositions, leavesPositions, config);
                this.genTrunk(world, position.func_177978_c(), height, random, logPositions, leavesPositions, config);
                this.genTrunk(world, position.func_177976_e().func_177978_c(), height, random, logPositions, leavesPositions, config);
                return true;
            }
            return false;
        }
        return false;
    }

    private void genTrunk(ISeedReader world, BlockPos position, int height, Random rand, Set<BlockPos> logPositions, Set<BlockPos> leavesPositions, BaseTreeFeatureConfig config) {
        this.func_230367_a_((IWorldWriter)world, position.func_177977_b(), Blocks.field_150346_d.func_176223_P());
        BlockPos.Mutable mutable = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        for (int currentHeight = 0; currentHeight < height; ++currentHeight) {
            BlockState iblockstate1 = world.func_180495_p((BlockPos)mutable);
            if (!iblockstate1.func_200132_m()) {
                if (currentHeight != height - 1) {
                    this.func_230367_a_((IWorldWriter)world, (BlockPos)mutable, config.field_227368_m_.func_225574_a_(rand, (BlockPos)mutable));
                    logPositions.add((BlockPos)mutable);
                } else if (currentHeight == height - 1) {
                    this.func_230367_a_((IWorldWriter)world, (BlockPos)mutable, config.field_227369_n_.func_225574_a_(rand, (BlockPos)mutable));
                    leavesPositions.add((BlockPos)mutable);
                }
            }
            mutable.func_189536_c(Direction.UP);
        }
    }

    private boolean isSpaceAt(ISeedReader world, ChunkGenerator chunkGenerator, BlockPos leavesPos, int height) {
        boolean spaceFound = true;
        if (leavesPos.func_177956_o() >= 1 && leavesPos.func_177956_o() + height + 1 <= chunkGenerator.func_230355_e_()) {
            for (int y = 0; y <= 1 + height; ++y) {
                int radius = 2;
                if (y == 0) {
                    radius = 1;
                }
                for (int x = -radius; x <= radius && spaceFound; ++x) {
                    for (int z = -radius; z <= radius && spaceFound; ++z) {
                        if (leavesPos.func_177956_o() + y >= 0 && leavesPos.func_177956_o() + y < chunkGenerator.func_230355_e_() && TreeSwampHorned.canTreeReplace((IWorldGenerationBaseReader)world, leavesPos.func_177982_a(x, y, z))) continue;
                        spaceFound = false;
                    }
                }
            }
            return spaceFound;
        }
        return false;
    }

    public static boolean canTreeReplace(IWorldGenerationBaseReader world, BlockPos pos) {
        return TreeSwampHorned.canReplace(world, pos) || world.func_217375_a(pos, state -> state.func_235714_a_((ITag)BlockTags.field_200031_h));
    }

    private static boolean isWater(IWorldGenerationBaseReader world, BlockPos pos) {
        return world.func_217375_a(pos, state -> state.func_203425_a(Blocks.field_150355_j));
    }

    public static boolean isAirOrLeaves(IWorldGenerationBaseReader world, BlockPos pos) {
        return world.func_217375_a(pos, state -> state.func_196958_f() || state.func_235714_a_((ITag)BlockTags.field_206952_E));
    }

    private static boolean isDirtOrGrass(IWorldGenerationBaseReader world, BlockPos pos) {
        return world.func_217375_a(pos, state -> TreeSwampHorned.func_227250_b_((Block)state.func_177230_c()) || state.func_203425_a(Blocks.field_150458_ak));
    }

    private static boolean isReplaceablePlant(IWorldGenerationBaseReader world, BlockPos pos) {
        return world.func_217375_a(pos, state -> {
            Material material = state.func_185904_a();
            return material == Material.field_151582_l;
        });
    }

    public static void setBlockStateWithoutUpdatingNeighbors(IWorldWriter world, BlockPos pos, BlockState state) {
        world.func_180501_a(pos, state, 19);
    }

    public static boolean canReplace(IWorldGenerationBaseReader IWorldGenerationBaseReader2, BlockPos pos) {
        return TreeSwampHorned.isAirOrLeaves(IWorldGenerationBaseReader2, pos) || TreeSwampHorned.isReplaceablePlant(IWorldGenerationBaseReader2, pos) || TreeSwampHorned.isWater(IWorldGenerationBaseReader2, pos);
    }

    private VoxelShapePart placeLogsAndLeaves(IWorld world, MutableBoundingBox box, Set<BlockPos> logs, Set<BlockPos> leaves) {
        ArrayList list = Lists.newArrayList();
        BitSetVoxelShapePart voxelSet = new BitSetVoxelShapePart(box.func_78883_b(), box.func_78882_c(), box.func_78880_d());
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (BlockPos blockPos2 : Lists.newArrayList(leaves)) {
            if (!box.func_175898_b((Vector3i)blockPos2)) continue;
            voxelSet.func_199625_a(blockPos2.func_177958_n() - box.field_78897_a, blockPos2.func_177956_o() - box.field_78895_b, blockPos2.func_177952_p() - box.field_78896_c, true, true);
        }
        for (BlockPos blockPos2 : Lists.newArrayList(logs)) {
            Direction[] var11;
            if (box.func_175898_b((Vector3i)blockPos2)) {
                voxelSet.func_199625_a(blockPos2.func_177958_n() - box.field_78897_a, blockPos2.func_177956_o() - box.field_78895_b, blockPos2.func_177952_p() - box.field_78896_c, true, true);
            }
            for (Direction direction : var11 = Direction.values()) {
                BlockState blockState;
                mutable.func_239622_a_((Vector3i)blockPos2, direction);
                if (logs.contains(mutable) || !(blockState = world.func_180495_p((BlockPos)mutable)).func_235901_b_((Property)BlockStateProperties.field_208514_aa)) continue;
                ((Set)list.get(0)).add(mutable.func_185334_h());
                TreeSwampHorned.setBlockStateWithoutUpdatingNeighbors((IWorldWriter)world, (BlockPos)mutable, (BlockState)blockState.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(1)));
                if (!box.func_175898_b((Vector3i)mutable)) continue;
                voxelSet.func_199625_a(mutable.func_177958_n() - box.field_78897_a, mutable.func_177956_o() - box.field_78895_b, mutable.func_177952_p() - box.field_78896_c, true, true);
            }
        }
        for (int k = 1; k < 6; ++k) {
            Set set = (Set)list.get(k - 1);
            Set set2 = (Set)list.get(k);
            for (BlockPos blockPos3 : set) {
                Direction[] var27;
                if (box.func_175898_b((Vector3i)blockPos3)) {
                    voxelSet.func_199625_a(blockPos3.func_177958_n() - box.field_78897_a, blockPos3.func_177956_o() - box.field_78895_b, blockPos3.func_177952_p() - box.field_78896_c, true, true);
                }
                for (Direction direction2 : var27 = Direction.values()) {
                    int l;
                    BlockState blockState2;
                    mutable.func_239622_a_((Vector3i)blockPos3, direction2);
                    if (set.contains(mutable) || set2.contains(mutable) || !(blockState2 = world.func_180495_p((BlockPos)mutable)).func_235901_b_((Property)BlockStateProperties.field_208514_aa) || (l = ((Integer)blockState2.func_177229_b((Property)BlockStateProperties.field_208514_aa)).intValue()) <= k + 1) continue;
                    BlockState blockState3 = (BlockState)blockState2.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(k + 1));
                    TreeSwampHorned.setBlockStateWithoutUpdatingNeighbors((IWorldWriter)world, (BlockPos)mutable, blockState3);
                    if (box.func_175898_b((Vector3i)mutable)) {
                        voxelSet.func_199625_a(mutable.func_177958_n() - box.field_78897_a, mutable.func_177956_o() - box.field_78895_b, mutable.func_177952_p() - box.field_78896_c, true, true);
                    }
                    set2.add(mutable.func_185334_h());
                }
            }
        }
        return voxelSet;
    }
}

