/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.ultraamplifieddimension.UltraAmplifiedDimension;
import com.telepathicgrunt.ultraamplifieddimension.modInit.UADProcessors;
import com.telepathicgrunt.ultraamplifieddimension.utils.GeneralUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.SpawnerBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

public class SpawnerRandomizingProcessor
extends StructureProcessor {
    public static final Codec<SpawnerRandomizingProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.mapPair((MapCodec)Registry.field_212629_r.fieldOf("resourcelocation"), (MapCodec)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("weight")).codec().listOf().fieldOf("spawner_mob_entries").forGetter(spawnerRandomizingProcessor -> spawnerRandomizingProcessor.spawnerRandomizingProcessor)).apply((Applicative)instance, instance.stable(SpawnerRandomizingProcessor::new)));
    public final List<Pair<EntityType<?>, Integer>> spawnerRandomizingProcessor;

    private SpawnerRandomizingProcessor(List<Pair<EntityType<?>, Integer>> spawnerRandomizingProcessor) {
        this.spawnerRandomizingProcessor = spawnerRandomizingProcessor;
    }

    public Template.BlockInfo func_230386_a_(IWorldReader worldView, BlockPos pos, BlockPos blockPos, Template.BlockInfo structureBlockInfoLocal, Template.BlockInfo structureBlockInfoWorld, PlacementSettings structurePlacementData) {
        if (structureBlockInfoWorld.field_186243_b.func_177230_c() instanceof SpawnerBlock) {
            BlockPos worldPos = structureBlockInfoWorld.field_186242_a;
            SharedSeedRandom random = new SharedSeedRandom();
            random.setSeed(worldPos.func_218275_a() * (long)worldPos.func_177956_o());
            return new Template.BlockInfo(worldPos, structureBlockInfoWorld.field_186243_b, this.SetMobSpawnerEntity((Random)random, structureBlockInfoWorld.field_186244_c));
        }
        return structureBlockInfoWorld;
    }

    private CompoundNBT SetMobSpawnerEntity(Random random, CompoundNBT nbt) {
        EntityType entity = (EntityType)GeneralUtils.getRandomEntry(this.spawnerRandomizingProcessor, random);
        if (entity != null) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74777_a("Delay", (short)20);
            compound.func_74777_a("MinSpawnDelay", (short)200);
            compound.func_74777_a("MaxSpawnDelay", (short)800);
            compound.func_74777_a("SpawnCount", (short)4);
            compound.func_74777_a("MaxNearbyEntities", (short)6);
            compound.func_74777_a("RequiredPlayerRange", (short)16);
            compound.func_74777_a("SpawnRange", (short)4);
            CompoundNBT spawnData = new CompoundNBT();
            spawnData.func_74778_a("id", Registry.field_212629_r.func_177774_c((Object)entity).toString());
            compound.func_218657_a("SpawnData", (INBT)spawnData);
            CompoundNBT entityData = new CompoundNBT();
            entityData.func_74778_a("id", Registry.field_212629_r.func_177774_c((Object)entity).toString());
            CompoundNBT listEntry = new CompoundNBT();
            listEntry.func_218657_a("Entity", (INBT)entityData);
            listEntry.func_74768_a("Weight", 1);
            ListNBT listnbt = new ListNBT();
            listnbt.add((Object)listEntry);
            compound.func_218657_a("SpawnPotentials", (INBT)listnbt);
            return compound;
        }
        UltraAmplifiedDimension.LOGGER.warn("EntityType in a dungeon does not exist in registry! : {}", this.spawnerRandomizingProcessor);
        return nbt;
    }

    protected IStructureProcessorType<?> func_215192_a() {
        return UADProcessors.SPAWNER_RANDOMIZING_PROCESSOR;
    }
}

