/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.structures;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.template.Template;

public class OceanStructurePiecesUtils {
    public static int getNewLedgeHeight(ISeedReader world, ChunkGenerator chunkGenerator, Random random, Template template, Rotation rotation, BlockPos templatePosition) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        int halfSizeX = template.func_186259_a().func_177958_n() / 2;
        int halfSizeZ = template.func_186259_a().func_177952_p() / 2;
        mutable.func_189533_g((Vector3i)Template.func_207669_a((BlockPos)new BlockPos(template.func_186259_a().func_177958_n() / 2 - 1, 0, template.func_186259_a().func_177952_p() / 2 - 1), (Mirror)Mirror.NONE, (Rotation)rotation, (BlockPos)new BlockPos(0, 0, 0)).func_177971_a((Vector3i)templatePosition));
        int highestHeight = world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, mutable.func_177958_n(), mutable.func_177952_p());
        int bottomOfSea = chunkGenerator.func_230356_f_() - 10;
        BlockState pastState = Blocks.field_150348_b.func_176223_P();
        int startHeight = Math.min(random.nextInt(random.nextInt(Math.max(highestHeight - bottomOfSea, 1)) + 1) + bottomOfSea + 5, 245);
        mutable.func_189534_c(Direction.UP, startHeight);
        while (mutable.func_177956_o() > Math.max(bottomOfSea - 20, 5)) {
            BlockState currentState = world.func_180495_p((BlockPos)mutable);
            if (currentState.func_200132_m() && !currentState.func_235714_a_((ITag)BlockTags.field_205213_E) && pastState.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a) && OceanStructurePiecesUtils.noAirAround(world, mutable.func_177977_b(), (int)((float)halfSizeX * 0.8f), (int)((float)halfSizeZ * 0.8f))) {
                return mutable.func_177956_o();
            }
            pastState = currentState;
            mutable.func_189536_c(Direction.DOWN);
        }
        return bottomOfSea;
    }

    public static boolean noAirAround(ISeedReader world, BlockPos blockpos, int xRange, int zRange) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int x = -xRange; x <= xRange; x += xRange) {
            for (int z = -zRange; z <= zRange; z += zRange) {
                BlockState state = world.func_180495_p((BlockPos)mutable.func_189533_g((Vector3i)blockpos).func_196234_d(x, 0, z));
                if (!state.func_196958_f()) continue;
                return false;
            }
        }
        return true;
    }
}

