/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.surfacebuilder;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class OceanSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    private static final BlockState[] DEAD_CORAL_ARRAY = new BlockState[]{Blocks.field_204408_jI.func_176223_P(), Blocks.field_204405_jF.func_176223_P(), Blocks.field_204406_jG.func_176223_P(), Blocks.field_204407_jH.func_176223_P(), Blocks.field_204404_jE.func_176223_P()};

    public OceanSurfaceBuilder(Codec<SurfaceBuilderConfig> codec) {
        super(codec);
    }

    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        this.buildSurface(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, config.func_204108_a(), config.func_204109_b(), config.func_204110_c(), seaLevel);
    }

    protected void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int xStart, int zStart, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, BlockState topBlock, BlockState middleBlock, BlockState bottomBlock, int seaLevel) {
        BlockState currentBlock;
        int y;
        int x = xStart & 0xF;
        int z = zStart & 0xF;
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
        BlockPos.Mutable blockpos$Mutable2 = new BlockPos.Mutable();
        BlockState aboveBlock = middleBlock;
        BlockState above2Block = middleBlock;
        BlockState above3Block = middleBlock;
        BlockState above4Block = middleBlock;
        boolean useCoral = bottomBlock == DEAD_CORAL_ARRAY[0];
        for (y = startHeight; y >= seaLevel - 10; --y) {
            BlockState bottom;
            blockpos$Mutable.func_181079_c(x, y, z);
            blockpos$Mutable2.func_189533_g((Vector3i)blockpos$Mutable);
            currentBlock = chunkIn.func_180495_p((BlockPos)blockpos$Mutable);
            if (currentBlock == defaultBlock) {
                bottom = defaultFluid;
                chunkIn.func_177436_a((BlockPos)blockpos$Mutable, bottom, false);
                currentBlock = bottom;
            } else if (!aboveBlock.func_204520_s().func_206888_e() && currentBlock.func_185904_a() == Material.field_151579_a) {
                if (above2Block.func_185904_a() == Material.field_151579_a) {
                    bottom = topBlock;
                    chunkIn.func_177436_a((BlockPos)blockpos$Mutable.func_189536_c(Direction.UP), bottom, false);
                    blockpos$Mutable.func_189536_c(Direction.DOWN);
                } else {
                    BlockState middle;
                    if (above3Block.func_185904_a() == Material.field_151579_a) {
                        bottom = Blocks.field_150350_a.func_176223_P();
                        middle = Blocks.field_150350_a.func_176223_P();
                    } else {
                        bottom = useCoral ? DEAD_CORAL_ARRAY[random.nextInt(DEAD_CORAL_ARRAY.length)] : bottomBlock;
                        middle = middleBlock;
                    }
                    chunkIn.func_177436_a((BlockPos)blockpos$Mutable.func_189536_c(Direction.UP), bottom, false);
                    currentBlock = bottom;
                    if (!above2Block.func_204520_s().func_206888_e()) {
                        chunkIn.func_177436_a((BlockPos)blockpos$Mutable.func_181079_c(x, y, z).func_189534_c(Direction.UP, 2), middle, false);
                    }
                    if (!above3Block.func_204520_s().func_206888_e()) {
                        chunkIn.func_177436_a((BlockPos)blockpos$Mutable.func_181079_c(x, y, z).func_189534_c(Direction.UP, 3), middle, false);
                    }
                    if (!above4Block.func_204520_s().func_206888_e()) {
                        chunkIn.func_177436_a((BlockPos)blockpos$Mutable.func_181079_c(x, y, z).func_189534_c(Direction.UP, 4), middle, false);
                    }
                }
            }
            above4Block = above3Block;
            above3Block = above2Block;
            above2Block = aboveBlock;
            aboveBlock = currentBlock;
        }
        if (BlockTags.field_203436_u.func_230235_a_((Object)middleBlock.func_177230_c()) || bottomBlock == Blocks.field_204408_jI.func_176223_P()) {
            blockpos$Mutable.func_181079_c(x, 71, z);
            above2Block = chunkIn.func_180495_p((BlockPos)blockpos$Mutable);
            aboveBlock = chunkIn.func_180495_p((BlockPos)blockpos$Mutable.func_189536_c(Direction.DOWN));
            for (y = 69; y >= 40; --y) {
                blockpos$Mutable.func_189536_c(Direction.DOWN);
                currentBlock = chunkIn.func_180495_p((BlockPos)blockpos$Mutable);
                if (currentBlock.func_200132_m() && aboveBlock.func_200132_m() && !above2Block.func_204520_s().func_206888_e() && (BlockTags.field_203436_u.func_230235_a_((Object)middleBlock.func_177230_c()) || random.nextFloat() < 0.8f)) {
                    chunkIn.func_177436_a((BlockPos)blockpos$Mutable.func_189536_c(Direction.UP), middleBlock, false);
                    blockpos$Mutable.func_189536_c(Direction.DOWN);
                    aboveBlock = middleBlock;
                }
                above2Block = aboveBlock;
                aboveBlock = currentBlock;
            }
        }
    }
}

