/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.surfacebuilder;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.ultraamplifieddimension.utils.OpenSimplexNoise;
import com.telepathicgrunt.ultraamplifieddimension.world.surfacebuilder.configs.QuadrarySurfaceBuilderConfig;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;

public class PlateauSurfaceBuilder
extends SurfaceBuilder<QuadrarySurfaceBuilderConfig> {
    protected long noiseSeed;
    protected OpenSimplexNoise noiseGen;

    public PlateauSurfaceBuilder(Codec<QuadrarySurfaceBuilderConfig> codec) {
        super(codec);
    }

    public void func_205548_a(long seed) {
        if (this.noiseSeed != seed || this.noiseGen == null) {
            this.noiseGen = new OpenSimplexNoise(seed);
        }
        this.noiseSeed = seed;
    }

    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, QuadrarySurfaceBuilderConfig config) {
        this.buildSurface(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, config.func_204108_a(), config.func_204109_b(), config.func_204110_c(), config.getExtraMaterial(), seaLevel);
    }

    protected void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, BlockState topBlock, BlockState middleBlock, BlockState bottomBlock, BlockState extraBlock, int seaLevel) {
        BlockState currentTopBlock = topBlock;
        BlockState currentMiddleBlock = middleBlock;
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
        int bottomLayerNoise = -1;
        int terrainThickness = 0;
        int currentDepth = 0;
        int noiseThing = (int)(noise / 3.0 + 3.0 + random.nextDouble() * 0.25);
        int xInChunk = x & 0xF;
        int zInChunk = z & 0xF;
        BlockState aboveBlock = Blocks.field_150350_a.func_176223_P();
        BlockState above2Block = Blocks.field_150350_a.func_176223_P();
        BlockState above3Block = Blocks.field_150350_a.func_176223_P();
        for (int y = startHeight - 1; y >= 0; --y) {
            blockpos$Mutable.func_181079_c(xInChunk, y, zInChunk);
            BlockState currentBlock = chunkIn.func_180495_p((BlockPos)blockpos$Mutable);
            if (currentBlock.func_177230_c() == defaultBlock.func_177230_c()) {
                if (bottomLayerNoise == -1) {
                    terrainThickness = 0;
                    currentDepth = 0;
                    if (noiseThing <= 0) {
                        currentTopBlock = Blocks.field_150350_a.func_176223_P();
                        currentMiddleBlock = defaultBlock;
                    } else if (y >= seaLevel - 4 && y <= seaLevel + 1) {
                        currentTopBlock = topBlock;
                        currentMiddleBlock = middleBlock;
                    }
                    if (y < seaLevel && currentTopBlock.func_185904_a() == Material.field_151579_a) {
                        currentTopBlock = biomeIn.func_225486_c((BlockPos)blockpos$Mutable.func_181079_c(x, y, z)) < 0.15f ? Blocks.field_150432_aD.func_176223_P() : defaultFluid;
                        blockpos$Mutable.func_181079_c(xInChunk, y, zInChunk);
                    }
                    bottomLayerNoise = noiseThing;
                    if (y >= seaLevel - 1) {
                        if (aboveBlock.func_196958_f()) {
                            chunkIn.func_177436_a((BlockPos)blockpos$Mutable, currentTopBlock, false);
                        } else {
                            chunkIn.func_177436_a((BlockPos)blockpos$Mutable, extraBlock, false);
                        }
                    } else if (y < seaLevel - 7 - noiseThing) {
                        currentTopBlock = Blocks.field_150350_a.func_176223_P();
                        currentMiddleBlock = defaultBlock;
                        chunkIn.func_177436_a((BlockPos)blockpos$Mutable, bottomBlock, false);
                    } else {
                        chunkIn.func_177436_a((BlockPos)blockpos$Mutable, currentMiddleBlock, false);
                    }
                } else if (bottomLayerNoise > 0) {
                    --bottomLayerNoise;
                    chunkIn.func_177436_a((BlockPos)blockpos$Mutable, currentMiddleBlock, false);
                }
                ++terrainThickness;
            } else if (!currentBlock.func_200132_m()) {
                if (currentBlock.func_196958_f()) {
                    bottomLayerNoise = -1;
                }
                double heightVariation = this.noiseGen.eval((double)x * 0.25, (double)y * 0.0075, (double)z * 0.25) * 14.0;
                if (!aboveBlock.func_196958_f() && !above2Block.func_196958_f() && !above3Block.func_196958_f() && (double)currentDepth < 5.0 * Math.pow(2.0, terrainThickness - 2) + heightVariation) {
                    boolean altBlock;
                    boolean bl = altBlock = this.noiseGen.eval((double)x * 0.065, (double)y * 0.25, (double)z * 0.065) > 0.3;
                    if (altBlock) {
                        chunkIn.func_177436_a((BlockPos)blockpos$Mutable, extraBlock, false);
                    } else {
                        chunkIn.func_177436_a((BlockPos)blockpos$Mutable, currentMiddleBlock, false);
                    }
                    currentBlock = Blocks.field_150348_b.func_176223_P();
                }
                ++currentDepth;
            }
            above3Block = above2Block;
            above2Block = aboveBlock;
            aboveBlock = currentBlock;
        }
    }
}

