/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.blockbehavior;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.blocks.BlocksInit;
import net.telepathicgrunt.ultraamplified.capabilities.IPlayerPosAndDim;
import net.telepathicgrunt.ultraamplified.capabilities.PlayerPositionAndDimension;
import net.telepathicgrunt.ultraamplified.world.dimension.UltraAmplifiedDimension;
import net.telepathicgrunt.ultraamplified.world.feature.AmplifiedPortalFrame;

@Mod.EventBusSubscriber(modid="ultra_amplified_dimension", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AmplifiedPortalBehavior {
    @CapabilityInject(value=IPlayerPosAndDim.class)
    public static Capability<IPlayerPosAndDim> PAST_POS_AND_DIM = null;

    @Mod.EventBusSubscriber(modid="ultra_amplified_dimension")
    private static class ForgeEvents {
        private static final BlockState POLISHED_GRANITE = Blocks.field_196652_d.func_176223_P();
        private static final BlockState POLISHED_DIORITE = Blocks.field_196655_f.func_176223_P();
        private static final BlockState POLISHED_ANDESITE_SLAB_TOP = (BlockState)Blocks.field_222457_lu.func_176223_P().func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
        private static final BlockState POLISHED_ANDESITE_SLAB_BOTTOM = (BlockState)Blocks.field_222457_lu.func_176223_P().func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM);

        private ForgeEvents() {
        }

        @SubscribeEvent
        public static void BlockRightClickEvent(PlayerInteractEvent.RightClickBlock event) {
            World worldIn = event.getWorld();
            Entity entityIn = event.getEntity();
            MinecraftServer minecraftserver = entityIn.func_184102_h();
            if (!(event.getWorld().func_180495_p(event.getPos()) != ((Block)BlocksInit.AMPLIFIEDPORTAL.get()).func_176223_P() || worldIn.field_72995_K || entityIn.func_184218_aH() || entityIn.func_184207_aI() || !entityIn.func_184222_aU() || ((PlayerEntity)entityIn).func_213453_ef())) {
                ChunkPos chunkpos;
                DimensionType destination;
                PlayerPositionAndDimension cap = (PlayerPositionAndDimension)entityIn.getCapability(PAST_POS_AND_DIM).orElseThrow(RuntimeException::new);
                boolean firstTime = false;
                if (cap.getDim() == null) {
                    destination = UltraAmplifiedDimension.ultraamplified();
                    firstTime = true;
                    if (!ForgeEvents.checkForGeneratedPortal((World)minecraftserver.func_71218_a(destination))) {
                        ForgeEvents.generatePortal((World)minecraftserver.func_71218_a(destination));
                    }
                } else {
                    destination = cap.getDim() == entityIn.field_71093_bK ? (cap.getDim() != UltraAmplifiedDimension.ultraamplified() ? UltraAmplifiedDimension.ultraamplified() : DimensionType.field_223227_a_) : cap.getDim();
                }
                ServerWorld serverworld = minecraftserver.func_71218_a(destination);
                BlockPos blockpos = new BlockPos(8, 0, 8);
                if (firstTime || cap.getDim() == entityIn.field_71093_bK) {
                    int portalY;
                    chunkpos = new ChunkPos(new BlockPos(10, 255, 8));
                    BlockPos pos = new BlockPos(8, 0, 8);
                    for (portalY = 255; portalY > 0 && serverworld.func_180495_p(pos.func_177981_b(portalY)) != ((Block)BlocksInit.AMPLIFIEDPORTAL.get()).func_176223_P(); --portalY) {
                    }
                    if (portalY == 0) {
                        blockpos = serverworld.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPos(10, 255, 8));
                    } else {
                        pos = pos.func_177981_b(portalY - 1);
                        boolean validSpaceFound = false;
                        for (int x = -2; x < 3; ++x) {
                            for (int z = -2; z < 3; ++z) {
                                if (x != -2 && x != 2 && z != -2 && z != 2 || serverworld.func_180495_p(pos.func_177982_a(x, 0, z)).func_185904_a() != Material.field_151579_a || serverworld.func_180495_p(pos.func_177982_a(x, 1, z)).func_185904_a() != Material.field_151579_a) continue;
                                blockpos = pos.func_177982_a(x, 0, z);
                                validSpaceFound = true;
                                z = 3;
                                x = 3;
                            }
                        }
                        if (!validSpaceFound) {
                            blockpos = serverworld.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPos(10, 255, 8));
                        }
                    }
                } else {
                    blockpos = cap.getPos();
                    chunkpos = new ChunkPos(blockpos);
                }
                serverworld.func_72863_F().func_217228_a(TicketType.field_223185_g, chunkpos, 1, (Object)entityIn.func_145782_y());
                if (((ServerPlayerEntity)entityIn).func_70608_bn()) {
                    ((ServerPlayerEntity)entityIn).func_213366_dy();
                }
                cap.setDim(entityIn.field_71093_bK);
                cap.setPos(entityIn.func_180425_c());
                ((ServerPlayerEntity)entityIn).func_200619_a(minecraftserver.func_71218_a(destination), (double)blockpos.func_177958_n() + 0.5, (double)(blockpos.func_177956_o() + 1), (double)blockpos.func_177952_p() + 0.5, entityIn.field_70177_z, entityIn.field_70125_A);
            }
            if (worldIn.func_175624_G() != UltraAmplified.UltraAmplified && event.getItemStack().func_77973_b() == Items.field_151033_d) {
                ForgeEvents.trySpawnPortal((IWorld)worldIn, event.getPos());
            }
        }

        private static boolean checkForGeneratedPortal(World worldIn) {
            BlockPos pos = new BlockPos(8, 255, 8);
            worldIn.func_175726_f(pos);
            while (pos.func_177956_o() >= 0) {
                if (worldIn.func_180495_p(pos) == ((Block)BlocksInit.AMPLIFIEDPORTAL.get()).func_176223_P()) {
                    return true;
                }
                pos = pos.func_177977_b();
            }
            return false;
        }

        private static void generatePortal(World worldIn) {
            AmplifiedPortalFrame amplifiedportalfeature = new AmplifiedPortalFrame();
            BlockPos pos = new BlockPos(8, 255, 8);
            worldIn.func_175726_f(pos);
            pos = worldIn.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, pos);
            if (pos.func_177956_o() > 252) {
                pos = pos.func_177979_c(3);
            } else if (pos.func_177956_o() < 6) {
                pos = new BlockPos(pos.func_177958_n(), 6, pos.func_177952_p());
            }
            amplifiedportalfeature.place((IWorld)worldIn, new Random(), pos, IFeatureConfig.field_202429_e);
        }

        public static boolean isValid(IWorld worldIn, BlockPos pos) {
            int z;
            int x;
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    if (!(Math.abs(x * z) == 1 ? worldIn.func_180495_p(pos.func_177982_a(x, -1, z)) != POLISHED_GRANITE : worldIn.func_180495_p(pos.func_177982_a(x, -1, z)) != POLISHED_ANDESITE_SLAB_BOTTOM)) continue;
                    return false;
                }
            }
            if (worldIn.func_180495_p(pos.func_177982_a(0, 0, 0)) != POLISHED_DIORITE) {
                return false;
            }
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    if (!(Math.abs(x * z) == 1 ? worldIn.func_180495_p(pos.func_177982_a(x, 1, z)) != POLISHED_GRANITE : worldIn.func_180495_p(pos.func_177982_a(x, 1, z)) != POLISHED_ANDESITE_SLAB_TOP)) continue;
                    return false;
                }
            }
            return true;
        }

        public static void placePortalBlocks(IWorld worldIn, BlockPos pos) {
            worldIn.func_180501_a(pos.func_177982_a(0, 0, 0), ((Block)BlocksInit.AMPLIFIEDPORTAL.get()).func_176223_P(), 18);
        }

        public static boolean trySpawnPortal(IWorld worldIn, BlockPos pos) {
            if (worldIn.func_201672_e().func_175624_G() == UltraAmplified.UltraAmplified) {
                return false;
            }
            boolean canMakePortal = ForgeEvents.isPortal(worldIn, pos);
            if (canMakePortal) {
                ForgeEvents.placePortalBlocks(worldIn, pos);
                return true;
            }
            return false;
        }

        @Nullable
        public static boolean isPortal(IWorld worldIn, BlockPos pos) {
            return ForgeEvents.isValid(worldIn, pos);
        }
    }
}

