/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.EndPortalTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.telepathicgrunt.ultraamplified.blocks.BlocksInit;
import net.telepathicgrunt.ultraamplified.world.dimension.UltraAmplifiedDimension;

public class AmplifiedPortalBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public AmplifiedPortalBlock() {
        super(Block.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)MaterialColor.field_151646_E).func_200951_a(15).func_200948_a(5.0f, 3600000.0f));
        this.setRegistryName("amplified_portal");
    }

    public TileEntity createNewTileEntity(IBlockReader worldIn) {
        return new EndPortalTileEntity();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, IFluidState fluid) {
        if (player != null && player.func_184812_l_()) {
            this.getBlock().func_176208_a(world, pos, state, player);
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            return true;
        }
        if (world.func_201675_m().func_186058_p() == UltraAmplifiedDimension.ultraamplified() && pos.func_177958_n() == 8 && pos.func_177952_p() == 8) {
            Block blockToCheck;
            BlockPos posOfHighestPortal = new BlockPos(pos.func_177958_n(), 255, pos.func_177952_p());
            while (posOfHighestPortal.func_177956_o() >= 0 && (blockToCheck = world.func_180495_p(posOfHighestPortal).func_177230_c()) != BlocksInit.AMPLIFIEDPORTAL.get()) {
                posOfHighestPortal = posOfHighestPortal.func_177977_b();
            }
            if (posOfHighestPortal.func_177956_o() == pos.func_177956_o()) {
                return false;
            }
        }
        this.getBlock().func_176208_a(world, pos, state, player);
        return world.func_217377_a(pos, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double d0 = (float)pos.func_177958_n() + (rand.nextFloat() * 3.0f - 1.0f);
        double d1 = (float)pos.func_177956_o() + (rand.nextFloat() * 3.0f - 1.0f);
        double d2 = (float)pos.func_177952_p() + (rand.nextFloat() * 3.0f - 1.0f);
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return ItemStack.field_190927_a;
    }
}

