/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.telepathicgrunt.ultraamplified.blocks.BlocksInit;

public class CactusBodyBlockUA
extends HorizontalBlock
implements IPlantable {
    public static final IntegerProperty AGE = BlockStateProperties.field_208171_X;
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    protected static final VoxelShape HITBOX_DIMENSIONS = Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)15.0, (double)16.0);
    protected static final VoxelShape OUTLINE_DIMENSION = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public CactusBodyBlockUA() {
        super(Block.Properties.func_200945_a((Material)Material.field_151570_A).func_200944_c().func_200943_b(0.4f).func_200947_a(SoundType.field_185854_g));
        this.setRegistryName("cactus_body_block_ua");
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    public void tick(BlockState state, World worldIn, BlockPos pos, Random random) {
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        } else {
            BlockPos blockpos = pos.func_177984_a();
            if (worldIn.func_175623_d(blockpos)) {
                int j = (Integer)state.func_177229_b((IProperty)AGE);
                if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)blockpos, (BlockState)state, (boolean)true)) {
                    if (j == 15) {
                        worldIn.func_175656_a(blockpos, ((Block)BlocksInit.CACTUSBODYBLOCKUA.get()).func_176223_P());
                        BlockState blockstate = (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0));
                        worldIn.func_180501_a(pos, blockstate, 4);
                        blockstate.func_215697_a(worldIn, blockpos, (Block)this, pos, false);
                    } else {
                        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(j + 1)), 4);
                    }
                    ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
                }
            }
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AGE});
        builder.func_206894_a(new IProperty[]{FACING});
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return HITBOX_DIMENSIONS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return OUTLINE_DIMENSION;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState blockstate = worldIn.func_180495_p(pos.func_177972_a(direction));
            Material material = blockstate.func_185904_a();
            if ((!material.func_76220_a() || material == Material.field_151570_A) && !worldIn.func_204610_c(pos.func_177972_a(direction)).func_206884_a(FluidTags.field_206960_b)) continue;
            return false;
        }
        return this.canCactusSurviveHere((IBlockReader)worldIn, pos, Direction.UP, this) && !worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76224_d();
    }

    public boolean canCactusSurviveHere(IBlockReader worldIn, BlockPos pos, Direction facing, IPlantable plantable) {
        BlockState belowBlock = worldIn.func_180495_p(pos.func_177977_b());
        return belowBlock.func_177230_c() == Blocks.field_150354_m || belowBlock.func_177230_c() == Blocks.field_196611_F || belowBlock.func_177230_c() != Blocks.field_150434_aF && belowBlock.func_185904_a() == Material.field_151570_A;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        entityIn.func_70097_a(DamageSource.field_76367_g, 1.0f);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return PlantType.Desert;
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        return this.func_176223_P();
    }
}

