/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.state.IProperty;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.lighting.LightEngine;
import net.telepathicgrunt.ultraamplified.blocks.BlocksInit;

public class GlowdirtBlock
extends Block {
    public GlowdirtBlock() {
        super(Block.Properties.func_200949_a((Material)Material.field_151578_c, (MaterialColor)MaterialColor.field_151664_l).func_200944_c().func_200943_b(0.4f).func_200947_a(SoundType.field_185849_b).func_200951_a(15));
        this.setRegistryName("glowdirt");
    }

    public static boolean validLightAndSpacing(BlockState blockStateIn, IWorldReader world, BlockPos blockPosIn) {
        BlockPos blockpos = blockPosIn.func_177984_a();
        BlockState blockstate = world.func_180495_p(blockpos);
        if (blockstate.func_177230_c() == Blocks.field_150433_aE && (Integer)blockstate.func_177229_b((IProperty)SnowBlock.field_176315_a) == 1) {
            return true;
        }
        if (blockstate.func_185904_a() != Material.field_151579_a) {
            return false;
        }
        int i = LightEngine.func_215613_a((IBlockReader)world, (BlockState)blockStateIn, (BlockPos)blockPosIn, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.func_200016_a((IBlockReader)world, blockpos));
        return i < world.func_201572_C();
    }

    public static boolean validNeighboringBlockSpace(BlockState blockStateIn, IWorldReader worldIn, BlockPos blockPosIn) {
        BlockPos blockpos = blockPosIn.func_177984_a();
        return GlowdirtBlock.validLightAndSpacing(blockStateIn, worldIn, blockPosIn) && !worldIn.func_204610_c(blockpos).func_206884_a(FluidTags.field_206959_a);
    }

    public void tick(BlockState state, World worldIn, BlockPos pos, Random random) {
        if (!worldIn.field_72995_K) {
            if (!worldIn.isAreaLoaded(pos, 3)) {
                return;
            }
            if (!GlowdirtBlock.validNeighboringBlockSpace(this.func_176223_P(), (IWorldReader)worldIn, pos)) {
                return;
            }
            if (worldIn.func_201696_r(pos.func_177984_a()) >= 4 && worldIn.func_201696_r(pos.func_177984_a()) >= 9) {
                BlockState replacementBlock = ((Block)BlocksInit.GLOWGRASS_BLOCK.get()).func_176223_P();
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = pos.func_177982_a(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                    Block neighborBlock = worldIn.func_180495_p(blockpos).func_177230_c();
                    if (neighborBlock == Blocks.field_196658_i || neighborBlock == BlocksInit.GLOWGRASS_BLOCK.get()) {
                        replacementBlock = ((Block)BlocksInit.GLOWGRASS_BLOCK.get()).func_176223_P();
                        worldIn.func_175656_a(pos, (BlockState)replacementBlock.func_206870_a((IProperty)SnowyDirtBlock.field_196382_a, (Comparable)Boolean.valueOf(worldIn.func_180495_p(blockpos.func_177984_a()).func_177230_c() == Blocks.field_150433_aE)));
                        continue;
                    }
                    if (neighborBlock != Blocks.field_150391_bh && neighborBlock != BlocksInit.GLOWMYCELIUM.get()) continue;
                    replacementBlock = ((Block)BlocksInit.GLOWMYCELIUM.get()).func_176223_P();
                    worldIn.func_175656_a(pos, (BlockState)replacementBlock.func_206870_a((IProperty)SnowyDirtBlock.field_196382_a, (Comparable)Boolean.valueOf(worldIn.func_180495_p(blockpos.func_177984_a()).func_177230_c() == Blocks.field_150433_aE)));
                }
            }
        }
    }
}

