/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber
public class ConfigUA {
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static boolean importModdedFeatures;
    public static boolean importModdedStructure;
    public static boolean importModdedMobs;
    public static boolean importModdedBiomes;
    public static boolean importAllModdedBiomes;
    public static String blacklistedBiomeList;
    public static String blacklistedStructureList;
    public static double xzTerrainModifier;
    public static double xzScaleModifier;
    public static double yTerrainModifier;
    public static double yScaleModifier;
    public static int yMaximum;
    public static int dungeonSpawnrate;
    public static int ravineSpawnrate;
    public static int caveCavitySpawnrate;
    public static int oceanCaveSpawnrate;
    public static boolean pillarGen;
    public static boolean honeyLakeGen;
    public static boolean slimeLakeGen;
    public static boolean waterLakeGen;
    public static boolean lavaLakeGen;
    public static boolean chestGeneration;
    public static int sunShrineSpawnrate;
    public static int stonehengeSpawnrate;
    public static int hangingRuinsSpawnrate;
    public static boolean miniStructureGeneration;
    public static int villageSpawnrate;
    public static int villageZombieSpawnrate;
    public static int mineshaftSpawnrate;
    public static boolean mineshaftAbovegroundAllowed;
    public static boolean mineshaftUndergroundAllowed;
    public static int mansionSpawnrate;
    public static int desertTempleSpawnrate;
    public static int jungleTempleSpawnrate;
    public static int iglooSpawnrate;
    public static int witchHutSpawnrate;
    public static int mushroomTempleSpawnrate;
    public static int iceSpikeTempleSpawnrate;
    public static int oceanMonumentSpawnrate;
    public static int oceanRuinsSpawnrate;
    public static int shipwreckSpawnrate;
    public static int strongholdSpawnrate;
    public static double silverfishStrongholdSpawnrate;
    public static int netherFortressSpawnrate;
    public static boolean netherFortressAboveground;
    public static boolean netherFortressUnderground;
    public static int endCitySpawnrate;
    public static int pillageOutpostRarity;
    public static boolean secretSetting;
    public static boolean heavyFog;
    public static int biomeSize;
    public static int mutatedBiomeSpawnrate;
    public static int seaLevel;
    public static boolean lavaOcean;
    public static int waterfallSpawnrate;
    public static int lavafallSpawnrate;
    public static int endIslandSpawnrate;
    public static boolean plains;
    public static boolean desert;
    public static boolean forest;
    public static boolean taiga;
    public static boolean rockyField;
    public static boolean swamplands;
    public static boolean nether;
    public static boolean end;
    public static boolean snowyTundra;
    public static boolean icedTerrain;
    public static boolean mushroom;
    public static boolean stonePlains;
    public static boolean bambooJungle;
    public static boolean jungle;
    public static boolean frozenDesert;
    public static boolean birchForest;
    public static boolean darkForest;
    public static boolean snowyTaiga;
    public static boolean giantTreeTaiga;
    public static boolean savanna;
    public static boolean badlands;
    public static boolean spikyBadlands;
    public static boolean iceSpike;
    public static boolean frozenOcean;
    public static boolean coldOcean;
    public static boolean ocean;
    public static boolean lukewarmOcean;
    public static boolean warmOcean;
    public static int coalOreSpawnrate;
    public static int ironOreSpawnrate;
    public static int redstoneOreSpawnrate;
    public static int lapisOreSpawnrate;
    public static int diamondOreSpawnrate;
    public static int goldOreSpawnrate;
    public static int emeraldOreSpawnrate;
    public static int silverfishSpawnrate;
    public static int quartzOreSpawnrate;
    public static int glowstoneSpawnrate;
    public static int magmaSpawnrate;
    public static int lavaSpawnrate;
    public static int glowstoneVariantsSpawnrate;
    public static boolean rootGen;

    public static void refreshServer() {
        importModdedFeatures = (Boolean)ConfigUA.SERVER.importModdedFeatures.get();
        importModdedStructure = (Boolean)ConfigUA.SERVER.importModdedStructure.get();
        importModdedMobs = (Boolean)ConfigUA.SERVER.importModdedMobs.get();
        importModdedBiomes = (Boolean)ConfigUA.SERVER.importModdedBiomes.get();
        importAllModdedBiomes = (Boolean)ConfigUA.SERVER.importAllModdedBiomes.get();
        blacklistedBiomeList = (String)ConfigUA.SERVER.blacklistedBiomeList.get();
        blacklistedStructureList = (String)ConfigUA.SERVER.blacklistedStructureList.get();
        xzTerrainModifier = (Double)ConfigUA.SERVER.xzTerrainModifier.get();
        xzScaleModifier = (Double)ConfigUA.SERVER.xzScaleModifier.get();
        yScaleModifier = (Double)ConfigUA.SERVER.yScaleModifier.get();
        yScaleModifier = (Double)ConfigUA.SERVER.yScaleModifier.get();
        yMaximum = (Integer)ConfigUA.SERVER.yMaximum.get();
        dungeonSpawnrate = (Integer)ConfigUA.SERVER.dungeonSpawnrate.get();
        ravineSpawnrate = (Integer)ConfigUA.SERVER.ravineSpawnrate.get();
        caveCavitySpawnrate = (Integer)ConfigUA.SERVER.caveCavitySpawnrate.get();
        oceanCaveSpawnrate = (Integer)ConfigUA.SERVER.oceanCaveSpawnrate.get();
        pillarGen = (Boolean)ConfigUA.SERVER.pillarGen.get();
        honeyLakeGen = (Boolean)ConfigUA.SERVER.honeyLakeGen.get();
        slimeLakeGen = (Boolean)ConfigUA.SERVER.slimeLakeGen.get();
        waterLakeGen = (Boolean)ConfigUA.SERVER.waterLakeGen.get();
        lavaLakeGen = (Boolean)ConfigUA.SERVER.lavaLakeGen.get();
        chestGeneration = (Boolean)ConfigUA.SERVER.chestGeneration.get();
        sunShrineSpawnrate = (Integer)ConfigUA.SERVER.sunShrineSpawnrate.get();
        stonehengeSpawnrate = (Integer)ConfigUA.SERVER.stonehengeSpawnrate.get();
        hangingRuinsSpawnrate = (Integer)ConfigUA.SERVER.hangingRuinsSpawnrate.get();
        miniStructureGeneration = (Boolean)ConfigUA.SERVER.miniStructureGeneration.get();
        villageSpawnrate = (Integer)ConfigUA.SERVER.villageSpawnrate.get();
        villageZombieSpawnrate = (Integer)ConfigUA.SERVER.villageZombieSpawnrate.get();
        mineshaftSpawnrate = (Integer)ConfigUA.SERVER.mineshaftSpawnrate.get();
        mineshaftAbovegroundAllowed = (Boolean)ConfigUA.SERVER.mineshaftAbovegroundAllowed.get();
        mineshaftUndergroundAllowed = (Boolean)ConfigUA.SERVER.mineshaftUndergroundAllowed.get();
        mansionSpawnrate = (Integer)ConfigUA.SERVER.mansionSpawnrate.get();
        desertTempleSpawnrate = (Integer)ConfigUA.SERVER.desertTempleSpawnrate.get();
        jungleTempleSpawnrate = (Integer)ConfigUA.SERVER.jungleTempleSpawnrate.get();
        iglooSpawnrate = (Integer)ConfigUA.SERVER.iglooSpawnrate.get();
        mushroomTempleSpawnrate = (Integer)ConfigUA.SERVER.mushroomTempleSpawnrate.get();
        iceSpikeTempleSpawnrate = (Integer)ConfigUA.SERVER.iceSpikeTempleSpawnrate.get();
        witchHutSpawnrate = (Integer)ConfigUA.SERVER.witchHutSpawnrate.get();
        oceanMonumentSpawnrate = (Integer)ConfigUA.SERVER.oceanMonumentSpawnrate.get();
        oceanRuinsSpawnrate = (Integer)ConfigUA.SERVER.oceanRuinsSpawnrate.get();
        shipwreckSpawnrate = (Integer)ConfigUA.SERVER.shipwreckSpawnrate.get();
        strongholdSpawnrate = (Integer)ConfigUA.SERVER.strongholdSpawnrate.get();
        silverfishStrongholdSpawnrate = (Double)ConfigUA.SERVER.silverfishStrongholdSpawnrate.get();
        netherFortressSpawnrate = (Integer)ConfigUA.SERVER.netherFortressSpawnrate.get();
        netherFortressAboveground = (Boolean)ConfigUA.SERVER.netherFortressAboveground.get();
        netherFortressUnderground = (Boolean)ConfigUA.SERVER.netherFortressUnderground.get();
        endCitySpawnrate = (Integer)ConfigUA.SERVER.endCitySpawnrate.get();
        pillageOutpostRarity = (Integer)ConfigUA.SERVER.pillageOutpostRarity.get();
        secretSetting = (Boolean)ConfigUA.SERVER.secretSetting.get();
        heavyFog = (Boolean)ConfigUA.SERVER.heavyFog.get();
        biomeSize = (Integer)ConfigUA.SERVER.biomeSize.get();
        mutatedBiomeSpawnrate = (Integer)ConfigUA.SERVER.mutatedBiomeSpawnrate.get();
        seaLevel = (Integer)ConfigUA.SERVER.seaLevel.get();
        lavaOcean = (Boolean)ConfigUA.SERVER.lavaOcean.get();
        waterfallSpawnrate = (Integer)ConfigUA.SERVER.waterfallSpawnrate.get();
        lavafallSpawnrate = (Integer)ConfigUA.SERVER.lavafallSpawnrate.get();
        endIslandSpawnrate = (Integer)ConfigUA.SERVER.endIslandSpawnrate.get();
        plains = (Boolean)ConfigUA.SERVER.plains.get();
        desert = (Boolean)ConfigUA.SERVER.desert.get();
        forest = (Boolean)ConfigUA.SERVER.forest.get();
        taiga = (Boolean)ConfigUA.SERVER.taiga.get();
        rockyField = (Boolean)ConfigUA.SERVER.rockyField.get();
        swamplands = (Boolean)ConfigUA.SERVER.swamplands.get();
        nether = (Boolean)ConfigUA.SERVER.nether.get();
        end = (Boolean)ConfigUA.SERVER.end.get();
        snowyTundra = (Boolean)ConfigUA.SERVER.snowyTundra.get();
        icedTerrain = (Boolean)ConfigUA.SERVER.icedTerrain.get();
        mushroom = (Boolean)ConfigUA.SERVER.mushroom.get();
        stonePlains = (Boolean)ConfigUA.SERVER.stonePlains.get();
        bambooJungle = (Boolean)ConfigUA.SERVER.bambooJungle.get();
        jungle = (Boolean)ConfigUA.SERVER.jungle.get();
        frozenDesert = (Boolean)ConfigUA.SERVER.frozenDesert.get();
        birchForest = (Boolean)ConfigUA.SERVER.birchForest.get();
        darkForest = (Boolean)ConfigUA.SERVER.darkForest.get();
        snowyTaiga = (Boolean)ConfigUA.SERVER.snowyTaiga.get();
        giantTreeTaiga = (Boolean)ConfigUA.SERVER.giantTreeTaiga.get();
        savanna = (Boolean)ConfigUA.SERVER.savanna.get();
        badlands = (Boolean)ConfigUA.SERVER.badlands.get();
        spikyBadlands = (Boolean)ConfigUA.SERVER.spikyBadlands.get();
        iceSpike = (Boolean)ConfigUA.SERVER.iceSpike.get();
        frozenOcean = (Boolean)ConfigUA.SERVER.frozenOcean.get();
        coldOcean = (Boolean)ConfigUA.SERVER.coldOcean.get();
        ocean = (Boolean)ConfigUA.SERVER.ocean.get();
        lukewarmOcean = (Boolean)ConfigUA.SERVER.lukewarmOcean.get();
        warmOcean = (Boolean)ConfigUA.SERVER.warmOcean.get();
        coalOreSpawnrate = (Integer)ConfigUA.SERVER.coalOreSpawnrate.get();
        ironOreSpawnrate = (Integer)ConfigUA.SERVER.ironOreSpawnrate.get();
        redstoneOreSpawnrate = (Integer)ConfigUA.SERVER.redstoneOreSpawnrate.get();
        lapisOreSpawnrate = (Integer)ConfigUA.SERVER.lapisOreSpawnrate.get();
        diamondOreSpawnrate = (Integer)ConfigUA.SERVER.diamondOreSpawnrate.get();
        goldOreSpawnrate = (Integer)ConfigUA.SERVER.goldOreSpawnrate.get();
        emeraldOreSpawnrate = (Integer)ConfigUA.SERVER.emeraldOreSpawnrate.get();
        silverfishSpawnrate = (Integer)ConfigUA.SERVER.silverfishSpawnrate.get();
        quartzOreSpawnrate = (Integer)ConfigUA.SERVER.quartzOreSpawnrate.get();
        glowstoneSpawnrate = (Integer)ConfigUA.SERVER.glowstoneSpawnrate.get();
        magmaSpawnrate = (Integer)ConfigUA.SERVER.magmaSpawnrate.get();
        lavaSpawnrate = (Integer)ConfigUA.SERVER.lavaSpawnrate.get();
        glowstoneVariantsSpawnrate = (Integer)ConfigUA.SERVER.glowstoneVariantsSpawnrate.get();
        rootGen = (Boolean)ConfigUA.SERVER.rootGen.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
        importModdedFeatures = false;
        importModdedStructure = false;
        importModdedMobs = false;
        importModdedBiomes = false;
        importAllModdedBiomes = false;
        blacklistedBiomeList = "";
        blacklistedStructureList = "";
        xzTerrainModifier = 684.412;
        xzScaleModifier = 8.55515f;
        yTerrainModifier = 68419.786;
        yScaleModifier = 428.613;
        yMaximum = 245;
        dungeonSpawnrate = 30;
        ravineSpawnrate = 25;
        caveCavitySpawnrate = 5;
        oceanCaveSpawnrate = 20;
        pillarGen = true;
        honeyLakeGen = true;
        slimeLakeGen = true;
        waterLakeGen = true;
        lavaLakeGen = true;
        chestGeneration = true;
        sunShrineSpawnrate = 50;
        stonehengeSpawnrate = 10;
        hangingRuinsSpawnrate = 40;
        miniStructureGeneration = true;
        villageSpawnrate = 16;
        villageZombieSpawnrate = 10;
        mineshaftSpawnrate = 22;
        mineshaftAbovegroundAllowed = true;
        mineshaftUndergroundAllowed = true;
        mansionSpawnrate = 18;
        desertTempleSpawnrate = 20;
        jungleTempleSpawnrate = 20;
        iglooSpawnrate = 14;
        witchHutSpawnrate = 14;
        mushroomTempleSpawnrate = 12;
        iceSpikeTempleSpawnrate = 20;
        oceanMonumentSpawnrate = 22;
        oceanRuinsSpawnrate = 7;
        shipwreckSpawnrate = 7;
        strongholdSpawnrate = 62;
        silverfishStrongholdSpawnrate = 4.0;
        netherFortressSpawnrate = 14;
        netherFortressAboveground = true;
        netherFortressUnderground = true;
        endCitySpawnrate = 18;
        pillageOutpostRarity = 20;
        secretSetting = false;
        heavyFog = false;
        biomeSize = 3;
        mutatedBiomeSpawnrate = 2;
        seaLevel = 75;
        lavaOcean = false;
        waterfallSpawnrate = 35;
        lavafallSpawnrate = 14;
        endIslandSpawnrate = 6;
        plains = true;
        desert = true;
        forest = true;
        taiga = true;
        rockyField = true;
        swamplands = true;
        nether = true;
        end = true;
        snowyTundra = true;
        icedTerrain = true;
        mushroom = true;
        stonePlains = true;
        bambooJungle = true;
        jungle = true;
        frozenDesert = true;
        birchForest = true;
        darkForest = true;
        snowyTaiga = true;
        giantTreeTaiga = true;
        savanna = true;
        badlands = true;
        spikyBadlands = true;
        iceSpike = true;
        frozenOcean = true;
        coldOcean = true;
        ocean = true;
        lukewarmOcean = true;
        warmOcean = true;
        coalOreSpawnrate = 35;
        ironOreSpawnrate = 50;
        redstoneOreSpawnrate = 12;
        lapisOreSpawnrate = 2;
        diamondOreSpawnrate = 1;
        goldOreSpawnrate = 2;
        emeraldOreSpawnrate = 100;
        silverfishSpawnrate = 18;
        quartzOreSpawnrate = 14;
        glowstoneSpawnrate = 20;
        magmaSpawnrate = 5;
        lavaSpawnrate = 70;
        glowstoneVariantsSpawnrate = 50;
        rootGen = true;
    }

    public static class ServerConfig {
        public final ForgeConfigSpec.BooleanValue importModdedFeatures;
        public final ForgeConfigSpec.BooleanValue importModdedStructure;
        public final ForgeConfigSpec.BooleanValue importModdedMobs;
        public final ForgeConfigSpec.BooleanValue importModdedBiomes;
        public final ForgeConfigSpec.BooleanValue importAllModdedBiomes;
        public final ForgeConfigSpec.ConfigValue<String> blacklistedBiomeList;
        public final ForgeConfigSpec.ConfigValue<String> blacklistedStructureList;
        public final ForgeConfigSpec.DoubleValue xzTerrainModifier;
        public final ForgeConfigSpec.DoubleValue xzScaleModifier;
        public final ForgeConfigSpec.DoubleValue yTerrainModifier;
        public final ForgeConfigSpec.DoubleValue yScaleModifier;
        public final ForgeConfigSpec.IntValue yMaximum;
        public final ForgeConfigSpec.IntValue dungeonSpawnrate;
        public final ForgeConfigSpec.IntValue ravineSpawnrate;
        public final ForgeConfigSpec.IntValue caveCavitySpawnrate;
        public final ForgeConfigSpec.IntValue oceanCaveSpawnrate;
        public final ForgeConfigSpec.BooleanValue pillarGen;
        public final ForgeConfigSpec.BooleanValue honeyLakeGen;
        public final ForgeConfigSpec.BooleanValue slimeLakeGen;
        public final ForgeConfigSpec.BooleanValue waterLakeGen;
        public final ForgeConfigSpec.BooleanValue lavaLakeGen;
        public final ForgeConfigSpec.BooleanValue chestGeneration;
        public final ForgeConfigSpec.IntValue sunShrineSpawnrate;
        public final ForgeConfigSpec.IntValue stonehengeSpawnrate;
        public final ForgeConfigSpec.IntValue hangingRuinsSpawnrate;
        public final ForgeConfigSpec.BooleanValue miniStructureGeneration;
        public final ForgeConfigSpec.IntValue villageSpawnrate;
        public final ForgeConfigSpec.IntValue villageZombieSpawnrate;
        public final ForgeConfigSpec.IntValue mineshaftSpawnrate;
        public final ForgeConfigSpec.BooleanValue mineshaftAbovegroundAllowed;
        public final ForgeConfigSpec.BooleanValue mineshaftUndergroundAllowed;
        public final ForgeConfigSpec.IntValue mansionSpawnrate;
        public final ForgeConfigSpec.IntValue desertTempleSpawnrate;
        public final ForgeConfigSpec.IntValue jungleTempleSpawnrate;
        public final ForgeConfigSpec.IntValue iglooSpawnrate;
        public final ForgeConfigSpec.IntValue mushroomTempleSpawnrate;
        public final ForgeConfigSpec.IntValue iceSpikeTempleSpawnrate;
        public final ForgeConfigSpec.IntValue witchHutSpawnrate;
        public final ForgeConfigSpec.IntValue oceanMonumentSpawnrate;
        public final ForgeConfigSpec.IntValue oceanRuinsSpawnrate;
        public final ForgeConfigSpec.IntValue shipwreckSpawnrate;
        public final ForgeConfigSpec.IntValue strongholdSpawnrate;
        public final ForgeConfigSpec.DoubleValue silverfishStrongholdSpawnrate;
        public final ForgeConfigSpec.IntValue netherFortressSpawnrate;
        public final ForgeConfigSpec.BooleanValue netherFortressAboveground;
        public final ForgeConfigSpec.BooleanValue netherFortressUnderground;
        public final ForgeConfigSpec.IntValue endCitySpawnrate;
        public final ForgeConfigSpec.IntValue pillageOutpostRarity;
        public final ForgeConfigSpec.BooleanValue secretSetting;
        public final ForgeConfigSpec.BooleanValue heavyFog;
        public final ForgeConfigSpec.IntValue biomeSize;
        public final ForgeConfigSpec.IntValue mutatedBiomeSpawnrate;
        public final ForgeConfigSpec.IntValue seaLevel;
        public final ForgeConfigSpec.BooleanValue lavaOcean;
        public final ForgeConfigSpec.IntValue waterfallSpawnrate;
        public final ForgeConfigSpec.IntValue lavafallSpawnrate;
        public final ForgeConfigSpec.IntValue endIslandSpawnrate;
        public final ForgeConfigSpec.BooleanValue plains;
        public final ForgeConfigSpec.BooleanValue desert;
        public final ForgeConfigSpec.BooleanValue forest;
        public final ForgeConfigSpec.BooleanValue taiga;
        public final ForgeConfigSpec.BooleanValue rockyField;
        public final ForgeConfigSpec.BooleanValue swamplands;
        public final ForgeConfigSpec.BooleanValue nether;
        public final ForgeConfigSpec.BooleanValue end;
        public final ForgeConfigSpec.BooleanValue snowyTundra;
        public final ForgeConfigSpec.BooleanValue icedTerrain;
        public final ForgeConfigSpec.BooleanValue mushroom;
        public final ForgeConfigSpec.BooleanValue stonePlains;
        public final ForgeConfigSpec.BooleanValue bambooJungle;
        public final ForgeConfigSpec.BooleanValue jungle;
        public final ForgeConfigSpec.BooleanValue frozenDesert;
        public final ForgeConfigSpec.BooleanValue birchForest;
        public final ForgeConfigSpec.BooleanValue darkForest;
        public final ForgeConfigSpec.BooleanValue snowyTaiga;
        public final ForgeConfigSpec.BooleanValue giantTreeTaiga;
        public final ForgeConfigSpec.BooleanValue savanna;
        public final ForgeConfigSpec.BooleanValue badlands;
        public final ForgeConfigSpec.BooleanValue spikyBadlands;
        public final ForgeConfigSpec.BooleanValue iceSpike;
        public final ForgeConfigSpec.BooleanValue frozenOcean;
        public final ForgeConfigSpec.BooleanValue coldOcean;
        public final ForgeConfigSpec.BooleanValue ocean;
        public final ForgeConfigSpec.BooleanValue lukewarmOcean;
        public final ForgeConfigSpec.BooleanValue warmOcean;
        public final ForgeConfigSpec.IntValue coalOreSpawnrate;
        public final ForgeConfigSpec.IntValue ironOreSpawnrate;
        public final ForgeConfigSpec.IntValue redstoneOreSpawnrate;
        public final ForgeConfigSpec.IntValue lapisOreSpawnrate;
        public final ForgeConfigSpec.IntValue diamondOreSpawnrate;
        public final ForgeConfigSpec.IntValue goldOreSpawnrate;
        public final ForgeConfigSpec.IntValue emeraldOreSpawnrate;
        public final ForgeConfigSpec.IntValue silverfishSpawnrate;
        public final ForgeConfigSpec.IntValue quartzOreSpawnrate;
        public final ForgeConfigSpec.IntValue glowstoneSpawnrate;
        public final ForgeConfigSpec.IntValue magmaSpawnrate;
        public final ForgeConfigSpec.IntValue lavaSpawnrate;
        public final ForgeConfigSpec.IntValue glowstoneVariantsSpawnrate;
        public final ForgeConfigSpec.BooleanValue rootGen;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Mod Compatibility Options");
            this.importModdedFeatures = builder.comment("\r\nAttempt to add modded features from vanilla biomes into Ultra Amplified version of that biome.\r\nOnly works if other mod added the feature by addFeature(...) to vanilla biome and registered the feature correctly without the 'minecraft' namespace.").translation("ultraamplified.config.structure.importmoddedfeatures").define("importModdedFeatures", false);
            this.importModdedStructure = builder.comment("\r\nAttempt to add modded structures from vanilla biomes into Ultra Amplified version of that biome.\r\nOnly works if other mod added the structure by addFeature(...) to vanilla biome and registered the structure correctly without the 'minecraft' namespace.").translation("ultraamplified.config.structure.importmoddedstructure").define("importModdedStructure", false);
            this.importModdedMobs = builder.comment("\r\nAttempt to add modded mobs from vanilla biomes into Ultra Amplified version of that biome.\r\nOnly works if other mod added the mob by addSpawn(...) to vanilla biome and registered the mob correctly without the 'minecraft' namespace.").translation("ultraamplified.config.structure.importmoddedmobs").define("importModdedMobs", false);
            this.importModdedBiomes = builder.comment("\r\nAttempt to add modded biomes from Overworld into Ultra Amplified dimension. (or into Overworld in Ultra Amplified worldtype)\r\nOnly works if other mod added the biome to the BiomeDictionary with the BiomeType of DESERT, WARM, COOL, or ICY type.").translation("ultraamplified.config.structure.importmoddedbiomes").define("importModdedBiomes", false);
            this.importAllModdedBiomes = builder.comment("\r\nAttempt to add all registered modded biomes into Ultra Amplified dimension or worldtype.\r\nYou may want to turn up biome size to 4 or 5 as this may make biomes very crowded. Also overrides importModdedBiomes setting.").translation("ultraamplified.config.structure.importmoddedbiomes").define("importAllModdedBiomes", false);
            this.blacklistedBiomeList = builder.comment("\r\nBlacklist either all of a mod's biomes or its specific biomes from being imported into Ultra Amplified dimension/worldtype.\r\nTo blacklist all of a mod's biomes, type out its id like so with :* attached at end. Example: \"example_mod_id:*\"\r\nTo blacklist a specific mod's biome, type out the resourcelocation. Example: \"example_mod_id:lava_desert\"\r\nNOTE: Seperate each entry with a comma. Example: \"example_mod_id_1:lava_desert, example_mod_id_2:*, example_mod_id_1:ender_forest\"\r\nAlso, any entry using ultra_amplified_dimension or minecraft id will be ignored as I already handle those ids internally.").translation("ultraamplified.config.structure.blacklistedbiomelist").define("blacklistedBiomeList", (Object)"");
            this.blacklistedStructureList = builder.comment("\r\nBlacklist either all of a mod's structures or specific structures from being imported into Ultra Amplified dimension/worldtype.\r\nTo blacklist all structures in a mod, type out its id like so with :* attached at end. Example: \"example_mod_id:*\"\r\nTo blacklist a specific mod's structure, type out the resourcelocation. Example: \"example_mod_id:wizard_tower\"\r\nNOTE: Seperate each entry with a comma. Example: \"example_mod_id_1:wizard_tower, example_mod_id_2:*, example_mod_id_1:super_village\"\r\nAlso, any entry using ultra_amplified_dimension or minecraft id will be ignored as I already handle those ids internally.").translation("ultraamplified.config.structure.blacklistedfeaturelist").define("blacklistedFeatureList", (Object)"");
            builder.pop();
            builder.push("General Structure Options");
            this.dungeonSpawnrate = builder.comment("\r\nHow often Dungeons will spawn.\r\n0 for no Dungeons and 300 for max spawnrate.").translation("ultraamplified.config.structure.dungeonspawnrate").defineInRange("dungeonSpawnrate", 30, 0, 300);
            this.ravineSpawnrate = builder.comment("\r\nHow often Ravines will spawn.\r\n0 for no Ravines and 100 for max spawnrate.").translation("ultraamplified.config.structure.ravinespawnrate").defineInRange("ravineSpawnrate", 25, 0, 100);
            this.caveCavitySpawnrate = builder.comment("\r\nHow often Cave Cavity will spawn.\r\n0 for no Cave Cavity and 22 for max spawnrate.").translation("ultraamplified.config.structure.cavecavityspawnrate").defineInRange("caveCavitySpawnrate", 5, 0, 22);
            this.oceanCaveSpawnrate = builder.comment("\r\nHow often Underwater Caves will spawn in ocean biomes.\r\n0 for no Underwater Caves and 100 for max spawnrate.").translation("ultraamplified.config.structure.oceancavespawnrate").defineInRange("oceanCaveSpawnrate", 20, 0, 100);
            this.pillarGen = builder.comment("\r\nControls whether pillars features (both ramp and straight kind) spawn or not.").translation("ultraamplified.config.structure.pillargen").define("pillarGen", true);
            this.honeyLakeGen = builder.comment("\r\nControls whether Honey Lakes spawn or not.").translation("ultraamplified.config.structure.honeylakegen").define("honeyLakeGen", true);
            this.slimeLakeGen = builder.comment("\r\nControls whether Slime Lakes spawn or not.").translation("ultraamplified.config.structure.slimelakegen").define("slimeLakeGen", true);
            this.waterLakeGen = builder.comment("\r\nControls whether Water Lakes spawn or not.").translation("ultraamplified.config.structure.waterlakegen").define("waterLakeGen", true);
            this.lavaLakeGen = builder.comment("\r\nControls whether Lava Lakes spawn or not.").translation("ultraamplified.config.structure.lavalakegen").define("lavaLakeGen", true);
            this.glowstoneVariantsSpawnrate = builder.comment("\r\nControls how often patches of Glowdirt and other modded Glowstone variants spawn.\r\n0 for no patches and 1000 for max amount of patches.").translation("ultraamplified.config.structure.glowstonevariantsspawnrate").defineInRange("glowstoneVariantsSpawnrate", 50, 0, 1000);
            this.rootGen = builder.comment("\r\nControls whether roots and short vines spawn or not on the underside of the floating land.").translation("ultraamplified.config.structure.rootgen").define("rootGen", true);
            builder.push("Biome-Based Structure Options");
            this.chestGeneration = builder.comment("\r\nControls whether loot chests spawn or not in all structures.").translation("ultraamplified.config.structure.chestgeneration").define("chestGeneration", true);
            this.sunShrineSpawnrate = builder.comment("\r\nHow rare are Sun Shrines.\r\n1 for Sun Shrines spawning in most chunks and 1000 for very rare spawn.\r\nSpawns mainly in hills variant of biomes.").translation("ultraamplified.config.structure.sunshrinespawnrate").defineInRange("sunShrineSpawnrate", 130, 1, 100);
            this.stonehengeSpawnrate = builder.comment("\r\nHow rare are Stonehenges.\r\n1 for Stonehenges spawning in most chunks and 1000 for very rare spawn.\r\nSpawns mainly in hills variant of biomes.").translation("ultraamplified.config.structure.stonehengespawnrate").defineInRange("stonehengeSpawnrate", 15, 1, 100);
            this.hangingRuinsSpawnrate = builder.comment("\r\nHow rare are Hanging Ruins.\r\n100 for Hanging Ruins spawning in most chunks and 0 for no spawn.\r\nNOTE: this is backwards than other spawnrates.\r\nThis is so you can set chances between 50% and 100% while others need have finer control on chances less than 1%.\r\nSpawns in most biomes except for oceans, Nether, and Ice Mountain Biomes.").translation("ultraamplified.config.structure.hangingruinsspawnrate").defineInRange("hangingRuinsSpawnrate", 40, 0, 100);
            this.miniStructureGeneration = builder.comment("\r\nControls whether Desert Wells, Hay Piles, Sun Shrines, Stonehenges, and Crosses spawn or not.").translation("ultraamplified.config.structure.ministructuregeneration").define("miniStructureGeneration", true);
            this.villageSpawnrate = builder.comment("\r\nHow rare are Villages.\r\n1 for Village spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.villagespawnrate").defineInRange("villageSpawnrate", 16, 1, 101);
            this.villageZombieSpawnrate = builder.comment("\r\nWhat percentage of Classic Styled Villages are Zombie Villages.\r\n0 for no Zombie Village spawning and 100 for all Villages being zombified.").translation("ultraamplified.config.structure.villagezombiespawnrate").defineInRange("villageZombieSpawnrate", 10, 0, 100);
            this.mineshaftSpawnrate = builder.comment("\r\nHow often Mineshafts will spawn.\r\n0 for no Mineshafts and 1000 for max spawnrate.").translation("ultraamplified.config.structure.mineshaftspawnrate").defineInRange("mineshaftSpawnrate", 22, 0, 1000);
            this.mineshaftAbovegroundAllowed = builder.comment("\r\nCan aboveground floating Mineshafts spawn?").translation("ultraamplified.config.structure.mineshaftabovegroundallowed").define("mineshaftAbovegroundAllowed", true);
            this.mineshaftUndergroundAllowed = builder.comment("\r\nCan undergound giant pit Mineshafts spawn?").translation("ultraamplified.config.structure.mineshaftundergroundallowed").define("mineshaftUndergroundAllowed", true);
            this.mansionSpawnrate = builder.comment("\r\nHow rare are Woodland Mansion.\n1 for Woodland Mansion spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.mansionspawnrate").defineInRange("mansionSpawnrate", 18, 1, 101);
            this.desertTempleSpawnrate = builder.comment("\r\nHow rare are Desert Temples.\n1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.deserttemplespawnrate").defineInRange("desertTempleSpawnrate", 20, 1, 101);
            this.jungleTempleSpawnrate = builder.comment("\r\nHow rare are Jungle Temples.\n1 for a spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.jungletemplespawnrate").defineInRange("jungleTempleSpawnrate", 20, 1, 101);
            this.iglooSpawnrate = builder.comment("\r\nHow rare are igloos.\n1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.igloospawnrate").defineInRange("iglooSpawnrate", 14, 1, 101);
            this.mushroomTempleSpawnrate = builder.comment("\r\nHow rare are Mushroom Temples.\n1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.mushroomtemplespawnrate").defineInRange("mushroomTempleSpawnrate", 12, 1, 101);
            this.iceSpikeTempleSpawnrate = builder.comment("\r\nHow rare are Ice Spike Temples.\n1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.icespiketemplespawnrate").defineInRange("iceSpikeTempleSpawnrate", 20, 1, 101);
            this.witchHutSpawnrate = builder.comment("\r\nHow rare are Witch Huts.\n1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.witchhutspawnrate").defineInRange("witchHutSpawnrate", 14, 1, 101);
            this.oceanMonumentSpawnrate = builder.comment("\r\nHow rare are Ocean Monuments.\n1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.oceanmonumentspawnrate").defineInRange("oceanMonumentSpawnrate", 22, 1, 101);
            this.oceanRuinsSpawnrate = builder.comment("\r\nHow rare are Ocean Ruins.\n1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.oceanruinsspawnrate").defineInRange("oceanRuinsSpawnrate", 7, 1, 101);
            this.shipwreckSpawnrate = builder.comment("\r\nHow rare are Shipwrecks.\n1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.shipwreckspawnrate").defineInRange("shipwreckSpawnrate", 7, 1, 101);
            this.strongholdSpawnrate = builder.comment("\r\nHow rare are Strongholds.\n1 for spawning in most chunks and 501 for no spawn.").translation("ultraamplified.config.structure.strongholdspawnrate").defineInRange("strongholdSpawnrate", 62, 1, 501);
            this.silverfishStrongholdSpawnrate = builder.comment("\r\nHow often Silverfish Blocks will generate in Strongholds.\n0 for no Silverfish Blocks and 100 for max spawnrate.").translation("ultraamplified.config.structure.silverfishstrongholdspawnrate").defineInRange("silverfishStrongholdSpawnrate", 4.0, 0.0, 100.0);
            this.netherFortressSpawnrate = builder.comment("\r\nHow rare are Nether Fortresses.\n1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.netherfortressspawnrate").defineInRange("netherFortressSpawnrate", 14, 1, 101);
            this.netherFortressAboveground = builder.comment("\r\nCan Nether Fortresses spawn aboveground in the Nether biome (between y = 85 and 130).").translation("ultraamplified.config.structure.netherfortressaboveground").define("netherFortressAboveground", true);
            this.netherFortressUnderground = builder.comment("\r\nCan stone variant Nether Fortresses spawn underground or not (below y = 60).\n(Stone variant Nether Fortress spawn underground in all biomes except End biome)").translation("ultraamplified.config.structure.netherfortressunderground").define("netherFortressUnderground", true);
            this.endCitySpawnrate = builder.comment("\r\nHow rare are End Cities.\n1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.endcityspawnrate").defineInRange("endCitySpawnrate", 22, 1, 101);
            this.pillageOutpostRarity = builder.comment("\r\nHow rare are Pillager Outposts.\n1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.pillageoutpostrarity").defineInRange("pillageOutpostRarity", 20, 1, 101);
            builder.pop().pop();
            builder.push("Biome and Terrain Options");
            this.secretSetting = builder.comment("\r\nDoes something neat! Give it a try lol\nYou might want to use this on a fresh new world... ;)\nChanges the terrain's look!").translation("ultraamplified.config.structure.secretsettings").define("secretSettings", false);
            this.heavyFog = builder.comment("\r\nAdds very heavy fog to make the world look more spoky and limit visibility.\nThis is not the same as distance fog which does not make chunks near you foggy.").translation("ultraamplified.config.structure.heavyfog").define("heavyFog", false);
            this.yMaximum = builder.comment("\r\nMaxium height the terrain can generate up to.").translation("ultraamplified.config.structure.ymaximum").defineInRange("yMaximum", 245, 100, 256);
            this.xzTerrainModifier = builder.comment("\r\nChanges the xz terrain modifier.\nI believe lower numbers will make the layers longer in the xz plane.\nDefault value is 684.412D").translation("ultraamplified.config.structure.xzterrainmodifier").defineInRange("xzTerrainModifier", 684.412, 1.0, 1.0E7);
            this.xzScaleModifier = builder.comment("\r\nChanges the xz terrain scale.\nNot exactly sure what this does.\nDefault value is 8.55515F").translation("ultraamplified.config.structure.xzscalemodifier").defineInRange("xzScaleModifier", (double)8.55515f, 1.0, 1.0E7);
            this.yTerrainModifier = builder.comment("\r\nChanges the y terrain modifier.\nI believe lower numbers will make less layers and thicken layers that do spawn.\nDefault value is 68419.786D").translation("ultraamplified.config.structure.yterrainmodifier").defineInRange("yTerrainModifier", 68419.786, 1.0, 1.0E7);
            this.yScaleModifier = builder.comment("\r\nChanges the y terrain scale.\nNot exactly sure what this does.\nDefault value is 428.613D").translation("ultraamplified.config.structure.yscalemodifier").defineInRange("yScaleModifier", 428.613, 1.0, 1.0E7);
            this.biomeSize = builder.comment("\r\nHow large the biomes are.\nBigger number means bigger biomes.").translation("ultraamplified.config.structure.biomesize").defineInRange("biomeSize", 3, 1, 8);
            this.mutatedBiomeSpawnrate = builder.comment("\r\nHow often the mutated form of a biome will generate\n0 for no mutated biomes and 10 for all biomes to be mutated.").translation("ultraamplified.config.structure.mutatedbiomespawnrate").defineInRange("mutatedBiomeSpawnrate", 2, 0, 10);
            this.seaLevel = builder.comment("\r\nSea Level").translation("ultraamplified.config.structure.sealevel").defineInRange("seaLevel", 75, 0, 250);
            this.lavaOcean = builder.comment("\r\nReplace the water at sea level with lava instead. DO NOT CHANGE THIS OPTION IN AN ALREADY GENERATED WORLD. IT WILL CRASH DUE TO LAVA OCEAN UPDATING NEXT TO OCEAN WATER!!").translation("ultraamplified.config.structure.lavaocean").define("lavaOcean", false);
            this.waterfallSpawnrate = builder.comment("\r\nHow often waterfalls will spawn.\n0 for no waterfalls and 1000 for max spawnrate.").translation("ultraamplified.config.structure.waterfallspawnrate").defineInRange("waterfallSpawnrate", 35, 0, 1000);
            this.lavafallSpawnrate = builder.comment("\r\nHow often lavafalls will spawn.\n0 for no lavafalls and 1000 for max spawnrate.").translation("ultraamplified.config.structure.lavafallspawnrate").defineInRange("lavafallSpawnrate", 14, 0, 1000);
            this.endIslandSpawnrate = builder.comment("\r\nHow often End Islands will spawn in the End Biome.\n0 for no End Islands and 100 for max spawnrate.").translation("ultraamplified.config.structure.endislandspawnrate").defineInRange("endIslandSpawnrate", 6, 0, 100);
            builder.push("Biome Selection Options");
            this.plains = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.plains").define("plains", true);
            this.desert = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.desert").define("desert", true);
            this.forest = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.forest").define("forest", true);
            this.taiga = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.taiga").define("taiga", true);
            this.rockyField = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.rockyfield").define("rockyField", true);
            this.swamplands = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.swamplands").define("swamplands", true);
            this.nether = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.nether").define("nether", true);
            this.end = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.end").define("end", true);
            this.snowyTundra = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.snowytundra").define("snowyTundra", true);
            this.icedTerrain = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.icedterrain").define("icedTerrain", true);
            this.mushroom = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.mushroom").define("mushroom", true);
            this.stonePlains = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.stoneplains").define("stonePlains", true);
            this.bambooJungle = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.bamboojungle").define("bambooJungle", true);
            this.jungle = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.jungle").define("jungle", true);
            this.frozenDesert = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.frozendesert").define("frozenDesert", true);
            this.birchForest = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.birchforest").define("birchForest", true);
            this.darkForest = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.darkforest").define("darkForest", true);
            this.snowyTaiga = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.snowytaiga").define("snowyTaiga", true);
            this.giantTreeTaiga = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.gianttreetaiga").define("giantTreeTaiga", true);
            this.savanna = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.savanna").define("savanna", true);
            this.badlands = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.badlands").define("badlands", true);
            this.spikyBadlands = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.spikybadlands").define("spikyBadlands", true);
            this.iceSpike = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.icespike").define("iceSpike", true);
            this.frozenOcean = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.frozenocean").define("frozenOcean", true);
            this.coldOcean = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.coldocean").define("coldOcean", true);
            this.ocean = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.ocean").define("ocean", true);
            this.lukewarmOcean = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.lukewarmocean").define("lukewarmOcean", true);
            this.warmOcean = builder.comment("\r\nShould this biome be allowed to spawn?").translation("ultraamplified.config.structure.warmocean").define("warmOcean", true);
            builder.pop().pop();
            builder.push("Main Ores Options");
            this.coalOreSpawnrate = builder.comment("\r\nHow often Coal Ores will spawn.\n0 for no Coal Ores and 1000 for max spawnrate.").translation("ultraamplified.config.structure.coalorespawnrate").defineInRange("coalOreSpawnrate", 35, 0, 1000);
            this.ironOreSpawnrate = builder.comment("\r\nHow often Iron Ores will spawn.\n0 for no Iron Ores and 1000 for max spawnrate.").translation("ultraamplified.config.structure.ironorespawnrate").defineInRange("ironOreSpawnrate", 50, 0, 1000);
            this.redstoneOreSpawnrate = builder.comment("\r\nHow often Redstone Ores will spawn.\n0 for no Redstone Ores and 1000 for max spawnrate.").translation("ultraamplified.config.structure.redstoneorespawnrate").defineInRange("redstoneOreSpawnrate", 12, 0, 1000);
            this.lapisOreSpawnrate = builder.comment("\r\nHow often Lapis Lazuli Ores will spawn.\n0 for no Lapis Lazuli Ores and 1000 for max spawnrate.").translation("ultraamplified.config.structure.lapisorespawnrate").defineInRange("lapisOreSpawnrate", 2, 0, 1000);
            this.diamondOreSpawnrate = builder.comment("\r\nHow often Diamond Ores will spawn.\n0 for no Diamond Ores and 1000 for max spawnrate.").translation("ultraamplified.config.structure.diamondorespawnrate").defineInRange("diamondOreSpawnrate", 1, 0, 1000);
            this.goldOreSpawnrate = builder.comment("\r\nHow often Gold Ores will spawn.\n0 for no Gold Ores and 1000 for max spawnrate.").translation("ultraamplified.config.structure.goldorespawnrate").defineInRange("goldOreSpawnrate", 2, 0, 1000);
            builder.push("Extreme Hills Ores and Features Options");
            this.emeraldOreSpawnrate = builder.comment("\r\nHow often Emerald Ores will spawn in Extreme Hills Biome in the form of a percentage.\n0 for no Emerald Ores and 1000 for max spawnrate.").translation("ultraamplified.config.structure.emeraldorespawnrate").defineInRange("emeraldOreSpawnrate", 100, 0, 1000);
            this.silverfishSpawnrate = builder.comment("\r\nHow often Silverfish Blocks will spawn in Extreme Hills Biome.\n0 for no Silverfish Blocks and 1000 for max spawnrate.").translation("ultraamplified.config.structure.silverfishspawnrate").defineInRange("silverfishSpawnrate", 18, 0, 1000);
            builder.push("Nether Ores and Features Options");
            this.quartzOreSpawnrate = builder.comment("\r\nHow often Quartz Ores will spawn.\n0 for no Quartz Ores and 1000 for max spawnrate.").translation("ultraamplified.config.structure.quartzorespawnrate").defineInRange("quartzOreSpawnrate", 14, 0, 1000);
            this.glowstoneSpawnrate = builder.comment("\r\nHow often Glowstone will spawn in Nether biome.\n0 for no Glowstone and 1000 for max spawnrate.").translation("ultraamplified.config.structure.glowstonespawnrate").defineInRange("glowstoneSpawnrate", 20, 0, 1000);
            this.magmaSpawnrate = builder.comment("\r\nHow often Magma Blocks will spawn below Y = 100 in Nether biome.\n0 for no Magma Blocks and 1000 for max spawnrate.").translation("ultraamplified.config.structure.magmaspawnrate").defineInRange("magmaSpawnrate", 5, 0, 1000);
            this.lavaSpawnrate = builder.comment("\r\nHow often single Lava Blocks will spawn in Nether biome.\n0 for no single Lava Blocks and 1000 for max spawnrate.").translation("ultraamplified.config.structure.lavaspawnrate").defineInRange("lavaSpawnrate", 70, 0, 1000);
            builder.pop().pop().pop();
        }
    }
}

