/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.biome;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.telepathicgrunt.ultraamplified.world.biomes.BadlandsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.BadlandsDensedWoodedBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.BadlandsDissectedPlateauBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.BadlandsSandlessBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.BadlandsSpikyBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.BadlandsWoodedBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.BambooJungleBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.BambooJungleRelicBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.BirchForestBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.DarkForestBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.DarkForestRelicBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.DesertBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.DesertLakesBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.DesertRelicBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.EndBarrenFieldBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.EndFieldBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.FlowerForestBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.FlowerJungleBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.FlowerJungleEdgeBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.ForestBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.ForestRelicBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.FrozenDesertBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.GiantSpruceTaigaPillarsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.GiantSpruceTaigaRelicPillarsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.GiantTreeTaigaBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.GiantTreeTaigaRelicBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.GravellyColumnsFieldBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.GravellyFieldBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.IceSpikesBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.IcedTerrainBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.JungleBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.JungleEdgeBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.JungleRelicBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.MushroomFieldsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.NetherlandBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.OceanBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.OceanColdBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.OceanDeepBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.OceanDeepColdBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.OceanDeepFrozenBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.OceanDeepLukewarmBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.OceanDeepWarmBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.OceanFrozenBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.OceanLukewarmBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.OceanWarmBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.PlainsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.RockyFieldBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.RockyFieldWoodedBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SavannaBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SavannaTerraceBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.ShatteredSavannaBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.ShatteredSavannaTerraceBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SnowyTaigaBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SnowyTaigaRelicBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SnowyTaigaRockyBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SnowyTundraBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.StoneFieldsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SunflowerPlainsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SwampBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SwampSpookyBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.TaigaBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.TaigaRelicBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.TaigaRockyBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.TallBirchForestBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.TallBirchForestRelicBiomeUA;

public class BiomeInit {
    private static ForgeRegistry<Biome> BiomeRegistry = (ForgeRegistry)ForgeRegistries.BIOMES;
    private static Set<Biome> biomes;
    public static Biome PLAINS;
    public static Biome DESERT;
    public static Biome FOREST;
    public static Biome TAIGA;
    public static Biome ROCKY_FIELD;
    public static Biome SWAMP;
    public static Biome NETHERLAND;
    public static Biome END_FIELD;
    public static Biome SNOWY_TUNDRA;
    public static Biome ICED_TERRAIN;
    public static Biome MUSHROOM_FIELDS;
    public static Biome RELIC_DESERT;
    public static Biome RELIC_FOREST;
    public static Biome RELIC_TAIGA;
    public static Biome BAMBOO_JUNGLE;
    public static Biome RELIC_BAMBOO_JUNGLE;
    public static Biome JUNGLE;
    public static Biome RELIC_JUNGLE;
    public static Biome JUNGLE_EDGE;
    public static Biome STONE_PLAINS;
    public static Biome FROZEN_DESERT;
    public static Biome BIRCH_FOREST;
    public static Biome RELIC_BIRCH_FOREST;
    public static Biome DARK_FOREST;
    public static Biome SNOWY_TAIGA;
    public static Biome RELIC_SNOWY_TAIGA;
    public static Biome GIANT_TREE_TAIGA;
    public static Biome RELIC_GIANT_TREE_TAIGA;
    public static Biome WOODED_ROCKY_FIELD;
    public static Biome SAVANNA;
    public static Biome SAVANNA_TERRACE;
    public static Biome BADLANDS;
    public static Biome WOODED_BADLANDS;
    public static Biome SANDLESS_BADLANDS;
    public static Biome SUNFLOWER_PLAINS;
    public static Biome DESERT_LAKES;
    public static Biome GRAVELLY_FIELD;
    public static Biome FLOWER_FOREST;
    public static Biome ROCKY_TAIGA;
    public static Biome SPOOKY_SWAMP;
    public static Biome ICE_SPIKES;
    public static Biome FLOWER_JUNGLE;
    public static Biome FLOWER_JUNGLE_EDGE;
    public static Biome TALL_BIRCH_FOREST;
    public static Biome RELIC_TALL_BIRCH_FOREST;
    public static Biome RELIC_DARK_FOREST;
    public static Biome SNOWY_ROCKY_TAIGA;
    public static Biome GIANT_SPRUCE_TAIGA_PILLARS;
    public static Biome RELIC_GIANT_SPRUCE_TAIGA_PILLARS;
    public static Biome GRAVELLY_COLUMNS_FIELD;
    public static Biome SHATTERED_SAVANNA;
    public static Biome SHATTERED_SAVANNA_TERRACE;
    public static Biome SPIKY_BADLANDS;
    public static Biome DENSED_WOODED_BADLANDS;
    public static Biome BADLANDS_DISSECTED_PLATEAU;
    public static Biome COLD_OCEAN;
    public static Biome DEEP_COLD_OCEAN;
    public static Biome DEEP_FROZEN_OCEAN;
    public static Biome DEEP_LUKEWARM_OCEAN;
    public static Biome DEEP_OCEAN;
    public static Biome DEEP_WARM_OCEAN;
    public static Biome FROZEN_OCEAN;
    public static Biome LUKEWARM_OCEAN;
    public static Biome OCEAN;
    public static Biome WARM_OCEAN;
    public static Biome BARREN_END_FIELD;
    private static RegistryEvent.Register<Biome> eventIn;
    public static final Map<Biome, Biome> BASE_TO_MUTATION_MAP;
    public static final Map<Integer, Integer> BASE_TO_HILLS_MAP;

    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        eventIn = event;
        BiomeInit.initBiome(PLAINS, "Plains", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.PLAINS);
        BiomeInit.initBiome(DESERT, "Desert", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY);
        BiomeInit.initBiome(FOREST, "Forest", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST);
        BiomeInit.initBiome(TAIGA, "Taiga", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST);
        BiomeInit.initBiome(ROCKY_FIELD, "Rocky Field", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS);
        BiomeInit.initBiome(SWAMP, "Swamp", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP);
        BiomeInit.initBiome(NETHERLAND, "Netherland", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY);
        BiomeInit.initBiome(END_FIELD, "End Field", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.END, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DRY);
        BiomeInit.initBiome(SNOWY_TUNDRA, "Snowy Tundra", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.SNOWY);
        BiomeInit.initBiome(ICED_TERRAIN, "Iced Terrain", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SNOWY);
        BiomeInit.initBiome(MUSHROOM_FIELDS, "Mushroom Field", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.MUSHROOM, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(RELIC_DESERT, "Relic Desert", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.HILLS);
        BiomeInit.initBiome(RELIC_FOREST, "Relic Forest", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.HILLS);
        BiomeInit.initBiome(RELIC_TAIGA, "Relic Taiga", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.CONIFEROUS);
        BiomeInit.initBiome(BAMBOO_JUNGLE, "Bamboo Jungle", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.JUNGLE);
        BiomeInit.initBiome(RELIC_BAMBOO_JUNGLE, "Relic Bamboo Jungle", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.JUNGLE);
        BiomeInit.initBiome(JUNGLE, "Jungle", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.JUNGLE);
        BiomeInit.initBiome(RELIC_JUNGLE, "Relic Jungle", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HILLS);
        BiomeInit.initBiome(JUNGLE_EDGE, "Jungle Edge", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(STONE_PLAINS, "Stone Plains", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.BEACH);
        BiomeInit.initBiome(FROZEN_DESERT, "Frozen Desert", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD);
        BiomeInit.initBiome(BIRCH_FOREST, "Birch Forest", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST);
        BiomeInit.initBiome(RELIC_BIRCH_FOREST, "Relic Birch Forest", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS);
        BiomeInit.initBiome(DARK_FOREST, "Dark Forest", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.SPOOKY);
        BiomeInit.initBiome(SNOWY_TAIGA, "Snowy Taiga", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD);
        BiomeInit.initBiome(RELIC_SNOWY_TAIGA, "Relic Snowy Taiga", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.HILLS);
        BiomeInit.initBiome(GIANT_TREE_TAIGA, "Giant Tree Taiga", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST);
        BiomeInit.initBiome(RELIC_GIANT_TREE_TAIGA, "Relic Giant Tree Taiga", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS);
        BiomeInit.initBiome(WOODED_ROCKY_FIELD, "Wooden Rocky Field", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SPARSE);
        BiomeInit.initBiome(SAVANNA, "Savanna", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE);
        BiomeInit.initBiome(SAVANNA_TERRACE, "Savanna Terrace", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(BADLANDS, "Badlands", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.MESA, BiomeDictionary.Type.SANDY);
        BiomeInit.initBiome(WOODED_BADLANDS, "Wooded Badlands", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.MESA, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.SPARSE);
        BiomeInit.initBiome(SANDLESS_BADLANDS, "Sandless_Badlands", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.MESA, BiomeDictionary.Type.SANDY);
        BiomeInit.initBiome(SUNFLOWER_PLAINS, "Sunflower Plains", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(DESERT_LAKES, "Desert Lakes", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(GRAVELLY_FIELD, "Gravelly Field", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(FLOWER_FOREST, "Flower Forest", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(ROCKY_TAIGA, "Rocky Taiga", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(SPOOKY_SWAMP, "Spooky Swampland", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(ICE_SPIKES, "Ice Spikes", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(FLOWER_JUNGLE, "Flower Jungle", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.RARE, BiomeDictionary.Type.DENSE);
        BiomeInit.initBiome(FLOWER_JUNGLE_EDGE, "Flower Jungle Edge", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(TALL_BIRCH_FOREST, "Tall Birch Forest", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(RELIC_TALL_BIRCH_FOREST, "Relic Tall Birch Forest", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(RELIC_DARK_FOREST, "Relic Dark Forest", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(SNOWY_ROCKY_TAIGA, "Snowy Rocky Taiga", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(GIANT_SPRUCE_TAIGA_PILLARS, "Giant Spruce Taiga Pillars", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(RELIC_GIANT_SPRUCE_TAIGA_PILLARS, "Relic Giant Spruce Taiga Pillars", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(GRAVELLY_COLUMNS_FIELD, "Gravelly Columns Field", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(SHATTERED_SAVANNA, "Shattered Savanna", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(SHATTERED_SAVANNA_TERRACE, "Shattered Savanna Terrace", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(SPIKY_BADLANDS, "Spiky Badlands", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.MESA, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(DENSED_WOODED_BADLANDS, "Densed Wooded Badlands", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.MESA, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(BADLANDS_DISSECTED_PLATEAU, "Badlands Dissected Plateau", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.MESA, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(COLD_OCEAN, "Cold Ocean", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.OCEAN);
        BiomeInit.initBiome(DEEP_COLD_OCEAN, "Deep Cold Ocean", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.COLD);
        BiomeInit.initBiome(DEEP_FROZEN_OCEAN, "Deep Frozen Ocean", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.COLD);
        BiomeInit.initBiome(DEEP_LUKEWARM_OCEAN, "Deep Lukewarm Ocean", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OCEAN);
        BiomeInit.initBiome(DEEP_OCEAN, "Deep Ocean", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.OCEAN);
        BiomeInit.initBiome(DEEP_WARM_OCEAN, "Deep Warm Ocean", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.HOT);
        BiomeInit.initBiome(FROZEN_OCEAN, "Frozen Ocean", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.COLD);
        BiomeInit.initBiome(LUKEWARM_OCEAN, "Lukewarm Ocean", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OCEAN);
        BiomeInit.initBiome(OCEAN, "Ocean", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.OCEAN);
        BiomeInit.initBiome(WARM_OCEAN, "Warm Ocean", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.HOT);
        BiomeInit.initBiome(BARREN_END_FIELD, "Barren End Field", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.END, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DRY);
        BiomeInit.mapMBiomes();
        BiomeInit.mapHillsBiomes();
        biomes = ImmutableSet.of((Object)PLAINS, (Object)DESERT, (Object)ROCKY_FIELD, (Object)FOREST, (Object)TAIGA, (Object)SWAMP, (Object[])new Biome[]{NETHERLAND, END_FIELD, SNOWY_TUNDRA, ICED_TERRAIN, MUSHROOM_FIELDS, RELIC_DESERT, RELIC_FOREST, RELIC_TAIGA, BAMBOO_JUNGLE, RELIC_BAMBOO_JUNGLE, JUNGLE, RELIC_JUNGLE, JUNGLE_EDGE, STONE_PLAINS, FROZEN_DESERT, BIRCH_FOREST, RELIC_BIRCH_FOREST, DARK_FOREST, SNOWY_TAIGA, RELIC_SNOWY_TAIGA, GIANT_TREE_TAIGA, RELIC_GIANT_TREE_TAIGA, WOODED_ROCKY_FIELD, SAVANNA, SAVANNA_TERRACE, BADLANDS, WOODED_BADLANDS, SANDLESS_BADLANDS, SUNFLOWER_PLAINS, DESERT_LAKES, GRAVELLY_FIELD, FLOWER_FOREST, ROCKY_TAIGA, SPOOKY_SWAMP, ICE_SPIKES, FLOWER_JUNGLE, FLOWER_JUNGLE_EDGE, TALL_BIRCH_FOREST, RELIC_TALL_BIRCH_FOREST, RELIC_DARK_FOREST, SNOWY_ROCKY_TAIGA, GIANT_SPRUCE_TAIGA_PILLARS, RELIC_GIANT_SPRUCE_TAIGA_PILLARS, GRAVELLY_COLUMNS_FIELD, SHATTERED_SAVANNA, SHATTERED_SAVANNA_TERRACE, SPIKY_BADLANDS, DENSED_WOODED_BADLANDS, BADLANDS_DISSECTED_PLATEAU, FROZEN_OCEAN, COLD_OCEAN, OCEAN, LUKEWARM_OCEAN, WARM_OCEAN, DEEP_FROZEN_OCEAN, DEEP_COLD_OCEAN, DEEP_OCEAN, DEEP_LUKEWARM_OCEAN, DEEP_WARM_OCEAN, BARREN_END_FIELD});
    }

    private static Biome initBiome(Biome biome, String name, BiomeManager.BiomeType biomeType, BiomeDictionary.Type ... types) {
        biome.setRegistryName(name.toLowerCase().replace(' ', '_'));
        eventIn.getRegistry().register((IForgeRegistryEntry)biome);
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])types);
        return biome;
    }

    public static Set<Biome> getBiomeArray() {
        return biomes;
    }

    private static void mapMBiomes() {
        BASE_TO_MUTATION_MAP.put(PLAINS, SUNFLOWER_PLAINS);
        BASE_TO_MUTATION_MAP.put(DESERT, DESERT_LAKES);
        BASE_TO_MUTATION_MAP.put(BIRCH_FOREST, TALL_BIRCH_FOREST);
        BASE_TO_MUTATION_MAP.put(RELIC_BIRCH_FOREST, RELIC_TALL_BIRCH_FOREST);
        BASE_TO_MUTATION_MAP.put(SNOWY_TAIGA, SNOWY_ROCKY_TAIGA);
        BASE_TO_MUTATION_MAP.put(ROCKY_FIELD, GRAVELLY_FIELD);
        BASE_TO_MUTATION_MAP.put(WOODED_ROCKY_FIELD, GRAVELLY_COLUMNS_FIELD);
        BASE_TO_MUTATION_MAP.put(FOREST, FLOWER_FOREST);
        BASE_TO_MUTATION_MAP.put(SNOWY_TUNDRA, ICE_SPIKES);
        BASE_TO_MUTATION_MAP.put(JUNGLE, FLOWER_JUNGLE);
        BASE_TO_MUTATION_MAP.put(JUNGLE_EDGE, FLOWER_JUNGLE_EDGE);
        BASE_TO_MUTATION_MAP.put(BADLANDS, SPIKY_BADLANDS);
        BASE_TO_MUTATION_MAP.put(SANDLESS_BADLANDS, BADLANDS_DISSECTED_PLATEAU);
        BASE_TO_MUTATION_MAP.put(WOODED_BADLANDS, DENSED_WOODED_BADLANDS);
        BASE_TO_MUTATION_MAP.put(GIANT_TREE_TAIGA, GIANT_SPRUCE_TAIGA_PILLARS);
        BASE_TO_MUTATION_MAP.put(RELIC_GIANT_TREE_TAIGA, RELIC_GIANT_SPRUCE_TAIGA_PILLARS);
        BASE_TO_MUTATION_MAP.put(DARK_FOREST, RELIC_DARK_FOREST);
        BASE_TO_MUTATION_MAP.put(SAVANNA, SHATTERED_SAVANNA);
        BASE_TO_MUTATION_MAP.put(SAVANNA_TERRACE, SHATTERED_SAVANNA_TERRACE);
        BASE_TO_MUTATION_MAP.put(SWAMP, SPOOKY_SWAMP);
        BASE_TO_MUTATION_MAP.put(TAIGA, ROCKY_TAIGA);
    }

    private static void mapHillsBiomes() {
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)DESERT), BiomeRegistry.getID((IForgeRegistryEntry)RELIC_DESERT));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)FOREST), BiomeRegistry.getID((IForgeRegistryEntry)RELIC_FOREST));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)TAIGA), BiomeRegistry.getID((IForgeRegistryEntry)RELIC_TAIGA));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)BAMBOO_JUNGLE), BiomeRegistry.getID((IForgeRegistryEntry)RELIC_BAMBOO_JUNGLE));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)JUNGLE), BiomeRegistry.getID((IForgeRegistryEntry)RELIC_JUNGLE));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)BIRCH_FOREST), BiomeRegistry.getID((IForgeRegistryEntry)RELIC_BIRCH_FOREST));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)SNOWY_TAIGA), BiomeRegistry.getID((IForgeRegistryEntry)RELIC_SNOWY_TAIGA));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)GIANT_TREE_TAIGA), BiomeRegistry.getID((IForgeRegistryEntry)RELIC_GIANT_TREE_TAIGA));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)ROCKY_FIELD), BiomeRegistry.getID((IForgeRegistryEntry)WOODED_ROCKY_FIELD));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)SAVANNA), BiomeRegistry.getID((IForgeRegistryEntry)SAVANNA_TERRACE));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)OCEAN), BiomeRegistry.getID((IForgeRegistryEntry)DEEP_OCEAN));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)COLD_OCEAN), BiomeRegistry.getID((IForgeRegistryEntry)DEEP_COLD_OCEAN));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)FROZEN_OCEAN), BiomeRegistry.getID((IForgeRegistryEntry)DEEP_FROZEN_OCEAN));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)LUKEWARM_OCEAN), BiomeRegistry.getID((IForgeRegistryEntry)DEEP_LUKEWARM_OCEAN));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)WARM_OCEAN), BiomeRegistry.getID((IForgeRegistryEntry)DEEP_WARM_OCEAN));
    }

    static {
        PLAINS = new PlainsBiomeUA();
        DESERT = new DesertBiomeUA();
        FOREST = new ForestBiomeUA();
        TAIGA = new TaigaBiomeUA();
        ROCKY_FIELD = new RockyFieldBiomeUA();
        SWAMP = new SwampBiomeUA();
        NETHERLAND = new NetherlandBiomeUA();
        END_FIELD = new EndFieldBiomeUA();
        SNOWY_TUNDRA = new SnowyTundraBiomeUA();
        ICED_TERRAIN = new IcedTerrainBiomeUA();
        MUSHROOM_FIELDS = new MushroomFieldsBiomeUA();
        RELIC_DESERT = new DesertRelicBiomeUA();
        RELIC_FOREST = new ForestRelicBiomeUA();
        RELIC_TAIGA = new TaigaRelicBiomeUA();
        BAMBOO_JUNGLE = new BambooJungleBiomeUA();
        RELIC_BAMBOO_JUNGLE = new BambooJungleRelicBiomeUA();
        JUNGLE = new JungleBiomeUA();
        RELIC_JUNGLE = new JungleRelicBiomeUA();
        JUNGLE_EDGE = new JungleEdgeBiomeUA();
        STONE_PLAINS = new StoneFieldsBiomeUA();
        FROZEN_DESERT = new FrozenDesertBiomeUA();
        BIRCH_FOREST = new BirchForestBiomeUA();
        RELIC_BIRCH_FOREST = new BirchForestBiomeUA();
        DARK_FOREST = new DarkForestBiomeUA();
        SNOWY_TAIGA = new SnowyTaigaBiomeUA();
        RELIC_SNOWY_TAIGA = new SnowyTaigaRelicBiomeUA();
        GIANT_TREE_TAIGA = new GiantTreeTaigaBiomeUA();
        RELIC_GIANT_TREE_TAIGA = new GiantTreeTaigaRelicBiomeUA();
        WOODED_ROCKY_FIELD = new RockyFieldWoodedBiomeUA();
        SAVANNA = new SavannaBiomeUA();
        SAVANNA_TERRACE = new SavannaTerraceBiomeUA();
        BADLANDS = new BadlandsBiomeUA();
        WOODED_BADLANDS = new BadlandsWoodedBiomeUA();
        SANDLESS_BADLANDS = new BadlandsSandlessBiomeUA();
        SUNFLOWER_PLAINS = new SunflowerPlainsBiomeUA();
        DESERT_LAKES = new DesertLakesBiomeUA();
        GRAVELLY_FIELD = new GravellyFieldBiomeUA();
        FLOWER_FOREST = new FlowerForestBiomeUA();
        ROCKY_TAIGA = new TaigaRockyBiomeUA();
        SPOOKY_SWAMP = new SwampSpookyBiomeUA();
        ICE_SPIKES = new IceSpikesBiomeUA();
        FLOWER_JUNGLE = new FlowerJungleBiomeUA();
        FLOWER_JUNGLE_EDGE = new FlowerJungleEdgeBiomeUA();
        TALL_BIRCH_FOREST = new TallBirchForestBiomeUA();
        RELIC_TALL_BIRCH_FOREST = new TallBirchForestRelicBiomeUA();
        RELIC_DARK_FOREST = new DarkForestRelicBiomeUA();
        SNOWY_ROCKY_TAIGA = new SnowyTaigaRockyBiomeUA();
        GIANT_SPRUCE_TAIGA_PILLARS = new GiantSpruceTaigaPillarsBiomeUA();
        RELIC_GIANT_SPRUCE_TAIGA_PILLARS = new GiantSpruceTaigaRelicPillarsBiomeUA();
        GRAVELLY_COLUMNS_FIELD = new GravellyColumnsFieldBiomeUA();
        SHATTERED_SAVANNA = new ShatteredSavannaBiomeUA();
        SHATTERED_SAVANNA_TERRACE = new ShatteredSavannaTerraceBiomeUA();
        SPIKY_BADLANDS = new BadlandsSpikyBiomeUA();
        DENSED_WOODED_BADLANDS = new BadlandsDensedWoodedBiomeUA();
        BADLANDS_DISSECTED_PLATEAU = new BadlandsDissectedPlateauBiomeUA();
        COLD_OCEAN = new OceanColdBiomeUA();
        DEEP_COLD_OCEAN = new OceanDeepColdBiomeUA();
        DEEP_FROZEN_OCEAN = new OceanDeepFrozenBiomeUA();
        DEEP_LUKEWARM_OCEAN = new OceanDeepLukewarmBiomeUA();
        DEEP_OCEAN = new OceanDeepBiomeUA();
        DEEP_WARM_OCEAN = new OceanDeepWarmBiomeUA();
        FROZEN_OCEAN = new OceanFrozenBiomeUA();
        LUKEWARM_OCEAN = new OceanLukewarmBiomeUA();
        OCEAN = new OceanBiomeUA();
        WARM_OCEAN = new OceanWarmBiomeUA();
        BARREN_END_FIELD = new EndBarrenFieldBiomeUA();
        eventIn = null;
        BASE_TO_MUTATION_MAP = new HashMap<Biome, Biome>();
        BASE_TO_HILLS_MAP = new HashMap<Integer, Integer>();
    }
}

