/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.biome.surfacebuilder;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;

public class IceMountainSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    private static final BlockState STONE = Blocks.field_150348_b.func_176223_P();
    private static final BlockState LAVA = Blocks.field_150353_l.func_176223_P();
    private static final BlockState ICE = Blocks.field_150432_aD.func_176223_P();
    private static final BlockState SNOW_BLOCK = Blocks.field_196604_cC.func_176223_P();

    public IceMountainSurfaceBuilder(Function<Dynamic<?>, ? extends SurfaceBuilderConfig> p_i51310_1_) {
        super(p_i51310_1_);
    }

    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        BlockState iblockstate = SNOW_BLOCK;
        BlockState iblockstate1 = ICE;
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
        int i = -1;
        int j = (int)(noise / 3.0 + 3.0 + random.nextDouble() * 0.25);
        int xpos = x & 0xF;
        int zpos = z & 0xF;
        for (int ypos = 255; ypos >= 0; --ypos) {
            blockpos$Mutable.func_181079_c(xpos, ypos, zpos);
            BlockState iblockstate2 = chunkIn.func_180495_p((BlockPos)blockpos$Mutable);
            if (iblockstate2.func_177230_c() == null || iblockstate2.func_185904_a() == Material.field_151579_a) {
                i = -1;
                continue;
            }
            if (iblockstate2.func_185904_a() == Material.field_151586_h) {
                if (ypos < ConfigUA.seaLevel) {
                    chunkIn.func_177436_a((BlockPos)blockpos$Mutable, ConfigUA.lavaOcean ? LAVA : SNOW_BLOCK, false);
                }
                i = -1;
                continue;
            }
            if (iblockstate2 != STONE) continue;
            if (i == -1) {
                if (j <= 0) {
                    iblockstate = Blocks.field_150350_a.func_176223_P();
                    iblockstate1 = ICE;
                } else if (ypos >= seaLevel - 4 && ypos <= seaLevel + 1) {
                    iblockstate = SNOW_BLOCK;
                    iblockstate1 = ICE;
                }
                i = j;
                if (ypos >= seaLevel - 1) {
                    chunkIn.func_177436_a((BlockPos)blockpos$Mutable, iblockstate, false);
                    continue;
                }
                chunkIn.func_177436_a((BlockPos)blockpos$Mutable, iblockstate1, false);
                continue;
            }
            if (i > 0) {
                --i;
                chunkIn.func_177436_a((BlockPos)blockpos$Mutable, iblockstate1, false);
                continue;
            }
            chunkIn.func_177436_a((BlockPos)blockpos$Mutable, ICE, false);
        }
    }
}

