/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.biome.surfacebuilder;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;

public class NetherSurfaceBuilderUA
extends SurfaceBuilder<SurfaceBuilderConfig> {
    private static final BlockState STONE = Blocks.field_150348_b.func_176223_P();
    private static final BlockState CAVE_AIR = Blocks.field_201941_jj.func_176223_P();
    private static final BlockState NETHERRACK = Blocks.field_150424_aL.func_176223_P();
    private static final BlockState GRAVEL = Blocks.field_150351_n.func_176223_P();
    private static final BlockState SOUL_SAND = Blocks.field_150425_aM.func_176223_P();
    private static final BlockState LAVA = Blocks.field_150353_l.func_176223_P();
    private static final BlockState WATER = Blocks.field_150355_j.func_176223_P();
    private static final BlockState MAGMA = Blocks.field_196814_hQ.func_176223_P();
    protected long field_205552_a;
    protected OctavesNoiseGenerator field_205553_b;

    public NetherSurfaceBuilderUA(Function<Dynamic<?>, ? extends SurfaceBuilderConfig> p_i51310_1_) {
        super(p_i51310_1_);
    }

    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        int sealevel = seaLevel + 1;
        int xpos = x & 0xF;
        int zpos = z & 0xF;
        int l = (int)(noise / 3.0 + 3.0 + random.nextDouble() * 0.25);
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
        int i1 = -1;
        BlockState iblockstate = NETHERRACK;
        BlockState iblockstate1 = NETHERRACK;
        for (int ypos = 255; ypos >= 0; --ypos) {
            boolean flag1;
            blockpos$Mutable.func_181079_c(xpos, ypos, zpos);
            BlockState iblockstate2 = chunkIn.func_180495_p((BlockPos)blockpos$Mutable);
            if (iblockstate2.func_177230_c() == null || iblockstate2.func_185904_a() == Material.field_151579_a) {
                i1 = -1;
                continue;
            }
            if (iblockstate2.func_185904_a() == Material.field_151586_h) {
                if (ypos < ConfigUA.seaLevel - 7) {
                    chunkIn.func_177436_a((BlockPos)blockpos$Mutable, LAVA, false);
                } else {
                    chunkIn.func_177436_a((BlockPos)blockpos$Mutable, ConfigUA.lavaOcean ? LAVA : WATER, false);
                }
                i1 = -1;
                continue;
            }
            if (iblockstate2 != STONE) continue;
            boolean flag = this.field_205553_b.func_205563_a((double)x * 0.13125, (double)z * 0.13125, (double)(ypos / 5)) * 15.0 + random.nextDouble() * 0.2 > 4.5;
            boolean bl = flag1 = this.field_205553_b.func_205563_a((double)x * 0.13125, (double)(ypos / 5) + 109.0, (double)z * 0.13125) * 15.0 + random.nextDouble() * 0.2 > 5.0;
            if (i1 == -1) {
                if (l <= 0) {
                    iblockstate = CAVE_AIR;
                    iblockstate1 = NETHERRACK;
                } else if (ypos >= sealevel - 4) {
                    iblockstate = NETHERRACK;
                    iblockstate1 = NETHERRACK;
                    if (noise > -3.85 && noise < -3.7 || noise > -0.1 && noise < 0.05 || noise > 3.7 && noise < 3.85) {
                        iblockstate = MAGMA;
                    }
                    if (flag1) {
                        iblockstate = GRAVEL;
                    }
                    if (flag) {
                        iblockstate = SOUL_SAND;
                        iblockstate1 = SOUL_SAND;
                    }
                }
                i1 = l;
                if (ypos >= sealevel - 1) {
                    chunkIn.func_177436_a((BlockPos)blockpos$Mutable, iblockstate, false);
                    continue;
                }
                chunkIn.func_177436_a((BlockPos)blockpos$Mutable, iblockstate1, false);
                continue;
            }
            if (i1 > 0) {
                --i1;
                chunkIn.func_177436_a((BlockPos)blockpos$Mutable, iblockstate1, false);
                continue;
            }
            chunkIn.func_177436_a((BlockPos)blockpos$Mutable, NETHERRACK, false);
        }
    }

    public void func_205548_a(long seed) {
        if (this.field_205552_a != seed || this.field_205553_b == null) {
            this.field_205553_b = new OctavesNoiseGenerator(new SharedSeedRandom(seed), 4, 0);
        }
        this.field_205552_a = seed;
    }
}

