/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.dimension;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Locale;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegUtil {
    @Nonnull
    public static <T> T injected() {
        return null;
    }

    public static <T extends IForgeRegistryEntry<T>> Generic<T> generic(IForgeRegistry<T> registry) {
        return new Generic(registry);
    }

    public static Blocks blocks(IForgeRegistry<Block> registry) {
        return new Blocks(registry);
    }

    public static Items items(IForgeRegistry<Item> registry) {
        return new Items(registry);
    }

    public static void registerStructure(String key, Structure<?> structure) {
        Registry.func_218325_a((Registry)Registry.field_218361_B, (String)key.toLowerCase(Locale.ROOT), structure);
        Feature.field_202300_at.put((Object)key.toLowerCase(Locale.ROOT), structure);
    }

    public static class Generic<T extends IForgeRegistryEntry<T>> {
        private final IForgeRegistry<T> registry;

        private Generic(IForgeRegistry<T> registry) {
            this.registry = registry;
        }

        public Generic<T> add(String name, T entry) {
            ResourceLocation registryName = GameData.checkPrefix((String)name, (boolean)false);
            entry.setRegistryName(registryName);
            this.registry.register(entry);
            return this;
        }
    }

    public static class Blocks {
        private final IForgeRegistry<Block> registry;
        private Supplier<Block.Properties> propertiesSupplier;

        private Blocks(IForgeRegistry<Block> registry) {
            this.registry = registry;
        }

        public Blocks withProperties(Supplier<Block.Properties> propertiesSupplier) {
            this.propertiesSupplier = propertiesSupplier;
            return this;
        }

        public Blocks add(String name, Block block) {
            ResourceLocation registryName = GameData.checkPrefix((String)name, (boolean)false);
            block.setRegistryName(registryName);
            this.registry.register((IForgeRegistryEntry)block);
            return this;
        }

        public Blocks add(String name, Function<Block.Properties, Block> function) {
            Preconditions.checkNotNull(this.propertiesSupplier, (Object)"properties supplier not set");
            Block block = (Block)function.apply(this.propertiesSupplier.get());
            return this.add(name, block);
        }
    }

    public static class Items {
        private final IForgeRegistry<Item> registry;
        private Supplier<Item.Properties> propertiesSupplier = Item.Properties::new;

        private Items(IForgeRegistry<Item> registry) {
            this.registry = registry;
        }

        public Items withProperties(Supplier<Item.Properties> propertiesSupplier) {
            this.propertiesSupplier = propertiesSupplier;
            return this;
        }

        public Items add(String name, Item item) {
            ResourceLocation registryName = GameData.checkPrefix((String)name, (boolean)false);
            item.setRegistryName(registryName);
            this.registry.register((IForgeRegistryEntry)item);
            return this;
        }

        public Items add(String name, Function<Item.Properties, Item> function) {
            Item item = (Item)function.apply(this.propertiesSupplier.get());
            return this.add(name, item);
        }

        public Items add(Block block, BiFunction<Block, Item.Properties, Item> function) {
            Item item = function.apply(block, (Item.Properties)this.propertiesSupplier.get());
            item.setRegistryName(block.getRegistryName());
            this.registry.register((IForgeRegistryEntry)item);
            return this;
        }

        public Items addAll(BiFunction<Block, Item.Properties, Item> function, Block ... blocks) {
            for (Block block : blocks) {
                this.add(block, function);
            }
            return this;
        }

        public Items add(String customName, Block block, BiFunction<Block, Item.Properties, Item> function) {
            this.registry.register(function.apply(block, (Item.Properties)this.propertiesSupplier.get()).setRegistryName("ultra_amplified_dimension", customName));
            return this;
        }
    }
}

