/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.dimension;

import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;
import net.telepathicgrunt.ultraamplified.world.generation.BiomeProviderUA;
import net.telepathicgrunt.ultraamplified.world.generation.UAChunkGenerator;

public class UltraAmplifiedWorldProvider
extends Dimension {
    public UltraAmplifiedWorldProvider(World worldIn, DimensionType typeIn) {
        super(worldIn, typeIn, 1.0f);
        for (int i = 0; i <= 15; ++i) {
            this.field_76573_f[i] = (float)i / 20.0f;
        }
    }

    public BlockPos func_206920_a(ChunkPos chunkPosIn, boolean checkValid) {
        BlockPos blockpos = this.field_76579_a.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPos(10, 90, 8));
        return this.field_76579_a.func_184141_c(blockpos).func_185904_a().func_76230_c() ? blockpos : null;
    }

    public BlockPos func_206921_a(int posX, int posZ, boolean checkValid) {
        return this.func_206920_a(new ChunkPos(posX, posZ), checkValid);
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        double d0 = MathHelper.func_181162_h((double)((double)worldTime / 24000.0 - 0.25));
        double d1 = 0.5 - Math.cos(d0 * Math.PI) / 2.0;
        return (float)(d0 * 2.0 + d1) / 3.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_76571_f() {
        return ConfigUA.yMaximum + 2;
    }

    public int getActualHeight() {
        return 256;
    }

    public boolean func_76569_d() {
        return true;
    }

    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        float f = MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        float f1 = 0.7529412f;
        float f2 = 0.84705883f;
        float f3 = 1.0f;
        float multiplierOfBrightness = ((float)Minecraft.func_71410_x().field_71439_g.func_174824_e((float)partialTicks).field_72448_b - 85.0f) / (float)(ConfigUA.yMaximum - 85);
        Math.min(Math.max(multiplierOfBrightness, 0.0f), 1.0f);
        f1 = f1 * (f * 0.94f + 0.06f) * multiplierOfBrightness;
        f2 = f2 * (f * 0.94f + 0.06f) * multiplierOfBrightness;
        f3 = f3 * (f * 0.91f + 0.09f) * multiplierOfBrightness;
        return new Vec3d((double)f1, (double)f2, (double)f3);
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_76565_k() {
        return 70.0;
    }

    public boolean func_76567_e() {
        return false;
    }

    public boolean func_76568_b(int x, int z) {
        return ConfigUA.heavyFog;
    }

    public ChunkGenerator<?> func_186060_c() {
        return new UAChunkGenerator((IWorld)this.field_76579_a, new BiomeProviderUA(this.field_76579_a), (OverworldGenSettings)ChunkGeneratorType.field_206911_b.func_205483_a());
    }
}

