/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.BlockBlobConfig;
import net.minecraft.world.gen.feature.Feature;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;

public class BoulderNormal
extends Feature<BlockBlobConfig> {
    private static final BlockState mossyCobblestone = Blocks.field_150341_Y.func_176223_P();
    private static final BlockState cobblestone = Blocks.field_150347_e.func_176223_P();
    private static final BlockState andesite = Blocks.field_196656_g.func_176223_P();
    private static final BlockState coalOre = Blocks.field_150365_q.func_176223_P();
    private static final BlockState ironOre = Blocks.field_150366_p.func_176223_P();
    private static final BlockState diamondOre = Blocks.field_150482_ag.func_176223_P();
    private final int startRadius = 3;

    public BoulderNormal(Function<Dynamic<?>, ? extends BlockBlobConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> p_212245_2_, Random rand, BlockPos position, BlockBlobConfig p_212245_5_) {
        while (position.func_177956_o() > 6 && position.func_177956_o() < 250) {
            Block block;
            if (!worldIn.func_175623_d(position.func_177977_b()) && ((block = worldIn.func_180495_p(position.func_177977_b()).func_177230_c()) == Blocks.field_196658_i || BoulderNormal.func_227250_b_((Block)block))) {
                int radius = 3;
                for (int currentCount = 0; radius >= 0 && currentCount < 3; ++currentCount) {
                    int x = radius + rand.nextInt(2);
                    int y = radius + rand.nextInt(2);
                    int z = radius + rand.nextInt(2);
                    float calculatedDistance = (float)(x + y + z) * 0.333f + 0.5f;
                    for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)position.func_177982_a(-x, -y, -z), (BlockPos)position.func_177982_a(x, y, z))) {
                        if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(calculatedDistance * calculatedDistance))) continue;
                        int randomChance = rand.nextInt(1400);
                        if (ConfigUA.diamondOreSpawnrate != 0 && randomChance == 0) {
                            worldIn.func_180501_a(blockpos, diamondOre, 4);
                            continue;
                        }
                        if (ConfigUA.ironOreSpawnrate != 0 && randomChance <= 40) {
                            worldIn.func_180501_a(blockpos, ironOre, 4);
                            continue;
                        }
                        if (ConfigUA.coalOreSpawnrate != 0 && randomChance <= 100) {
                            worldIn.func_180501_a(blockpos, coalOre, 4);
                            continue;
                        }
                        if (randomChance <= 400) {
                            worldIn.func_180501_a(blockpos, andesite, 4);
                            continue;
                        }
                        if (randomChance <= 700) {
                            worldIn.func_180501_a(blockpos, cobblestone, 4);
                            continue;
                        }
                        worldIn.func_180501_a(blockpos, mossyCobblestone, 4);
                    }
                    position = position.func_177982_a(-(radius + 1) + rand.nextInt(2 + radius * 2), 0 - rand.nextInt(2), -(radius + 1) + rand.nextInt(2 + radius * 2));
                }
                return true;
            }
            position = position.func_177977_b();
        }
        return false;
    }
}

