/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;
import net.telepathicgrunt.ultraamplified.world.feature.config.ColumnBlocksConfig;

public class Column
extends Feature<ColumnBlocksConfig> {
    protected OctavesNoiseGenerator noiseGen;
    protected long seed;

    public void setSeed(long seed) {
        if (this.noiseGen == null) {
            this.noiseGen = new OctavesNoiseGenerator(new SharedSeedRandom(seed), 3, 0);
        }
        this.seed = seed;
    }

    public Column(Function<Dynamic<?>, ? extends ColumnBlocksConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> changedBlock, Random rand, BlockPos position, ColumnBlocksConfig blocksConfig) {
        int currentHeight;
        if (!ConfigUA.pillarGen) {
            return false;
        }
        this.setSeed(rand.nextLong());
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(position);
        int minWidth = 3;
        int maxWidth = 10;
        int ceilingHeight = currentHeight = 0;
        int floorHeight = currentHeight;
        int heightDiff = 0;
        while (!worldIn.func_180495_p(blockpos$Mutable.func_177981_b(currentHeight)).func_200132_m()) {
            if (blockpos$Mutable.func_177981_b(currentHeight).func_177956_o() > 254) {
                return false;
            }
            currentHeight += 2;
        }
        ceilingHeight = blockpos$Mutable.func_177981_b(currentHeight).func_177956_o();
        currentHeight = 0;
        while (!worldIn.func_180495_p(blockpos$Mutable.func_177981_b(currentHeight)).func_200132_m()) {
            if (blockpos$Mutable.func_177981_b(currentHeight).func_177956_o() < 50) {
                return false;
            }
            currentHeight -= 2;
        }
        floorHeight = blockpos$Mutable.func_177981_b(currentHeight).func_177956_o();
        heightDiff = ceilingHeight - floorHeight;
        if (heightDiff > 100 || heightDiff < 10) {
            return false;
        }
        int thinnestWidth = (int)((float)maxWidth * ((float)heightDiff / 100.0f));
        if (thinnestWidth < minWidth) {
            thinnestWidth = minWidth;
        }
        int widthAtHeight = 0;
        int currentWidth = 0;
        widthAtHeight = this.getWidthAtHeight(0, heightDiff, thinnestWidth);
        for (int x = position.func_177958_n() - widthAtHeight; x <= position.func_177958_n() + widthAtHeight; x += 3) {
            for (int z = position.func_177952_p() - widthAtHeight; z <= position.func_177952_p() + widthAtHeight; z += 3) {
                int zDiff;
                int xDiff = x - position.func_177958_n();
                if (xDiff * xDiff + (zDiff = z - position.func_177952_p()) * zDiff > widthAtHeight * widthAtHeight) continue;
                BlockState block1 = worldIn.func_180495_p((BlockPos)blockpos$Mutable.func_181079_c(x, ceilingHeight + 3, z));
                BlockState block2 = worldIn.func_180495_p((BlockPos)blockpos$Mutable.func_181079_c(x, floorHeight - 2, z));
                if (block1.func_200132_m() && block2.func_200132_m()) continue;
                return false;
            }
        }
        int xMod = 0;
        int zMod = 0;
        boolean flagImperfection1 = rand.nextBoolean();
        boolean flagImperfection2 = rand.nextBoolean();
        if (flagImperfection1 && flagImperfection2) {
            xMod = heightDiff / 20 + 1;
            zMod = heightDiff / 20 + 1;
        } else if (flagImperfection1) {
            xMod = heightDiff / 20 + 1;
            zMod = 0;
        } else if (flagImperfection2) {
            xMod = 0;
            zMod = heightDiff / 20 + 1;
        } else {
            xMod = 0;
            zMod = 0;
        }
        for (int y = -2; y <= heightDiff + 2; ++y) {
            widthAtHeight = this.getWidthAtHeight(y, heightDiff, thinnestWidth);
            for (int x = position.func_177958_n() - widthAtHeight - xMod - 1; x <= position.func_177958_n() + widthAtHeight + xMod + 1; ++x) {
                for (int z = position.func_177952_p() - widthAtHeight - zMod - 1; z <= position.func_177952_p() + widthAtHeight + zMod + 1; ++z) {
                    int xDiff = x - position.func_177958_n();
                    int zDiff = z - position.func_177952_p();
                    blockpos$Mutable.func_181079_c(x, y + floorHeight, z);
                    boolean flagImperfection3 = this.noiseGen.func_205563_a((double)x * 0.5, (double)z * 0.5, (double)y * 0.5) * 15.0 < 0.0;
                    currentWidth = flagImperfection3 && (widthAtHeight > thinnestWidth || widthAtHeight == thinnestWidth && rand.nextInt(4) == 0) ? widthAtHeight - 1 : widthAtHeight;
                    int xzDiffSquaredStretched = (xMod + 1) * (xDiff * xDiff) + (zMod + 1) * (zDiff * zDiff);
                    int xzDiffSquared = xDiff * xDiff + zDiff * zDiff;
                    if (xzDiffSquaredStretched <= (currentWidth - 1) * (currentWidth - 1)) {
                        BlockState block = worldIn.func_180495_p((BlockPos)blockpos$Mutable);
                        if (block.func_200132_m()) continue;
                        worldIn.func_180501_a((BlockPos)blockpos$Mutable, blocksConfig.insideBlock, 2);
                        continue;
                    }
                    if (y >= heightDiff / 2 || xzDiffSquared > (widthAtHeight + 2) * (widthAtHeight + 2)) continue;
                    for (int downward = 0; downward < 6 && y - downward >= -3; ++downward) {
                        BlockState block = worldIn.func_180495_p(blockpos$Mutable.func_177979_c(downward));
                        if (block != blocksConfig.insideBlock) continue;
                        worldIn.func_180501_a(blockpos$Mutable.func_177979_c(downward), downward == 1 ? blocksConfig.topBlock : blocksConfig.middleBlock, 2);
                    }
                }
            }
        }
        return true;
    }

    private int getWidthAtHeight(int y, int heightDiff, int thinnestWidth) {
        if (heightDiff > 80) {
            float yFromCenter = Math.abs((float)y - (float)heightDiff / 2.0f) - 2.0f;
            return thinnestWidth + (int)(yFromCenter / 4.0f * (yFromCenter / 4.0f) / 10.0f);
        }
        if (heightDiff > 60) {
            float yFromCenter = Math.abs((float)y - (float)heightDiff / 2.0f) - 1.0f;
            return thinnestWidth + (int)(yFromCenter / 3.0f * (yFromCenter / 3.0f) / 9.0f);
        }
        if (heightDiff > 30) {
            float yFromCenter = Math.abs((float)y - (float)heightDiff / 2.0f);
            return thinnestWidth + (int)(yFromCenter / 2.6f * (yFromCenter / 2.6f) / 6.0f);
        }
        if (heightDiff > 18) {
            float yFromCenter = Math.abs((float)y - (float)heightDiff / 2.0f) + 1.0f;
            return thinnestWidth + (int)(yFromCenter / 2.8f * (yFromCenter / 2.8f) / 3.0f);
        }
        float yFromCenter = Math.abs((float)y - (float)heightDiff / 2.0f) + 3.0f;
        return thinnestWidth + (int)(yFromCenter / 2.7f * (yFromCenter / 2.7f) / 3.0f);
    }
}

