/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.placement.CountConfig;
import net.telepathicgrunt.ultraamplified.blocks.BlocksInit;

public class GlowPatch
extends Feature<CountConfig> {
    private Map<BlockState, BlockState> GLOWBLOCKMAP;

    public GlowPatch(Function<Dynamic<?>, ? extends CountConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> chunkSettings, Random rand, BlockPos pos, CountConfig countConfig) {
        if (this.GLOWBLOCKMAP == null) {
            HashMap<BlockState, BlockState> result = new HashMap<BlockState, BlockState>();
            result.put(Blocks.field_150346_d.func_176223_P(), ((Block)BlocksInit.GLOWDIRT.get()).func_176223_P());
            result.put(Blocks.field_196660_k.func_176223_P(), ((Block)BlocksInit.COARSE_GLOWDIRT.get()).func_176223_P());
            result.put(Blocks.field_196658_i.func_176223_P(), ((Block)BlocksInit.GLOWGRASS_BLOCK.get()).func_176223_P());
            result.put(Blocks.field_150391_bh.func_176223_P(), ((Block)BlocksInit.GLOWMYCELIUM.get()).func_176223_P());
            result.put(Blocks.field_150348_b.func_176223_P(), ((Block)BlocksInit.GLOWSTONE_ORE.get()).func_176223_P());
            result.put(Blocks.field_196661_l.func_176223_P(), ((Block)BlocksInit.GLOWPODZOL.get()).func_176223_P());
            result.put(Blocks.field_150354_m.func_176223_P(), ((Block)BlocksInit.GLOWSAND.get()).func_176223_P());
            result.put(Blocks.field_196611_F.func_176223_P(), ((Block)BlocksInit.REDGLOWSAND.get()).func_176223_P());
            this.GLOWBLOCKMAP = result;
        }
        boolean generatedSuccessfully = false;
        for (int attempts = 0; attempts < countConfig.field_204915_a; ++attempts) {
            int gausX = (int)Math.max(Math.min(rand.nextGaussian() * 3.0, 16.0), -16.0);
            int gausY = rand.nextInt(4) - rand.nextInt(4);
            int gausZ = (int)Math.max(Math.min(rand.nextGaussian() * 3.0, 16.0), -16.0);
            BlockPos blockpos = pos.func_177982_a(gausX, gausY, gausZ);
            BlockState chosenBlock = worldIn.func_180495_p(blockpos);
            BlockState chosenAboveBlock = worldIn.func_180495_p(blockpos.func_177984_a());
            if (chosenBlock.func_185904_a() == Material.field_151579_a) continue;
            if (chosenBlock == Blocks.field_150348_b.func_176223_P()) {
                worldIn.func_180501_a(blockpos, this.GLOWBLOCKMAP.get(chosenBlock), 2);
                generatedSuccessfully = true;
                continue;
            }
            if (!this.GLOWBLOCKMAP.containsKey(chosenBlock) || chosenAboveBlock.func_185904_a() != Material.field_151579_a) continue;
            worldIn.func_180501_a(blockpos, this.GLOWBLOCKMAP.get(chosenBlock), 2);
            generatedSuccessfully = true;
        }
        return generatedSuccessfully;
    }
}

