/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class RareNetherSurfaceLava
extends Feature<NoFeatureConfig> {
    private static final BlockState LAVA = Blocks.field_150353_l.func_176223_P();
    private static final FlowingFluid LAVA_FLUID = Fluids.field_204547_b;
    private static final BlockState GRAVEL = Blocks.field_150351_n.func_176223_P();
    private static final BlockState SOUL_SAND = Blocks.field_150425_aM.func_176223_P();
    private static final BlockState NETHERRACK = Blocks.field_150424_aL.func_176223_P();
    public final Set<Block> acceptableSurroundingBlocks = ImmutableSet.of((Object)Blocks.field_150424_aL, (Object)Blocks.field_150351_n, (Object)Blocks.field_150425_aM, (Object)Blocks.field_196814_hQ, (Object)Blocks.field_196766_fg, (Object)Blocks.field_196653_dH, (Object[])new Block[0]);

    public RareNetherSurfaceLava(Function<Dynamic<?>, ? extends NoFeatureConfig> p_i51430_1_) {
        super(p_i51430_1_);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        BlockState blockstate = worldIn.func_180495_p(pos);
        boolean generateLava = false;
        int solidSurrounding = 0;
        if (this.acceptableSurroundingBlocks.contains(worldIn.func_180495_p(pos.func_177976_e()).func_177230_c())) {
            ++solidSurrounding;
        }
        if (this.acceptableSurroundingBlocks.contains(worldIn.func_180495_p(pos.func_177974_f()).func_177230_c())) {
            ++solidSurrounding;
        }
        if (this.acceptableSurroundingBlocks.contains(worldIn.func_180495_p(pos.func_177978_c()).func_177230_c())) {
            ++solidSurrounding;
        }
        if (this.acceptableSurroundingBlocks.contains(worldIn.func_180495_p(pos.func_177968_d()).func_177230_c())) {
            ++solidSurrounding;
        }
        if (solidSurrounding < 3) {
            return false;
        }
        if (blockstate == GRAVEL) {
            if (this.acceptableSurroundingBlocks.contains(worldIn.func_180495_p(pos.func_177977_b()).func_177230_c())) {
                generateLava = true;
            }
        } else if (blockstate == SOUL_SAND) {
            if ((double)rand.nextFloat() < 0.33) {
                generateLava = true;
            }
        } else if (blockstate == NETHERRACK && (double)rand.nextFloat() < 0.033) {
            generateLava = true;
        }
        if (generateLava) {
            worldIn.func_180501_a(pos, LAVA, 2);
            worldIn.func_205219_F_().func_205360_a(pos, (Object)LAVA_FLUID, 0);
        }
        return true;
    }
}

