/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.VineBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;
import net.telepathicgrunt.ultraamplified.world.feature.config.BlockConfig;

public class Roots
extends Feature<BlockConfig> {
    protected long seed;
    protected OctavesNoiseGenerator noiseGen;

    public Roots(Function<Dynamic<?>, ? extends BlockConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public void setSeed(long seed) {
        if (this.noiseGen == null) {
            this.noiseGen = new OctavesNoiseGenerator(new SharedSeedRandom(seed), 3, 0);
        }
        this.seed = seed;
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> changedBlock, Random rand, BlockPos position, BlockConfig blockConfig) {
        this.setSeed(rand.nextLong());
        if (!ConfigUA.rootGen || !worldIn.func_180495_p(position).func_200132_m()) {
            return false;
        }
        position = position.func_177977_b();
        BlockPos.Mutable Mutable2 = new BlockPos.Mutable();
        int numOfRoots = 1 + (position.func_177956_o() - 70) / 50;
        block0: for (int rootNum = 1; rootNum < numOfRoots + 1; ++rootNum) {
            Mutable2.func_189533_g((Vec3i)position);
            int rootLength = 2 + (position.func_177956_o() - 70) / 22;
            for (int length = 0; length < rootLength; ++length) {
                BlockState currentBlockState = worldIn.func_180495_p((BlockPos)Mutable2);
                if (Mutable2.func_177956_o() > position.func_177956_o() || currentBlockState.func_185904_a() != Material.field_151579_a && currentBlockState != blockConfig.block.func_176223_P() && currentBlockState != Blocks.field_150395_bd.func_176223_P() || !worldIn.func_180495_p(new BlockPos(Mutable2.func_177958_n(), position.func_177956_o() + 1, Mutable2.func_177952_p())).func_200132_m()) continue block0;
                worldIn.func_180501_a((BlockPos)Mutable2, blockConfig.block.func_176223_P(), 2);
                if (rand.nextFloat() < 0.13f) {
                    this.generateTinyVine(worldIn, rand, (BlockPos)Mutable2);
                }
                int xOffset = (int)MathHelper.func_151237_a((double)(this.noiseGen.func_205563_a((double)Mutable2.func_177958_n() * 2.0 + (double)(20000 * rootNum), (double)Mutable2.func_177952_p() * 2.0 + (double)(20000 * rootNum), (double)Mutable2.func_177956_o() * 1.0 + (double)(20000 * rootNum)) * 15.0), (double)-1.0, (double)1.0);
                int zOffset = (int)MathHelper.func_151237_a((double)(this.noiseGen.func_205563_a((double)Mutable2.func_177958_n() * 2.0 + (double)(10000 * rootNum), (double)Mutable2.func_177952_p() * 2.0 + (double)(10000 * rootNum), (double)Mutable2.func_177956_o() * 1.0 + (double)(10000 * rootNum)) * 15.0), (double)-1.0, (double)1.0);
                int yOffset = (int)MathHelper.func_151237_a((double)(this.noiseGen.func_205563_a((double)Mutable2.func_177958_n() * 2.0 - (double)(10000 * rootNum), (double)Mutable2.func_177952_p() * 2.0 - (double)(10000 * rootNum), (double)Mutable2.func_177956_o() * 1.0 - 10000.0) * 15.0 * (double)rootNum - 1.0), (double)-1.0, (double)1.0);
                Mutable2.func_196234_d(xOffset, yOffset, zOffset);
            }
        }
        return true;
    }

    private void generateTinyVine(IWorld worldIn, Random rand, BlockPos position) {
        int length = 0;
        Direction face = Direction.Plane.HORIZONTAL.func_179518_a(rand);
        position.func_177972_a(face);
        while (position.func_177956_o() > 1 && length < 5 && worldIn.func_175623_d(position)) {
            for (Direction Direction2 : Direction.Plane.HORIZONTAL) {
                BlockState iblockstate = (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((IProperty)VineBlock.func_176267_a((Direction)Direction2), (Comparable)Boolean.valueOf(true));
                if (iblockstate.func_196955_c((IWorldReader)worldIn, position)) {
                    worldIn.func_180501_a(position, iblockstate, 2);
                    ++length;
                    break;
                }
                if (worldIn.func_180495_p(position.func_177984_a()).func_177230_c() != Blocks.field_150395_bd) continue;
                worldIn.func_180501_a(position, worldIn.func_180495_p(position.func_177984_a()), 2);
                ++length;
                break;
            }
            position = position.func_177977_b();
        }
    }
}

